/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.time.Duration;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.mirror.MirrorConnectorConfig;

public class MirrorHeartbeatConfig
extends MirrorConnectorConfig {
    protected static final String EMIT_HEARTBEATS = "emit.heartbeats";
    public static final String HEARTBEATS_TOPIC_REPLICATION_FACTOR = "heartbeats.topic.replication.factor";
    public static final String HEARTBEATS_TOPIC_REPLICATION_FACTOR_DOC = "Replication factor for heartbeats topic.";
    public static final short HEARTBEATS_TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
    public static final String EMIT_HEARTBEATS_ENABLED = "emit.heartbeats.enabled";
    private static final String EMIT_HEARTBEATS_ENABLED_DOC = "Whether to emit heartbeats to target cluster.";
    public static final boolean EMIT_HEARTBEATS_ENABLED_DEFAULT = true;
    public static final String EMIT_HEARTBEATS_INTERVAL_SECONDS = "emit.heartbeats.interval.seconds";
    private static final String EMIT_HEARTBEATS_INTERVAL_SECONDS_DOC = "Frequency of heartbeats.";
    public static final long EMIT_HEARTBEATS_INTERVAL_SECONDS_DEFAULT = 1L;
    protected static final ConfigDef CONNECTOR_CONFIG_DEF = new ConfigDef(BASE_CONNECTOR_CONFIG_DEF).define("emit.heartbeats.enabled", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Whether to emit heartbeats to target cluster.").define("emit.heartbeats.interval.seconds", ConfigDef.Type.LONG, (Object)1L, ConfigDef.Importance.LOW, "Frequency of heartbeats.").define("heartbeats.topic.replication.factor", ConfigDef.Type.SHORT, (Object)3, ConfigDef.Importance.LOW, "Replication factor for heartbeats topic.");

    public MirrorHeartbeatConfig(Map<String, String> props) {
        super(CONNECTOR_CONFIG_DEF, props);
    }

    @Override
    String connectorName() {
        return this.getString("name");
    }

    String heartbeatsTopic() {
        return this.replicationPolicy().heartbeatsTopic();
    }

    Duration emitHeartbeatsInterval() {
        if (this.getBoolean(EMIT_HEARTBEATS_ENABLED).booleanValue()) {
            return Duration.ofSeconds(this.getLong(EMIT_HEARTBEATS_INTERVAL_SECONDS));
        }
        return Duration.ofMillis(-1L);
    }

    short heartbeatsTopicReplicationFactor() {
        return this.getShort(HEARTBEATS_TOPIC_REPLICATION_FACTOR);
    }

    public static void main(String[] args) {
        System.out.println(CONNECTOR_CONFIG_DEF.toHtml(4, config -> "mirror_heartbeat_" + config));
    }
}

