/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.connect.util.TopicAdmin;

final class MirrorUtils {
    private MirrorUtils() {
    }

    static KafkaProducer<byte[], byte[]> newProducer(Map<String, Object> props) {
        return new KafkaProducer(props, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
    }

    static KafkaConsumer<byte[], byte[]> newConsumer(Map<String, Object> props) {
        return new KafkaConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
    }

    static String encodeTopicPartition(TopicPartition topicPartition) {
        return topicPartition.toString();
    }

    static Map<String, Object> wrapPartition(TopicPartition topicPartition, String sourceClusterAlias) {
        HashMap<String, Object> wrapped = new HashMap<String, Object>();
        wrapped.put("topic", topicPartition.topic());
        wrapped.put("partition", topicPartition.partition());
        wrapped.put("cluster", sourceClusterAlias);
        return wrapped;
    }

    static Map<String, Object> wrapOffset(long offset) {
        return Collections.singletonMap("offset", offset);
    }

    static TopicPartition unwrapPartition(Map<String, ?> wrapped) {
        String topic = (String)wrapped.get("topic");
        int partition = (Integer)wrapped.get("partition");
        return new TopicPartition(topic, partition);
    }

    static Long unwrapOffset(Map<String, ?> wrapped) {
        if (wrapped == null || wrapped.get("offset") == null) {
            return -1L;
        }
        return (Long)wrapped.get("offset");
    }

    static TopicPartition decodeTopicPartition(String topicPartitionString) {
        int sep = topicPartitionString.lastIndexOf(45);
        String topic = topicPartitionString.substring(0, sep);
        String partitionString = topicPartitionString.substring(sep + 1);
        int partition = Integer.parseInt(partitionString);
        return new TopicPartition(topic, partition);
    }

    static Pattern compilePatternList(List<String> fields) {
        if (fields.isEmpty()) {
            return null;
        }
        String joined = String.join((CharSequence)"|", fields);
        return Pattern.compile(joined);
    }

    static Pattern compilePatternList(String fields) {
        return MirrorUtils.compilePatternList(Arrays.asList(fields.split("\\W*,\\W*")));
    }

    static void createCompactedTopic(String topicName, short partitions, short replicationFactor, Map<String, Object> adminProps) {
        NewTopic topicDescription = TopicAdmin.defineTopic((String)topicName).compacted().partitions((int)partitions).replicationFactor(replicationFactor).build();
        try (TopicAdmin admin = new TopicAdmin(adminProps);){
            admin.createTopics(new NewTopic[]{topicDescription});
        }
    }

    static void createSinglePartitionCompactedTopic(String topicName, short replicationFactor, Map<String, Object> adminProps) {
        MirrorUtils.createCompactedTopic(topicName, (short)1, replicationFactor, adminProps);
    }
}

