/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.common.cache.Cache;
import org.apache.kafka.common.cache.LRUCache;
import org.apache.kafka.common.cache.SynchronizedCache;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.json.JsonDeserializer;
import org.apache.kafka.connect.json.JsonSchema;
import org.apache.kafka.connect.json.JsonSerializer;
import org.apache.kafka.connect.storage.Converter;

public class JsonConverter
implements Converter {
    private static final String SCHEMAS_ENABLE_CONFIG = "schemas.enable";
    private static final boolean SCHEMAS_ENABLE_DEFAULT = true;
    private static final String SCHEMAS_CACHE_SIZE_CONFIG = "schemas.cache.size";
    private static final int SCHEMAS_CACHE_SIZE_DEFAULT = 1000;
    private static final HashMap<Schema.Type, JsonToConnectTypeConverter> TO_CONNECT_CONVERTERS = new HashMap();
    private static final HashMap<String, LogicalTypeConverter> TO_CONNECT_LOGICAL_CONVERTERS;
    private static final HashMap<String, LogicalTypeConverter> TO_JSON_LOGICAL_CONVERTERS;
    private boolean enableSchemas = true;
    private int cacheSize = 1000;
    private Cache<Schema, ObjectNode> fromConnectSchemaCache;
    private Cache<JsonNode, Schema> toConnectSchemaCache;
    private final JsonSerializer serializer = new JsonSerializer();
    private final JsonDeserializer deserializer = new JsonDeserializer();

    public void configure(Map<String, ?> configs, boolean isKey) {
        Object enableConfigsVal = configs.get(SCHEMAS_ENABLE_CONFIG);
        if (enableConfigsVal != null) {
            this.enableSchemas = enableConfigsVal.toString().equals("true");
        }
        this.serializer.configure(configs, isKey);
        this.deserializer.configure(configs, isKey);
        Object cacheSizeVal = configs.get(SCHEMAS_CACHE_SIZE_CONFIG);
        if (cacheSizeVal != null) {
            this.cacheSize = Integer.parseInt((String)cacheSizeVal);
        }
        this.fromConnectSchemaCache = new SynchronizedCache((Cache)new LRUCache(this.cacheSize));
        this.toConnectSchemaCache = new SynchronizedCache((Cache)new LRUCache(this.cacheSize));
    }

    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        JsonNode jsonValue = this.enableSchemas ? this.convertToJsonWithEnvelope(schema, value) : this.convertToJsonWithoutEnvelope(schema, value);
        try {
            return this.serializer.serialize(topic, jsonValue);
        }
        catch (SerializationException e) {
            throw new DataException("Converting Kafka Connect data to byte[] failed due to serialization error: ", (Throwable)e);
        }
    }

    public SchemaAndValue toConnectData(String topic, byte[] value) {
        JsonNode jsonValue;
        try {
            jsonValue = this.deserializer.deserialize(topic, value);
        }
        catch (SerializationException e) {
            throw new DataException("Converting byte[] to Kafka Connect data failed due to serialization error: ", (Throwable)e);
        }
        if (!(!this.enableSchemas || jsonValue != null && jsonValue.isObject() && jsonValue.size() == 2 && jsonValue.has("schema") && jsonValue.has("payload"))) {
            throw new DataException("JsonDeserializer with schemas.enable requires \"schema\" and \"payload\" fields and may not contain additional fields");
        }
        if (!this.enableSchemas) {
            ObjectNode envelope = JsonNodeFactory.instance.objectNode();
            envelope.set("schema", null);
            envelope.set("payload", jsonValue);
            jsonValue = envelope;
        }
        return this.jsonToConnect(jsonValue);
    }

    private SchemaAndValue jsonToConnect(JsonNode jsonValue) {
        if (jsonValue == null) {
            return SchemaAndValue.NULL;
        }
        if (!(jsonValue.isObject() && jsonValue.size() == 2 && jsonValue.has("schema") && jsonValue.has("payload"))) {
            throw new DataException("JSON value converted to Kafka Connect must be in envelope containing schema");
        }
        Schema schema = this.asConnectSchema(jsonValue.get("schema"));
        return new SchemaAndValue(schema, JsonConverter.convertToConnect(schema, jsonValue.get("payload")));
    }

    private ObjectNode asJsonSchema(Schema schema) {
        ObjectNode jsonSchema;
        if (schema == null) {
            return null;
        }
        ObjectNode cached = (ObjectNode)this.fromConnectSchemaCache.get((Object)schema);
        if (cached != null) {
            return cached;
        }
        switch (schema.type()) {
            case BOOLEAN: {
                jsonSchema = JsonSchema.BOOLEAN_SCHEMA.deepCopy();
                break;
            }
            case BYTES: {
                jsonSchema = JsonSchema.BYTES_SCHEMA.deepCopy();
                break;
            }
            case FLOAT64: {
                jsonSchema = JsonSchema.DOUBLE_SCHEMA.deepCopy();
                break;
            }
            case FLOAT32: {
                jsonSchema = JsonSchema.FLOAT_SCHEMA.deepCopy();
                break;
            }
            case INT8: {
                jsonSchema = JsonSchema.INT8_SCHEMA.deepCopy();
                break;
            }
            case INT16: {
                jsonSchema = JsonSchema.INT16_SCHEMA.deepCopy();
                break;
            }
            case INT32: {
                jsonSchema = JsonSchema.INT32_SCHEMA.deepCopy();
                break;
            }
            case INT64: {
                jsonSchema = JsonSchema.INT64_SCHEMA.deepCopy();
                break;
            }
            case STRING: {
                jsonSchema = JsonSchema.STRING_SCHEMA.deepCopy();
                break;
            }
            case ARRAY: {
                jsonSchema = JsonNodeFactory.instance.objectNode().put("type", "array");
                jsonSchema.set("items", (JsonNode)this.asJsonSchema(schema.valueSchema()));
                break;
            }
            case MAP: {
                jsonSchema = JsonNodeFactory.instance.objectNode().put("type", "map");
                jsonSchema.set("keys", (JsonNode)this.asJsonSchema(schema.keySchema()));
                jsonSchema.set("values", (JsonNode)this.asJsonSchema(schema.valueSchema()));
                break;
            }
            case STRUCT: {
                jsonSchema = JsonNodeFactory.instance.objectNode().put("type", "struct");
                ArrayNode fields = JsonNodeFactory.instance.arrayNode();
                for (Field field : schema.fields()) {
                    ObjectNode fieldJsonSchema = this.asJsonSchema(field.schema()).deepCopy();
                    fieldJsonSchema.put("field", field.name());
                    fields.add((JsonNode)fieldJsonSchema);
                }
                jsonSchema.set("fields", (JsonNode)fields);
                break;
            }
            default: {
                throw new DataException("Couldn't translate unsupported schema type " + schema + ".");
            }
        }
        jsonSchema.put("optional", schema.isOptional());
        if (schema.name() != null) {
            jsonSchema.put("name", schema.name());
        }
        if (schema.version() != null) {
            jsonSchema.put("version", schema.version());
        }
        if (schema.doc() != null) {
            jsonSchema.put("doc", schema.doc());
        }
        if (schema.parameters() != null) {
            ObjectNode jsonSchemaParams = JsonNodeFactory.instance.objectNode();
            for (Map.Entry entry : schema.parameters().entrySet()) {
                jsonSchemaParams.put((String)entry.getKey(), (String)entry.getValue());
            }
            jsonSchema.set("parameters", (JsonNode)jsonSchemaParams);
        }
        if (schema.defaultValue() != null) {
            jsonSchema.set("default", JsonConverter.convertToJson(schema, schema.defaultValue()));
        }
        this.fromConnectSchemaCache.put((Object)schema, (Object)jsonSchema);
        return jsonSchema;
    }

    private Schema asConnectSchema(JsonNode jsonSchema) {
        JsonNode schemaDefaultNode;
        JsonNode schemaParamsNode;
        JsonNode schemaDocNode;
        JsonNode schemaVersionNode;
        SchemaBuilder builder;
        if (jsonSchema.isNull()) {
            return null;
        }
        Schema cached = (Schema)this.toConnectSchemaCache.get((Object)jsonSchema);
        if (cached != null) {
            return cached;
        }
        JsonNode schemaTypeNode = jsonSchema.get("type");
        if (schemaTypeNode == null || !schemaTypeNode.isTextual()) {
            throw new DataException("Schema must contain 'type' field");
        }
        switch (schemaTypeNode.textValue()) {
            case "boolean": {
                builder = SchemaBuilder.bool();
                break;
            }
            case "int8": {
                builder = SchemaBuilder.int8();
                break;
            }
            case "int16": {
                builder = SchemaBuilder.int16();
                break;
            }
            case "int32": {
                builder = SchemaBuilder.int32();
                break;
            }
            case "int64": {
                builder = SchemaBuilder.int64();
                break;
            }
            case "float": {
                builder = SchemaBuilder.float32();
                break;
            }
            case "double": {
                builder = SchemaBuilder.float64();
                break;
            }
            case "bytes": {
                builder = SchemaBuilder.bytes();
                break;
            }
            case "string": {
                builder = SchemaBuilder.string();
                break;
            }
            case "array": {
                JsonNode elemSchema = jsonSchema.get("items");
                if (elemSchema == null) {
                    throw new DataException("Array schema did not specify the element type");
                }
                builder = SchemaBuilder.array((Schema)this.asConnectSchema(elemSchema));
                break;
            }
            case "map": {
                JsonNode keySchema = jsonSchema.get("keys");
                if (keySchema == null) {
                    throw new DataException("Map schema did not specify the key type");
                }
                JsonNode valueSchema = jsonSchema.get("values");
                if (valueSchema == null) {
                    throw new DataException("Map schema did not specify the value type");
                }
                builder = SchemaBuilder.map((Schema)this.asConnectSchema(keySchema), (Schema)this.asConnectSchema(valueSchema));
                break;
            }
            case "struct": {
                builder = SchemaBuilder.struct();
                JsonNode fields = jsonSchema.get("fields");
                if (fields == null || !fields.isArray()) {
                    throw new DataException("Struct schema's \"fields\" argument is not an array.");
                }
                for (JsonNode field : fields) {
                    JsonNode jsonFieldName = field.get("field");
                    if (jsonFieldName == null || !jsonFieldName.isTextual()) {
                        throw new DataException("Struct schema's field name not specified properly");
                    }
                    builder.field(jsonFieldName.asText(), this.asConnectSchema(field));
                }
                break;
            }
            default: {
                throw new DataException("Unknown schema type: " + schemaTypeNode.textValue());
            }
        }
        JsonNode schemaOptionalNode = jsonSchema.get("optional");
        if (schemaOptionalNode != null && schemaOptionalNode.isBoolean() && schemaOptionalNode.booleanValue()) {
            builder.optional();
        } else {
            builder.required();
        }
        JsonNode schemaNameNode = jsonSchema.get("name");
        if (schemaNameNode != null && schemaNameNode.isTextual()) {
            builder.name(schemaNameNode.textValue());
        }
        if ((schemaVersionNode = jsonSchema.get("version")) != null && schemaVersionNode.isIntegralNumber()) {
            builder.version(Integer.valueOf(schemaVersionNode.intValue()));
        }
        if ((schemaDocNode = jsonSchema.get("doc")) != null && schemaDocNode.isTextual()) {
            builder.doc(schemaDocNode.textValue());
        }
        if ((schemaParamsNode = jsonSchema.get("parameters")) != null && schemaParamsNode.isObject()) {
            Iterator paramsIt = schemaParamsNode.fields();
            while (paramsIt.hasNext()) {
                Map.Entry entry = (Map.Entry)paramsIt.next();
                JsonNode paramValue = (JsonNode)entry.getValue();
                if (!paramValue.isTextual()) {
                    throw new DataException("Schema parameters must have string values.");
                }
                builder.parameter((String)entry.getKey(), paramValue.textValue());
            }
        }
        if ((schemaDefaultNode = jsonSchema.get("default")) != null) {
            builder.defaultValue(JsonConverter.convertToConnect((Schema)builder, schemaDefaultNode));
        }
        Schema result = builder.build();
        this.toConnectSchemaCache.put((Object)jsonSchema, (Object)result);
        return result;
    }

    private JsonNode convertToJsonWithEnvelope(Schema schema, Object value) {
        return new JsonSchema.Envelope((JsonNode)this.asJsonSchema(schema), JsonConverter.convertToJson(schema, value)).toJsonNode();
    }

    private JsonNode convertToJsonWithoutEnvelope(Schema schema, Object value) {
        return JsonConverter.convertToJson(schema, value);
    }

    /*
     * Unable to fully structure code
     */
    private static JsonNode convertToJson(Schema schema, Object logicalValue) {
        if (logicalValue == null) {
            if (schema == null) {
                return null;
            }
            if (schema.defaultValue() != null) {
                return JsonConverter.convertToJson(schema, schema.defaultValue());
            }
            if (schema.isOptional()) {
                return JsonNodeFactory.instance.nullNode();
            }
            throw new DataException("Conversion error: null value for field that is required and has no default value");
        }
        value = logicalValue;
        if (schema != null && schema.name() != null && (logicalConverter = JsonConverter.TO_JSON_LOGICAL_CONVERTERS.get(schema.name())) != null) {
            value = logicalConverter.convert(schema, logicalValue);
        }
        try {
            if (schema == null) {
                schemaType = ConnectSchema.schemaType(value.getClass());
                if (schemaType == null) {
                    throw new DataException("Java class " + value.getClass() + " does not have corresponding schema type.");
                }
            } else {
                schemaType = schema.type();
            }
            switch (21.$SwitchMap$org$apache$kafka$connect$data$Schema$Type[schemaType.ordinal()]) {
                case 5: {
                    return JsonNodeFactory.instance.numberNode((Byte)value);
                }
                case 6: {
                    return JsonNodeFactory.instance.numberNode((Short)value);
                }
                case 7: {
                    return JsonNodeFactory.instance.numberNode((Integer)value);
                }
                case 8: {
                    return JsonNodeFactory.instance.numberNode((Long)value);
                }
                case 4: {
                    return JsonNodeFactory.instance.numberNode((Float)value);
                }
                case 3: {
                    return JsonNodeFactory.instance.numberNode((Double)value);
                }
                case 1: {
                    return JsonNodeFactory.instance.booleanNode(((Boolean)value).booleanValue());
                }
                case 9: {
                    charSeq = (CharSequence)value;
                    return JsonNodeFactory.instance.textNode(charSeq.toString());
                }
                case 2: {
                    if (value instanceof byte[]) {
                        return JsonNodeFactory.instance.binaryNode((byte[])value);
                    }
                    if (value instanceof ByteBuffer) {
                        return JsonNodeFactory.instance.binaryNode(((ByteBuffer)value).array());
                    }
                    throw new DataException("Invalid type for bytes type: " + value.getClass());
                }
                case 10: {
                    collection = (Collection)value;
                    list = JsonNodeFactory.instance.arrayNode();
                    for (E elem : collection) {
                        valueSchema = schema == null ? null : schema.valueSchema();
                        fieldValue = JsonConverter.convertToJson(valueSchema, elem);
                        list.add(fieldValue);
                    }
                    return list;
                }
                case 11: {
                    map = (Map)value;
                    if (schema != null) ** GOTO lbl62
                    objectMode = true;
                    for (Map.Entry<K, V> entry : map.entrySet()) {
                        if (entry.getKey() instanceof String) continue;
                        objectMode = false;
                        ** GOTO lbl63
                    }
                    ** GOTO lbl63
lbl62:
                    // 1 sources

                    objectMode = schema.keySchema().type() == Schema.Type.STRING;
lbl63:
                    // 3 sources

                    obj = null;
                    list = null;
                    if (objectMode) {
                        obj = JsonNodeFactory.instance.objectNode();
                    } else {
                        list = JsonNodeFactory.instance.arrayNode();
                    }
                    for (Map.Entry<K, V> entry : map.entrySet()) {
                        keySchema = schema == null ? null : schema.keySchema();
                        valueSchema = schema == null ? null : schema.valueSchema();
                        mapKey = JsonConverter.convertToJson(keySchema, entry.getKey());
                        mapValue = JsonConverter.convertToJson(valueSchema, entry.getValue());
                        if (objectMode) {
                            obj.set(mapKey.asText(), mapValue);
                            continue;
                        }
                        list.add((JsonNode)JsonNodeFactory.instance.arrayNode().add(mapKey).add(mapValue));
                    }
                    return objectMode != false ? obj : list;
                }
                case 12: {
                    struct = (Struct)value;
                    if (struct.schema() != schema) {
                        throw new DataException("Mismatching schema.");
                    }
                    obj = JsonNodeFactory.instance.objectNode();
                    for (Field field : schema.fields()) {
                        obj.set(field.name(), JsonConverter.convertToJson(field.schema(), struct.get(field)));
                    }
                    return obj;
                }
            }
            throw new DataException("Couldn't convert " + value + " to JSON.");
        }
        catch (ClassCastException e) {
            throw new DataException("Invalid type for " + schema.type() + ": " + value.getClass());
        }
    }

    private static Object convertToConnect(Schema schema, JsonNode jsonValue) {
        LogicalTypeConverter logicalConverter;
        JsonToConnectTypeConverter typeConverter;
        Schema.Type schemaType;
        if (schema != null) {
            schemaType = schema.type();
            if (jsonValue.isNull()) {
                if (schema.defaultValue() != null) {
                    return schema.defaultValue();
                }
                if (schema.isOptional()) {
                    return null;
                }
                throw new DataException("Invalid null value for required " + schemaType + " field");
            }
        } else {
            switch (jsonValue.getNodeType()) {
                case NULL: {
                    return null;
                }
                case BOOLEAN: {
                    schemaType = Schema.Type.BOOLEAN;
                    break;
                }
                case NUMBER: {
                    if (jsonValue.isIntegralNumber()) {
                        schemaType = Schema.Type.INT64;
                        break;
                    }
                    schemaType = Schema.Type.FLOAT64;
                    break;
                }
                case ARRAY: {
                    schemaType = Schema.Type.ARRAY;
                    break;
                }
                case OBJECT: {
                    schemaType = Schema.Type.MAP;
                    break;
                }
                case STRING: {
                    schemaType = Schema.Type.STRING;
                    break;
                }
                default: {
                    schemaType = null;
                }
            }
        }
        if ((typeConverter = TO_CONNECT_CONVERTERS.get(schemaType)) == null) {
            throw new DataException("Unknown schema type: " + String.valueOf(schemaType));
        }
        Object converted = typeConverter.convert(schema, jsonValue);
        if (schema != null && schema.name() != null && (logicalConverter = TO_CONNECT_LOGICAL_CONVERTERS.get(schema.name())) != null) {
            converted = logicalConverter.convert(schema, converted);
        }
        return converted;
    }

    static {
        TO_CONNECT_CONVERTERS.put(Schema.Type.BOOLEAN, new JsonToConnectTypeConverter(){

            @Override
            public Object convert(Schema schema, JsonNode value) {
                return value.booleanValue();
            }
        });
        TO_CONNECT_CONVERTERS.put(Schema.Type.INT8, new JsonToConnectTypeConverter(){

            @Override
            public Object convert(Schema schema, JsonNode value) {
                return (byte)value.intValue();
            }
        });
        TO_CONNECT_CONVERTERS.put(Schema.Type.INT16, new JsonToConnectTypeConverter(){

            @Override
            public Object convert(Schema schema, JsonNode value) {
                return (short)value.intValue();
            }
        });
        TO_CONNECT_CONVERTERS.put(Schema.Type.INT32, new JsonToConnectTypeConverter(){

            @Override
            public Object convert(Schema schema, JsonNode value) {
                return value.intValue();
            }
        });
        TO_CONNECT_CONVERTERS.put(Schema.Type.INT64, new JsonToConnectTypeConverter(){

            @Override
            public Object convert(Schema schema, JsonNode value) {
                return value.longValue();
            }
        });
        TO_CONNECT_CONVERTERS.put(Schema.Type.FLOAT32, new JsonToConnectTypeConverter(){

            @Override
            public Object convert(Schema schema, JsonNode value) {
                return Float.valueOf(value.floatValue());
            }
        });
        TO_CONNECT_CONVERTERS.put(Schema.Type.FLOAT64, new JsonToConnectTypeConverter(){

            @Override
            public Object convert(Schema schema, JsonNode value) {
                return value.doubleValue();
            }
        });
        TO_CONNECT_CONVERTERS.put(Schema.Type.BYTES, new JsonToConnectTypeConverter(){

            @Override
            public Object convert(Schema schema, JsonNode value) {
                try {
                    return value.binaryValue();
                }
                catch (IOException e) {
                    throw new DataException("Invalid bytes field", (Throwable)e);
                }
            }
        });
        TO_CONNECT_CONVERTERS.put(Schema.Type.STRING, new JsonToConnectTypeConverter(){

            @Override
            public Object convert(Schema schema, JsonNode value) {
                return value.textValue();
            }
        });
        TO_CONNECT_CONVERTERS.put(Schema.Type.ARRAY, new JsonToConnectTypeConverter(){

            @Override
            public Object convert(Schema schema, JsonNode value) {
                Schema elemSchema = schema == null ? null : schema.valueSchema();
                ArrayList<Object> result = new ArrayList<Object>();
                for (JsonNode elem : value) {
                    result.add(JsonConverter.convertToConnect(elemSchema, elem));
                }
                return result;
            }
        });
        TO_CONNECT_CONVERTERS.put(Schema.Type.MAP, new JsonToConnectTypeConverter(){

            @Override
            public Object convert(Schema schema, JsonNode value) {
                Schema keySchema = schema == null ? null : schema.keySchema();
                Schema valueSchema = schema == null ? null : schema.valueSchema();
                HashMap<Object, Object> result = new HashMap<Object, Object>();
                if (schema == null || keySchema.type() == Schema.Type.STRING) {
                    if (!value.isObject()) {
                        throw new DataException("Maps with string fields should be encoded as JSON objects, but found " + value.getNodeType());
                    }
                    Iterator fieldIt = value.fields();
                    while (fieldIt.hasNext()) {
                        Map.Entry entry = (Map.Entry)fieldIt.next();
                        result.put(entry.getKey(), JsonConverter.convertToConnect(valueSchema, (JsonNode)entry.getValue()));
                    }
                } else {
                    if (!value.isArray()) {
                        throw new DataException("Maps with non-string fields should be encoded as JSON array of tuples, but found " + value.getNodeType());
                    }
                    for (JsonNode entry : value) {
                        if (!entry.isArray()) {
                            throw new DataException("Found invalid map entry instead of array tuple: " + entry.getNodeType());
                        }
                        if (entry.size() != 2) {
                            throw new DataException("Found invalid map entry, expected length 2 but found :" + entry.size());
                        }
                        result.put(JsonConverter.convertToConnect(keySchema, entry.get(0)), JsonConverter.convertToConnect(valueSchema, entry.get(1)));
                    }
                }
                return result;
            }
        });
        TO_CONNECT_CONVERTERS.put(Schema.Type.STRUCT, new JsonToConnectTypeConverter(){

            @Override
            public Object convert(Schema schema, JsonNode value) {
                if (!value.isObject()) {
                    throw new DataException("Structs should be encoded as JSON objects, but found " + value.getNodeType());
                }
                Struct result = new Struct(schema.schema());
                for (Field field : schema.fields()) {
                    result.put(field, JsonConverter.convertToConnect(field.schema(), value.get(field.name())));
                }
                return result;
            }
        });
        TO_CONNECT_LOGICAL_CONVERTERS = new HashMap();
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Decimal", new LogicalTypeConverter(){

            @Override
            public Object convert(Schema schema, Object value) {
                if (!(value instanceof byte[])) {
                    throw new DataException("Invalid type for Decimal, underlying representation should be bytes but was " + value.getClass());
                }
                return Decimal.toLogical((Schema)schema, (byte[])((byte[])value));
            }
        });
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Date", new LogicalTypeConverter(){

            @Override
            public Object convert(Schema schema, Object value) {
                if (!(value instanceof Integer)) {
                    throw new DataException("Invalid type for Date, underlying representation should be int32 but was " + value.getClass());
                }
                return Date.toLogical((Schema)schema, (int)((Integer)value));
            }
        });
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Time", new LogicalTypeConverter(){

            @Override
            public Object convert(Schema schema, Object value) {
                if (!(value instanceof Integer)) {
                    throw new DataException("Invalid type for Time, underlying representation should be int32 but was " + value.getClass());
                }
                return Time.toLogical((Schema)schema, (int)((Integer)value));
            }
        });
        TO_CONNECT_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Timestamp", new LogicalTypeConverter(){

            @Override
            public Object convert(Schema schema, Object value) {
                if (!(value instanceof Long)) {
                    throw new DataException("Invalid type for Timestamp, underlying representation should be int64 but was " + value.getClass());
                }
                return Timestamp.toLogical((Schema)schema, (long)((Long)value));
            }
        });
        TO_JSON_LOGICAL_CONVERTERS = new HashMap();
        TO_JSON_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Decimal", new LogicalTypeConverter(){

            @Override
            public Object convert(Schema schema, Object value) {
                if (!(value instanceof BigDecimal)) {
                    throw new DataException("Invalid type for Decimal, expected BigDecimal but was " + value.getClass());
                }
                return Decimal.fromLogical((Schema)schema, (BigDecimal)((BigDecimal)value));
            }
        });
        TO_JSON_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Date", new LogicalTypeConverter(){

            @Override
            public Object convert(Schema schema, Object value) {
                if (!(value instanceof java.util.Date)) {
                    throw new DataException("Invalid type for Date, expected Date but was " + value.getClass());
                }
                return Date.fromLogical((Schema)schema, (java.util.Date)((java.util.Date)value));
            }
        });
        TO_JSON_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Time", new LogicalTypeConverter(){

            @Override
            public Object convert(Schema schema, Object value) {
                if (!(value instanceof java.util.Date)) {
                    throw new DataException("Invalid type for Time, expected Date but was " + value.getClass());
                }
                return Time.fromLogical((Schema)schema, (java.util.Date)((java.util.Date)value));
            }
        });
        TO_JSON_LOGICAL_CONVERTERS.put("org.apache.kafka.connect.data.Timestamp", new LogicalTypeConverter(){

            @Override
            public Object convert(Schema schema, Object value) {
                if (!(value instanceof java.util.Date)) {
                    throw new DataException("Invalid type for Timestamp, expected Date but was " + value.getClass());
                }
                return Timestamp.fromLogical((Schema)schema, (java.util.Date)((java.util.Date)value));
            }
        });
    }

    private static interface LogicalTypeConverter {
        public Object convert(Schema var1, Object var2);
    }

    private static interface JsonToConnectTypeConverter {
        public Object convert(Schema var1, JsonNode var2);
    }
}

