/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.connect.util.ConnectorUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConnectorUtilsTest {
    private static final List<Integer> FIVE_ELEMENTS = Arrays.asList(1, 2, 3, 4, 5);

    @Test
    public void testGroupPartitions() {
        List grouped = ConnectorUtils.groupPartitions(FIVE_ELEMENTS, (int)1);
        Assertions.assertEquals(Collections.singletonList(FIVE_ELEMENTS), (Object)grouped);
        grouped = ConnectorUtils.groupPartitions(FIVE_ELEMENTS, (int)2);
        Assertions.assertEquals(Arrays.asList(Arrays.asList(1, 2, 3), Arrays.asList(4, 5)), (Object)grouped);
        grouped = ConnectorUtils.groupPartitions(FIVE_ELEMENTS, (int)3);
        Assertions.assertEquals(Arrays.asList(Arrays.asList(1, 2), Arrays.asList(3, 4), Collections.singletonList(5)), (Object)grouped);
        grouped = ConnectorUtils.groupPartitions(FIVE_ELEMENTS, (int)5);
        Assertions.assertEquals(Arrays.asList(Collections.singletonList(1), Collections.singletonList(2), Collections.singletonList(3), Collections.singletonList(4), Collections.singletonList(5)), (Object)grouped);
        grouped = ConnectorUtils.groupPartitions(FIVE_ELEMENTS, (int)7);
        Assertions.assertEquals(Arrays.asList(Collections.singletonList(1), Collections.singletonList(2), Collections.singletonList(3), Collections.singletonList(4), Collections.singletonList(5), Collections.emptyList(), Collections.emptyList()), (Object)grouped);
    }

    @Test
    public void testGroupPartitionsInvalidCount() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ConnectorUtils.groupPartitions(FIVE_ELEMENTS, (int)0));
    }
}

