/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.sink;

import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Values;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.sink.SinkRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SinkRecordTest {
    private static final String TOPIC_NAME = "myTopic";
    private static final Integer PARTITION_NUMBER = 0;
    private static final long KAFKA_OFFSET = 0L;
    private static final Long KAFKA_TIMESTAMP = 0L;
    private static final TimestampType TS_TYPE = TimestampType.CREATE_TIME;
    private SinkRecord record;

    @BeforeEach
    public void beforeEach() {
        this.record = new SinkRecord(TOPIC_NAME, PARTITION_NUMBER.intValue(), Schema.STRING_SCHEMA, (Object)"key", Schema.BOOLEAN_SCHEMA, (Object)false, 0L, KAFKA_TIMESTAMP, TS_TYPE, null);
    }

    @Test
    public void shouldCreateSinkRecordWithHeaders() {
        Headers headers = new ConnectHeaders().addString("h1", "hv1").addBoolean("h2", true);
        this.record = new SinkRecord(TOPIC_NAME, PARTITION_NUMBER.intValue(), Schema.STRING_SCHEMA, (Object)"key", Schema.BOOLEAN_SCHEMA, (Object)false, 0L, KAFKA_TIMESTAMP, TS_TYPE, (Iterable)headers);
        Assertions.assertNotNull((Object)this.record.headers());
        Assertions.assertSame((Object)headers, (Object)this.record.headers());
        Assertions.assertFalse((boolean)this.record.headers().isEmpty());
    }

    @Test
    public void shouldCreateSinkRecordWithEmptyHeaders() {
        Assertions.assertEquals((Object)TOPIC_NAME, (Object)this.record.topic());
        Assertions.assertEquals((Integer)PARTITION_NUMBER, (Integer)this.record.kafkaPartition());
        Assertions.assertEquals((Object)Schema.STRING_SCHEMA, (Object)this.record.keySchema());
        Assertions.assertEquals((Object)"key", (Object)this.record.key());
        Assertions.assertEquals((Object)Schema.BOOLEAN_SCHEMA, (Object)this.record.valueSchema());
        Assertions.assertEquals((Object)false, (Object)this.record.value());
        Assertions.assertEquals((long)0L, (long)this.record.kafkaOffset());
        Assertions.assertEquals((Long)KAFKA_TIMESTAMP, (Long)this.record.timestamp());
        Assertions.assertEquals((Object)TS_TYPE, (Object)this.record.timestampType());
        Assertions.assertNotNull((Object)this.record.headers());
        Assertions.assertTrue((boolean)this.record.headers().isEmpty());
    }

    @Test
    public void shouldDuplicateRecordAndCloneHeaders() {
        SinkRecord duplicate = this.record.newRecord(TOPIC_NAME, PARTITION_NUMBER, Schema.STRING_SCHEMA, (Object)"key", Schema.BOOLEAN_SCHEMA, (Object)false, KAFKA_TIMESTAMP);
        Assertions.assertEquals((Object)TOPIC_NAME, (Object)duplicate.topic());
        Assertions.assertEquals((Integer)PARTITION_NUMBER, (Integer)duplicate.kafkaPartition());
        Assertions.assertEquals((Object)Schema.STRING_SCHEMA, (Object)duplicate.keySchema());
        Assertions.assertEquals((Object)"key", (Object)duplicate.key());
        Assertions.assertEquals((Object)Schema.BOOLEAN_SCHEMA, (Object)duplicate.valueSchema());
        Assertions.assertEquals((Object)false, (Object)duplicate.value());
        Assertions.assertEquals((long)0L, (long)duplicate.kafkaOffset());
        Assertions.assertEquals((Long)KAFKA_TIMESTAMP, (Long)duplicate.timestamp());
        Assertions.assertEquals((Object)TS_TYPE, (Object)duplicate.timestampType());
        Assertions.assertNotNull((Object)duplicate.headers());
        Assertions.assertTrue((boolean)duplicate.headers().isEmpty());
        Assertions.assertNotSame((Object)this.record.headers(), (Object)duplicate.headers());
        Assertions.assertEquals((Object)this.record.headers(), (Object)duplicate.headers());
    }

    @Test
    public void shouldDuplicateRecordUsingNewHeaders() {
        Headers newHeaders = new ConnectHeaders().addString("h3", "hv3");
        SinkRecord duplicate = this.record.newRecord(TOPIC_NAME, PARTITION_NUMBER, Schema.STRING_SCHEMA, (Object)"key", Schema.BOOLEAN_SCHEMA, (Object)false, KAFKA_TIMESTAMP, (Iterable)newHeaders);
        Assertions.assertEquals((Object)TOPIC_NAME, (Object)duplicate.topic());
        Assertions.assertEquals((Integer)PARTITION_NUMBER, (Integer)duplicate.kafkaPartition());
        Assertions.assertEquals((Object)Schema.STRING_SCHEMA, (Object)duplicate.keySchema());
        Assertions.assertEquals((Object)"key", (Object)duplicate.key());
        Assertions.assertEquals((Object)Schema.BOOLEAN_SCHEMA, (Object)duplicate.valueSchema());
        Assertions.assertEquals((Object)false, (Object)duplicate.value());
        Assertions.assertEquals((long)0L, (long)duplicate.kafkaOffset());
        Assertions.assertEquals((Long)KAFKA_TIMESTAMP, (Long)duplicate.timestamp());
        Assertions.assertEquals((Object)TS_TYPE, (Object)duplicate.timestampType());
        Assertions.assertNotNull((Object)duplicate.headers());
        Assertions.assertEquals((Object)newHeaders, (Object)duplicate.headers());
        Assertions.assertSame((Object)newHeaders, (Object)duplicate.headers());
        Assertions.assertNotSame((Object)this.record.headers(), (Object)duplicate.headers());
        Assertions.assertNotEquals((Object)this.record.headers(), (Object)duplicate.headers());
    }

    @Test
    public void shouldModifyRecordHeader() {
        Assertions.assertTrue((boolean)this.record.headers().isEmpty());
        this.record.headers().addInt("intHeader", 100);
        Assertions.assertEquals((int)1, (int)this.record.headers().size());
        Header header = this.record.headers().lastWithName("intHeader");
        Assertions.assertEquals((int)100, (int)Values.convertToInteger((Schema)header.schema(), (Object)header.value()));
    }
}

