/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.storage;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.storage.SimpleHeaderConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SimpleHeaderConverterTest {
    private static final String TOPIC = "topic";
    private static final String HEADER = "header";
    private static final Map<String, String> STRING_MAP = new LinkedHashMap<String, String>();
    private static final Schema STRING_MAP_SCHEMA = SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.STRING_SCHEMA).schema();
    private static final Map<String, Short> STRING_SHORT_MAP = new LinkedHashMap<String, Short>();
    private static final Schema STRING_SHORT_MAP_SCHEMA = SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.INT16_SCHEMA).schema();
    private static final Map<String, Integer> STRING_INT_MAP = new LinkedHashMap<String, Integer>();
    private static final Schema STRING_INT_MAP_SCHEMA = SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.INT32_SCHEMA).schema();
    private static final List<Integer> INT_LIST = new ArrayList<Integer>();
    private static final Schema INT_LIST_SCHEMA = SchemaBuilder.array((Schema)Schema.INT32_SCHEMA).schema();
    private static final List<String> STRING_LIST = new ArrayList<String>();
    private static final Schema STRING_LIST_SCHEMA = SchemaBuilder.array((Schema)Schema.STRING_SCHEMA).schema();
    private SimpleHeaderConverter converter;

    @BeforeEach
    public void beforeEach() {
        this.converter = new SimpleHeaderConverter();
    }

    @Test
    public void shouldConvertNullValue() {
        this.assertRoundTrip(Schema.STRING_SCHEMA, null);
        this.assertRoundTrip(Schema.OPTIONAL_STRING_SCHEMA, null);
    }

    @Test
    public void shouldConvertSimpleString() {
        this.assertRoundTrip(Schema.STRING_SCHEMA, "simple");
    }

    @Test
    public void shouldConvertEmptyString() {
        this.assertRoundTrip(Schema.STRING_SCHEMA, "");
    }

    @Test
    public void shouldConvertStringWithQuotesAndOtherDelimiterCharacters() {
        this.assertRoundTrip(Schema.STRING_SCHEMA, "three\"blind\\\"mice");
        this.assertRoundTrip(Schema.STRING_SCHEMA, "string with delimiters: <>?,./\\=+-!@#$%^&*(){}[]|;':");
    }

    @Test
    public void shouldConvertMapWithStringKeys() {
        this.assertRoundTrip(STRING_MAP_SCHEMA, STRING_MAP);
    }

    @Test
    public void shouldParseStringOfMapWithStringValuesWithoutWhitespaceAsMap() {
        SchemaAndValue result = this.roundTrip(Schema.STRING_SCHEMA, "{\"foo\":\"123\",\"bar\":\"baz\"}");
        Assertions.assertEquals((Object)STRING_MAP_SCHEMA, (Object)result.schema());
        Assertions.assertEquals(STRING_MAP, (Object)result.value());
    }

    @Test
    public void shouldParseStringOfMapWithStringValuesWithWhitespaceAsMap() {
        SchemaAndValue result = this.roundTrip(Schema.STRING_SCHEMA, "{ \"foo\" : \"123\", \n\"bar\" : \"baz\" } ");
        Assertions.assertEquals((Object)STRING_MAP_SCHEMA, (Object)result.schema());
        Assertions.assertEquals(STRING_MAP, (Object)result.value());
    }

    @Test
    public void shouldConvertMapWithStringKeysAndShortValues() {
        this.assertRoundTrip(STRING_SHORT_MAP_SCHEMA, STRING_SHORT_MAP);
    }

    @Test
    public void shouldParseStringOfMapWithShortValuesWithoutWhitespaceAsMap() {
        SchemaAndValue result = this.roundTrip(Schema.STRING_SCHEMA, "{\"foo\":12345,\"bar\":0,\"baz\":-4321}");
        Assertions.assertEquals((Object)STRING_SHORT_MAP_SCHEMA, (Object)result.schema());
        Assertions.assertEquals(STRING_SHORT_MAP, (Object)result.value());
    }

    @Test
    public void shouldParseStringOfMapWithShortValuesWithWhitespaceAsMap() {
        SchemaAndValue result = this.roundTrip(Schema.STRING_SCHEMA, " { \"foo\" :  12345 , \"bar\" : 0,  \"baz\" : -4321 }  ");
        Assertions.assertEquals((Object)STRING_SHORT_MAP_SCHEMA, (Object)result.schema());
        Assertions.assertEquals(STRING_SHORT_MAP, (Object)result.value());
    }

    @Test
    public void shouldConvertMapWithStringKeysAndIntegerValues() {
        this.assertRoundTrip(STRING_INT_MAP_SCHEMA, STRING_INT_MAP);
    }

    @Test
    public void shouldParseStringOfMapWithIntValuesWithoutWhitespaceAsMap() {
        SchemaAndValue result = this.roundTrip(Schema.STRING_SCHEMA, "{\"foo\":1234567890,\"bar\":0,\"baz\":-987654321}");
        Assertions.assertEquals((Object)STRING_INT_MAP_SCHEMA, (Object)result.schema());
        Assertions.assertEquals(STRING_INT_MAP, (Object)result.value());
    }

    @Test
    public void shouldParseStringOfMapWithIntValuesWithWhitespaceAsMap() {
        SchemaAndValue result = this.roundTrip(Schema.STRING_SCHEMA, " { \"foo\" :  1234567890 , \"bar\" : 0,  \"baz\" : -987654321 }  ");
        Assertions.assertEquals((Object)STRING_INT_MAP_SCHEMA, (Object)result.schema());
        Assertions.assertEquals(STRING_INT_MAP, (Object)result.value());
    }

    @Test
    public void shouldConvertListWithStringValues() {
        this.assertRoundTrip(STRING_LIST_SCHEMA, STRING_LIST);
    }

    @Test
    public void shouldConvertListWithIntegerValues() {
        this.assertRoundTrip(INT_LIST_SCHEMA, INT_LIST);
    }

    @Test
    public void shouldConvertMapWithStringKeysAndMixedValuesToMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("foo", "bar");
        map.put("baz", (short)3456);
        SchemaAndValue result = this.roundTrip(null, map);
        Assertions.assertEquals((Object)Schema.Type.MAP, (Object)result.schema().type());
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)result.schema().keySchema().type());
        Assertions.assertNull((Object)result.schema().valueSchema());
        Assertions.assertEquals(map, (Object)result.value());
    }

    @Test
    public void shouldConvertListWithMixedValuesToListWithoutSchema() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("foo");
        list.add((short)13344);
        SchemaAndValue result = this.roundTrip(null, list);
        Assertions.assertEquals((Object)Schema.Type.ARRAY, (Object)result.schema().type());
        Assertions.assertNull((Object)result.schema().valueSchema());
        Assertions.assertEquals(list, (Object)result.value());
    }

    @Test
    public void shouldConvertEmptyMapToMap() {
        LinkedHashMap map = new LinkedHashMap();
        SchemaAndValue result = this.roundTrip(null, map);
        Assertions.assertEquals((Object)Schema.Type.MAP, (Object)result.schema().type());
        Assertions.assertNull((Object)result.schema().keySchema());
        Assertions.assertNull((Object)result.schema().valueSchema());
        Assertions.assertEquals(map, (Object)result.value());
    }

    @Test
    public void shouldConvertEmptyListToList() {
        ArrayList list = new ArrayList();
        SchemaAndValue result = this.roundTrip(null, list);
        Assertions.assertEquals((Object)Schema.Type.ARRAY, (Object)result.schema().type());
        Assertions.assertNull((Object)result.schema().valueSchema());
        Assertions.assertEquals(list, (Object)result.value());
    }

    protected SchemaAndValue roundTrip(Schema schema, Object input) {
        byte[] serialized = this.converter.fromConnectHeader(TOPIC, HEADER, schema, input);
        return this.converter.toConnectHeader(TOPIC, HEADER, serialized);
    }

    protected void assertRoundTrip(Schema schema, Object value) {
        byte[] serialized = this.converter.fromConnectHeader(TOPIC, HEADER, schema, value);
        SchemaAndValue result = this.converter.toConnectHeader(TOPIC, HEADER, serialized);
        if (value == null) {
            Assertions.assertNull((Object)serialized);
            Assertions.assertNull((Object)result.schema());
            Assertions.assertNull((Object)result.value());
        } else {
            Assertions.assertNotNull((Object)serialized);
            Assertions.assertEquals((Object)value, (Object)result.value());
            Assertions.assertEquals((Object)schema, (Object)result.schema());
            byte[] serialized2 = this.converter.fromConnectHeader(TOPIC, HEADER, result.schema(), result.value());
            SchemaAndValue result2 = this.converter.toConnectHeader(TOPIC, HEADER, serialized2);
            Assertions.assertNotNull((Object)serialized2);
            Assertions.assertEquals((Object)schema, (Object)result2.schema());
            Assertions.assertEquals((Object)value, (Object)result2.value());
            Assertions.assertEquals((Object)result, (Object)result2);
            Assertions.assertArrayEquals((byte[])serialized, (byte[])serialized);
        }
    }

    static {
        STRING_MAP.put("foo", "123");
        STRING_MAP.put("bar", "baz");
        STRING_SHORT_MAP.put("foo", (short)12345);
        STRING_SHORT_MAP.put("bar", (short)0);
        STRING_SHORT_MAP.put("baz", (short)-4321);
        STRING_INT_MAP.put("foo", 1234567890);
        STRING_INT_MAP.put("bar", 0);
        STRING_INT_MAP.put("baz", -987654321);
        STRING_LIST.add("foo");
        STRING_LIST.add("bar");
        INT_LIST.add(1234567890);
        INT_LIST.add(-987654321);
    }
}

