/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.storage;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.storage.StringConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringConverterTest {
    private static final String TOPIC = "topic";
    private static final String SAMPLE_STRING = "a string";
    private StringConverter converter = new StringConverter();

    @Test
    public void testStringToBytes() throws UnsupportedEncodingException {
        Assertions.assertArrayEquals((byte[])SAMPLE_STRING.getBytes("UTF8"), (byte[])this.converter.fromConnectData(TOPIC, Schema.STRING_SCHEMA, (Object)SAMPLE_STRING));
    }

    @Test
    public void testNonStringToBytes() throws UnsupportedEncodingException {
        Assertions.assertArrayEquals((byte[])"true".getBytes("UTF8"), (byte[])this.converter.fromConnectData(TOPIC, Schema.BOOLEAN_SCHEMA, (Object)true));
    }

    @Test
    public void testNullToBytes() {
        Assertions.assertNull((Object)this.converter.fromConnectData(TOPIC, Schema.OPTIONAL_STRING_SCHEMA, null));
    }

    @Test
    public void testToBytesIgnoresSchema() throws UnsupportedEncodingException {
        Assertions.assertArrayEquals((byte[])"true".getBytes("UTF8"), (byte[])this.converter.fromConnectData(TOPIC, null, (Object)true));
    }

    @Test
    public void testToBytesNonUtf8Encoding() throws UnsupportedEncodingException {
        this.converter.configure(Collections.singletonMap("converter.encoding", "UTF-16"), true);
        Assertions.assertArrayEquals((byte[])SAMPLE_STRING.getBytes("UTF-16"), (byte[])this.converter.fromConnectData(TOPIC, Schema.STRING_SCHEMA, (Object)SAMPLE_STRING));
    }

    @Test
    public void testBytesToString() {
        SchemaAndValue data = this.converter.toConnectData(TOPIC, SAMPLE_STRING.getBytes());
        Assertions.assertEquals((Object)Schema.OPTIONAL_STRING_SCHEMA, (Object)data.schema());
        Assertions.assertEquals((Object)SAMPLE_STRING, (Object)data.value());
    }

    @Test
    public void testBytesNullToString() {
        SchemaAndValue data = this.converter.toConnectData(TOPIC, null);
        Assertions.assertEquals((Object)Schema.OPTIONAL_STRING_SCHEMA, (Object)data.schema());
        Assertions.assertNull((Object)data.value());
    }

    @Test
    public void testBytesToStringNonUtf8Encoding() throws UnsupportedEncodingException {
        this.converter.configure(Collections.singletonMap("converter.encoding", "UTF-16"), true);
        SchemaAndValue data = this.converter.toConnectData(TOPIC, SAMPLE_STRING.getBytes("UTF-16"));
        Assertions.assertEquals((Object)Schema.OPTIONAL_STRING_SCHEMA, (Object)data.schema());
        Assertions.assertEquals((Object)SAMPLE_STRING, (Object)data.value());
    }

    @Test
    public void testStringHeaderValueToBytes() throws UnsupportedEncodingException {
        Assertions.assertArrayEquals((byte[])SAMPLE_STRING.getBytes("UTF8"), (byte[])this.converter.fromConnectHeader(TOPIC, "hdr", Schema.STRING_SCHEMA, (Object)SAMPLE_STRING));
    }

    @Test
    public void testNonStringHeaderValueToBytes() throws UnsupportedEncodingException {
        Assertions.assertArrayEquals((byte[])"true".getBytes("UTF8"), (byte[])this.converter.fromConnectHeader(TOPIC, "hdr", Schema.BOOLEAN_SCHEMA, (Object)true));
    }

    @Test
    public void testNullHeaderValueToBytes() {
        Assertions.assertNull((Object)this.converter.fromConnectHeader(TOPIC, "hdr", Schema.OPTIONAL_STRING_SCHEMA, null));
    }
}

