/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.data.Values;
import org.apache.kafka.connect.errors.DataException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class ValuesTest {
    private static final String WHITESPACE = "\n \t \t\n";
    private static final long MILLIS_PER_DAY = 86400000L;
    private static final Map<String, String> STRING_MAP = new LinkedHashMap<String, String>();
    private static final Schema STRING_MAP_SCHEMA = SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.STRING_SCHEMA).schema();
    private static final Map<String, Short> STRING_SHORT_MAP = new LinkedHashMap<String, Short>();
    private static final Schema STRING_SHORT_MAP_SCHEMA = SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.INT16_SCHEMA).schema();
    private static final Map<String, Integer> STRING_INT_MAP = new LinkedHashMap<String, Integer>();
    private static final Schema STRING_INT_MAP_SCHEMA = SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.INT32_SCHEMA).schema();
    private static final List<Integer> INT_LIST = new ArrayList<Integer>();
    private static final Schema INT_LIST_SCHEMA = SchemaBuilder.array((Schema)Schema.INT32_SCHEMA).schema();
    private static final List<String> STRING_LIST = new ArrayList<String>();
    private static final Schema STRING_LIST_SCHEMA = SchemaBuilder.array((Schema)Schema.STRING_SCHEMA).schema();

    @Test
    @Timeout(value=5L)
    public void shouldNotEncounterInfiniteLoop() {
        byte[] bytes = new byte[]{-17, -65, -65};
        String str = new String(bytes, StandardCharsets.UTF_8);
        SchemaAndValue schemaAndValue = Values.parseString((String)str);
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)schemaAndValue.schema().type());
        Assertions.assertEquals((Object)str, (Object)schemaAndValue.value());
    }

    @Test
    public void shouldNotParseUnquotedEmbeddedMapKeysAsStrings() {
        SchemaAndValue schemaAndValue = Values.parseString((String)"{foo: 3}");
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)schemaAndValue.schema().type());
        Assertions.assertEquals((Object)"{foo: 3}", (Object)schemaAndValue.value());
    }

    @Test
    public void shouldNotParseUnquotedEmbeddedMapValuesAsStrings() {
        SchemaAndValue schemaAndValue = Values.parseString((String)"{3: foo}");
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)schemaAndValue.schema().type());
        Assertions.assertEquals((Object)"{3: foo}", (Object)schemaAndValue.value());
    }

    @Test
    public void shouldNotParseUnquotedArrayElementsAsStrings() {
        SchemaAndValue schemaAndValue = Values.parseString((String)"[foo]");
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)schemaAndValue.schema().type());
        Assertions.assertEquals((Object)"[foo]", (Object)schemaAndValue.value());
    }

    @Test
    public void shouldNotParseStringsBeginningWithNullAsStrings() {
        SchemaAndValue schemaAndValue = Values.parseString((String)"null=");
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)schemaAndValue.schema().type());
        Assertions.assertEquals((Object)"null=", (Object)schemaAndValue.value());
    }

    @Test
    public void shouldParseStringsBeginningWithTrueAsStrings() {
        SchemaAndValue schemaAndValue = Values.parseString((String)"true}");
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)schemaAndValue.schema().type());
        Assertions.assertEquals((Object)"true}", (Object)schemaAndValue.value());
    }

    @Test
    public void shouldParseStringsBeginningWithFalseAsStrings() {
        SchemaAndValue schemaAndValue = Values.parseString((String)"false]");
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)schemaAndValue.schema().type());
        Assertions.assertEquals((Object)"false]", (Object)schemaAndValue.value());
    }

    @Test
    public void shouldParseTrueAsBooleanIfSurroundedByWhitespace() {
        SchemaAndValue schemaAndValue = Values.parseString((String)"\n \t \t\ntrue\n \t \t\n");
        Assertions.assertEquals((Object)Schema.Type.BOOLEAN, (Object)schemaAndValue.schema().type());
        Assertions.assertEquals((Object)true, (Object)schemaAndValue.value());
    }

    @Test
    public void shouldParseFalseAsBooleanIfSurroundedByWhitespace() {
        SchemaAndValue schemaAndValue = Values.parseString((String)"\n \t \t\nfalse\n \t \t\n");
        Assertions.assertEquals((Object)Schema.Type.BOOLEAN, (Object)schemaAndValue.schema().type());
        Assertions.assertEquals((Object)false, (Object)schemaAndValue.value());
    }

    @Test
    public void shouldParseNullAsNullIfSurroundedByWhitespace() {
        SchemaAndValue schemaAndValue = Values.parseString((String)"\n \t \t\nnull\n \t \t\n");
        Assertions.assertNull((Object)schemaAndValue);
    }

    @Test
    public void shouldParseBooleanLiteralsEmbeddedInArray() {
        SchemaAndValue schemaAndValue = Values.parseString((String)"[true, false]");
        Assertions.assertEquals((Object)Schema.Type.ARRAY, (Object)schemaAndValue.schema().type());
        Assertions.assertEquals((Object)Schema.Type.BOOLEAN, (Object)schemaAndValue.schema().valueSchema().type());
        Assertions.assertEquals(Arrays.asList(true, false), (Object)schemaAndValue.value());
    }

    @Test
    public void shouldParseBooleanLiteralsEmbeddedInMap() {
        SchemaAndValue schemaAndValue = Values.parseString((String)"{true: false, false: true}");
        Assertions.assertEquals((Object)Schema.Type.MAP, (Object)schemaAndValue.schema().type());
        Assertions.assertEquals((Object)Schema.Type.BOOLEAN, (Object)schemaAndValue.schema().keySchema().type());
        Assertions.assertEquals((Object)Schema.Type.BOOLEAN, (Object)schemaAndValue.schema().valueSchema().type());
        HashMap<Boolean, Boolean> expectedValue = new HashMap<Boolean, Boolean>();
        expectedValue.put(true, false);
        expectedValue.put(false, true);
        Assertions.assertEquals(expectedValue, (Object)schemaAndValue.value());
    }

    @Test
    public void shouldNotParseAsMapWithoutCommas() {
        SchemaAndValue schemaAndValue = Values.parseString((String)"{6:9 4:20}");
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)schemaAndValue.schema().type());
        Assertions.assertEquals((Object)"{6:9 4:20}", (Object)schemaAndValue.value());
    }

    @Test
    public void shouldNotParseAsArrayWithoutCommas() {
        SchemaAndValue schemaAndValue = Values.parseString((String)"[0 1 2]");
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)schemaAndValue.schema().type());
        Assertions.assertEquals((Object)"[0 1 2]", (Object)schemaAndValue.value());
    }

    @Test
    public void shouldParseEmptyMap() {
        SchemaAndValue schemaAndValue = Values.parseString((String)"{}");
        Assertions.assertEquals((Object)Schema.Type.MAP, (Object)schemaAndValue.schema().type());
        Assertions.assertEquals(Collections.emptyMap(), (Object)schemaAndValue.value());
    }

    @Test
    public void shouldParseEmptyArray() {
        SchemaAndValue schemaAndValue = Values.parseString((String)"[]");
        Assertions.assertEquals((Object)Schema.Type.ARRAY, (Object)schemaAndValue.schema().type());
        Assertions.assertEquals(Collections.emptyList(), (Object)schemaAndValue.value());
    }

    @Test
    public void shouldNotParseAsMapWithNullKeys() {
        SchemaAndValue schemaAndValue = Values.parseString((String)"{null: 3}");
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)schemaAndValue.schema().type());
        Assertions.assertEquals((Object)"{null: 3}", (Object)schemaAndValue.value());
    }

    @Test
    public void shouldParseNull() {
        SchemaAndValue schemaAndValue = Values.parseString((String)"null");
        Assertions.assertNull((Object)schemaAndValue);
    }

    @Test
    public void shouldConvertStringOfNull() {
        this.assertRoundTrip(Schema.STRING_SCHEMA, "null");
    }

    @Test
    public void shouldParseNullMapValues() {
        SchemaAndValue schemaAndValue = Values.parseString((String)"{3: null}");
        Assertions.assertEquals((Object)Schema.Type.MAP, (Object)schemaAndValue.schema().type());
        Assertions.assertEquals((Object)Schema.Type.INT8, (Object)schemaAndValue.schema().keySchema().type());
        Assertions.assertEquals(Collections.singletonMap((byte)3, null), (Object)schemaAndValue.value());
    }

    @Test
    public void shouldParseNullArrayElements() {
        SchemaAndValue schemaAndValue = Values.parseString((String)"[null]");
        Assertions.assertEquals((Object)Schema.Type.ARRAY, (Object)schemaAndValue.schema().type());
        Assertions.assertEquals(Collections.singletonList(null), (Object)schemaAndValue.value());
    }

    @Test
    public void shouldEscapeStringsWithEmbeddedQuotesAndBackslashes() {
        String original = "three\"blind\\\"mice";
        String expected = "three\\\"blind\\\\\\\"mice";
        Assertions.assertEquals((Object)expected, (Object)Values.escape((String)original));
    }

    @Test
    public void shouldConvertNullValue() {
        this.assertRoundTrip(Schema.STRING_SCHEMA, Schema.STRING_SCHEMA, null);
        this.assertRoundTrip(Schema.OPTIONAL_STRING_SCHEMA, Schema.STRING_SCHEMA, null);
    }

    @Test
    public void shouldConvertBooleanValues() {
        this.assertRoundTrip(Schema.BOOLEAN_SCHEMA, Schema.BOOLEAN_SCHEMA, Boolean.FALSE);
        SchemaAndValue resultFalse = this.roundTrip(Schema.BOOLEAN_SCHEMA, "false");
        Assertions.assertEquals((Object)Schema.BOOLEAN_SCHEMA, (Object)resultFalse.schema());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)resultFalse.value());
        this.assertRoundTrip(Schema.BOOLEAN_SCHEMA, Schema.BOOLEAN_SCHEMA, Boolean.TRUE);
        SchemaAndValue resultTrue = this.roundTrip(Schema.BOOLEAN_SCHEMA, "true");
        Assertions.assertEquals((Object)Schema.BOOLEAN_SCHEMA, (Object)resultTrue.schema());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)resultTrue.value());
    }

    @Test
    public void shouldFailToParseInvalidBooleanValueString() {
        Assertions.assertThrows(DataException.class, () -> Values.convertToBoolean((Schema)Schema.STRING_SCHEMA, (Object)"\"green\""));
    }

    @Test
    public void shouldConvertSimpleString() {
        this.assertRoundTrip(Schema.STRING_SCHEMA, "simple");
    }

    @Test
    public void shouldConvertEmptyString() {
        this.assertRoundTrip(Schema.STRING_SCHEMA, "");
    }

    @Test
    public void shouldConvertStringWithQuotesAndOtherDelimiterCharacters() {
        this.assertRoundTrip(Schema.STRING_SCHEMA, Schema.STRING_SCHEMA, "three\"blind\\\"mice");
        this.assertRoundTrip(Schema.STRING_SCHEMA, Schema.STRING_SCHEMA, "string with delimiters: <>?,./\\=+-!@#$%^&*(){}[]|;':");
    }

    @Test
    public void shouldConvertMapWithStringKeys() {
        this.assertRoundTrip(STRING_MAP_SCHEMA, STRING_MAP_SCHEMA, STRING_MAP);
    }

    @Test
    public void shouldParseStringOfMapWithStringValuesWithoutWhitespaceAsMap() {
        SchemaAndValue result = this.roundTrip(STRING_MAP_SCHEMA, "{\"foo\":\"123\",\"bar\":\"baz\"}");
        Assertions.assertEquals((Object)STRING_MAP_SCHEMA, (Object)result.schema());
        Assertions.assertEquals(STRING_MAP, (Object)result.value());
    }

    @Test
    public void shouldParseStringOfMapWithStringValuesWithWhitespaceAsMap() {
        SchemaAndValue result = this.roundTrip(STRING_MAP_SCHEMA, "{ \"foo\" : \"123\", \n\"bar\" : \"baz\" } ");
        Assertions.assertEquals((Object)STRING_MAP_SCHEMA, (Object)result.schema());
        Assertions.assertEquals(STRING_MAP, (Object)result.value());
    }

    @Test
    public void shouldConvertMapWithStringKeysAndShortValues() {
        this.assertRoundTrip(STRING_SHORT_MAP_SCHEMA, STRING_SHORT_MAP_SCHEMA, STRING_SHORT_MAP);
    }

    @Test
    public void shouldParseStringOfMapWithShortValuesWithoutWhitespaceAsMap() {
        SchemaAndValue result = this.roundTrip(STRING_SHORT_MAP_SCHEMA, "{\"foo\":12345,\"bar\":0,\"baz\":-4321}");
        Assertions.assertEquals((Object)STRING_SHORT_MAP_SCHEMA, (Object)result.schema());
        Assertions.assertEquals(STRING_SHORT_MAP, (Object)result.value());
    }

    @Test
    public void shouldParseStringOfMapWithShortValuesWithWhitespaceAsMap() {
        SchemaAndValue result = this.roundTrip(STRING_SHORT_MAP_SCHEMA, " { \"foo\" :  12345 , \"bar\" : 0,  \"baz\" : -4321 }  ");
        Assertions.assertEquals((Object)STRING_SHORT_MAP_SCHEMA, (Object)result.schema());
        Assertions.assertEquals(STRING_SHORT_MAP, (Object)result.value());
    }

    @Test
    public void shouldConvertMapWithStringKeysAndIntegerValues() {
        this.assertRoundTrip(STRING_INT_MAP_SCHEMA, STRING_INT_MAP_SCHEMA, STRING_INT_MAP);
    }

    @Test
    public void shouldParseStringOfMapWithIntValuesWithoutWhitespaceAsMap() {
        SchemaAndValue result = this.roundTrip(STRING_INT_MAP_SCHEMA, "{\"foo\":1234567890,\"bar\":0,\"baz\":-987654321}");
        Assertions.assertEquals((Object)STRING_INT_MAP_SCHEMA, (Object)result.schema());
        Assertions.assertEquals(STRING_INT_MAP, (Object)result.value());
    }

    @Test
    public void shouldParseStringOfMapWithIntValuesWithWhitespaceAsMap() {
        SchemaAndValue result = this.roundTrip(STRING_INT_MAP_SCHEMA, " { \"foo\" :  1234567890 , \"bar\" : 0,  \"baz\" : -987654321 }  ");
        Assertions.assertEquals((Object)STRING_INT_MAP_SCHEMA, (Object)result.schema());
        Assertions.assertEquals(STRING_INT_MAP, (Object)result.value());
    }

    @Test
    public void shouldConvertListWithStringValues() {
        this.assertRoundTrip(STRING_LIST_SCHEMA, STRING_LIST_SCHEMA, STRING_LIST);
    }

    @Test
    public void shouldConvertListWithIntegerValues() {
        this.assertRoundTrip(INT_LIST_SCHEMA, INT_LIST_SCHEMA, INT_LIST);
    }

    @Test
    public void shouldConvertStringOfListWithOnlyNumericElementTypesIntoListOfLargestNumericType() {
        int thirdValue = 32768;
        List list = Values.convertToList((Schema)Schema.STRING_SCHEMA, (Object)("[1, 2, " + thirdValue + "]"));
        Assertions.assertEquals((int)3, (int)list.size());
        Assertions.assertEquals((int)1, (int)((Number)list.get(0)).intValue());
        Assertions.assertEquals((int)2, (int)((Number)list.get(1)).intValue());
        Assertions.assertEquals((int)thirdValue, (int)((Number)list.get(2)).intValue());
    }

    @Test
    public void shouldConvertStringOfListWithMixedElementTypesIntoListWithDifferentElementTypes() {
        String str = "[1, 2, \"three\"]";
        List list = Values.convertToList((Schema)Schema.STRING_SCHEMA, (Object)str);
        Assertions.assertEquals((int)3, (int)list.size());
        Assertions.assertEquals((int)1, (int)((Number)list.get(0)).intValue());
        Assertions.assertEquals((int)2, (int)((Number)list.get(1)).intValue());
        Assertions.assertEquals((Object)"three", list.get(2));
    }

    @Test
    public void shouldParseStringListWithMultipleElementTypesAndReturnListWithNoSchema() {
        String str = "[1, 2, 3, \"four\"]";
        SchemaAndValue result = Values.parseString((String)str);
        Assertions.assertEquals((Object)Schema.Type.ARRAY, (Object)result.schema().type());
        Assertions.assertNull((Object)result.schema().valueSchema());
        List list = (List)result.value();
        Assertions.assertEquals((int)4, (int)list.size());
        Assertions.assertEquals((int)1, (int)((Number)list.get(0)).intValue());
        Assertions.assertEquals((int)2, (int)((Number)list.get(1)).intValue());
        Assertions.assertEquals((int)3, (int)((Number)list.get(2)).intValue());
        Assertions.assertEquals((Object)"four", list.get(3));
    }

    @Test
    public void shouldParseStringListWithExtraDelimitersAndReturnString() {
        String str = "[1, 2, 3,,,]";
        SchemaAndValue result = Values.parseString((String)str);
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)result.schema().type());
        Assertions.assertEquals((Object)str, (Object)result.value());
    }

    @Test
    public void shouldParseTimestampStringAsTimestamp() throws Exception {
        String str = "2019-08-23T14:34:54.346Z";
        SchemaAndValue result = Values.parseString((String)str);
        Assertions.assertEquals((Object)Schema.Type.INT64, (Object)result.schema().type());
        Assertions.assertEquals((Object)"org.apache.kafka.connect.data.Timestamp", (Object)result.schema().name());
        java.util.Date expected = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(str);
        Assertions.assertEquals((Object)expected, (Object)result.value());
    }

    @Test
    public void shouldParseDateStringAsDate() throws Exception {
        String str = "2019-08-23";
        SchemaAndValue result = Values.parseString((String)str);
        Assertions.assertEquals((Object)Schema.Type.INT32, (Object)result.schema().type());
        Assertions.assertEquals((Object)"org.apache.kafka.connect.data.Date", (Object)result.schema().name());
        java.util.Date expected = new SimpleDateFormat("yyyy-MM-dd").parse(str);
        Assertions.assertEquals((Object)expected, (Object)result.value());
    }

    @Test
    public void shouldParseTimeStringAsDate() throws Exception {
        String str = "14:34:54.346Z";
        SchemaAndValue result = Values.parseString((String)str);
        Assertions.assertEquals((Object)Schema.Type.INT32, (Object)result.schema().type());
        Assertions.assertEquals((Object)"org.apache.kafka.connect.data.Time", (Object)result.schema().name());
        java.util.Date expected = new SimpleDateFormat("HH:mm:ss.SSS'Z'").parse(str);
        Assertions.assertEquals((Object)expected, (Object)result.value());
    }

    @Test
    public void shouldParseTimestampStringWithEscapedColonsAsTimestamp() throws Exception {
        String str = "2019-08-23T14\\:34\\:54.346Z";
        SchemaAndValue result = Values.parseString((String)str);
        Assertions.assertEquals((Object)Schema.Type.INT64, (Object)result.schema().type());
        Assertions.assertEquals((Object)"org.apache.kafka.connect.data.Timestamp", (Object)result.schema().name());
        String expectedStr = "2019-08-23T14:34:54.346Z";
        java.util.Date expected = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(expectedStr);
        Assertions.assertEquals((Object)expected, (Object)result.value());
    }

    @Test
    public void shouldParseTimeStringWithEscapedColonsAsDate() throws Exception {
        String str = "14\\:34\\:54.346Z";
        SchemaAndValue result = Values.parseString((String)str);
        Assertions.assertEquals((Object)Schema.Type.INT32, (Object)result.schema().type());
        Assertions.assertEquals((Object)"org.apache.kafka.connect.data.Time", (Object)result.schema().name());
        String expectedStr = "14:34:54.346Z";
        java.util.Date expected = new SimpleDateFormat("HH:mm:ss.SSS'Z'").parse(expectedStr);
        Assertions.assertEquals((Object)expected, (Object)result.value());
    }

    @Test
    public void shouldParseDateStringAsDateInArray() throws Exception {
        String dateStr = "2019-08-23";
        String arrayStr = "[" + dateStr + "]";
        SchemaAndValue result = Values.parseString((String)arrayStr);
        Assertions.assertEquals((Object)Schema.Type.ARRAY, (Object)result.schema().type());
        Schema elementSchema = result.schema().valueSchema();
        Assertions.assertEquals((Object)Schema.Type.INT32, (Object)elementSchema.type());
        Assertions.assertEquals((Object)"org.apache.kafka.connect.data.Date", (Object)elementSchema.name());
        java.util.Date expected = new SimpleDateFormat("yyyy-MM-dd").parse(dateStr);
        Assertions.assertEquals(Collections.singletonList(expected), (Object)result.value());
    }

    @Test
    public void shouldParseTimeStringAsTimeInArray() throws Exception {
        String timeStr = "14:34:54.346Z";
        String arrayStr = "[" + timeStr + "]";
        SchemaAndValue result = Values.parseString((String)arrayStr);
        Assertions.assertEquals((Object)Schema.Type.ARRAY, (Object)result.schema().type());
        Schema elementSchema = result.schema().valueSchema();
        Assertions.assertEquals((Object)Schema.Type.INT32, (Object)elementSchema.type());
        Assertions.assertEquals((Object)"org.apache.kafka.connect.data.Time", (Object)elementSchema.name());
        java.util.Date expected = new SimpleDateFormat("HH:mm:ss.SSS'Z'").parse(timeStr);
        Assertions.assertEquals(Collections.singletonList(expected), (Object)result.value());
    }

    @Test
    public void shouldParseTimestampStringAsTimestampInArray() throws Exception {
        String tsStr = "2019-08-23T14:34:54.346Z";
        String arrayStr = "[" + tsStr + "]";
        SchemaAndValue result = Values.parseString((String)arrayStr);
        Assertions.assertEquals((Object)Schema.Type.ARRAY, (Object)result.schema().type());
        Schema elementSchema = result.schema().valueSchema();
        Assertions.assertEquals((Object)Schema.Type.INT64, (Object)elementSchema.type());
        Assertions.assertEquals((Object)"org.apache.kafka.connect.data.Timestamp", (Object)elementSchema.name());
        java.util.Date expected = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(tsStr);
        Assertions.assertEquals(Collections.singletonList(expected), (Object)result.value());
    }

    @Test
    public void shouldParseMultipleTimestampStringAsTimestampInArray() throws Exception {
        String tsStr1 = "2019-08-23T14:34:54.346Z";
        String tsStr2 = "2019-01-23T15:12:34.567Z";
        String tsStr3 = "2019-04-23T19:12:34.567Z";
        String arrayStr = "[" + tsStr1 + "," + tsStr2 + ",   " + tsStr3 + "]";
        SchemaAndValue result = Values.parseString((String)arrayStr);
        Assertions.assertEquals((Object)Schema.Type.ARRAY, (Object)result.schema().type());
        Schema elementSchema = result.schema().valueSchema();
        Assertions.assertEquals((Object)Schema.Type.INT64, (Object)elementSchema.type());
        Assertions.assertEquals((Object)"org.apache.kafka.connect.data.Timestamp", (Object)elementSchema.name());
        java.util.Date expected1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(tsStr1);
        java.util.Date expected2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(tsStr2);
        java.util.Date expected3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(tsStr3);
        Assertions.assertEquals(Arrays.asList(expected1, expected2, expected3), (Object)result.value());
    }

    @Test
    public void shouldParseQuotedTimeStringAsTimeInMap() throws Exception {
        String keyStr = "k1";
        String timeStr = "14:34:54.346Z";
        String mapStr = "{\"" + keyStr + "\":\"" + timeStr + "\"}";
        SchemaAndValue result = Values.parseString((String)mapStr);
        Assertions.assertEquals((Object)Schema.Type.MAP, (Object)result.schema().type());
        Schema keySchema = result.schema().keySchema();
        Schema valueSchema = result.schema().valueSchema();
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)keySchema.type());
        Assertions.assertEquals((Object)Schema.Type.INT32, (Object)valueSchema.type());
        Assertions.assertEquals((Object)"org.apache.kafka.connect.data.Time", (Object)valueSchema.name());
        java.util.Date expected = new SimpleDateFormat("HH:mm:ss.SSS'Z'").parse(timeStr);
        Assertions.assertEquals(Collections.singletonMap(keyStr, expected), (Object)result.value());
    }

    @Test
    public void shouldParseTimeStringAsTimeInMap() throws Exception {
        String keyStr = "k1";
        String timeStr = "14:34:54.346Z";
        String mapStr = "{\"" + keyStr + "\":" + timeStr + "}";
        SchemaAndValue result = Values.parseString((String)mapStr);
        Assertions.assertEquals((Object)Schema.Type.MAP, (Object)result.schema().type());
        Schema keySchema = result.schema().keySchema();
        Schema valueSchema = result.schema().valueSchema();
        Assertions.assertEquals((Object)Schema.Type.STRING, (Object)keySchema.type());
        Assertions.assertEquals((Object)Schema.Type.INT32, (Object)valueSchema.type());
        Assertions.assertEquals((Object)"org.apache.kafka.connect.data.Time", (Object)valueSchema.name());
        java.util.Date expected = new SimpleDateFormat("HH:mm:ss.SSS'Z'").parse(timeStr);
        Assertions.assertEquals(Collections.singletonMap(keyStr, expected), (Object)result.value());
    }

    @Test
    public void shouldFailToConvertToListFromStringWithExtraDelimiters() {
        Assertions.assertThrows(DataException.class, () -> Values.convertToList((Schema)Schema.STRING_SCHEMA, (Object)"[1, 2, 3,,,]"));
    }

    @Test
    public void shouldFailToConvertToListFromStringWithNonCommonElementTypeAndBlankElement() {
        Assertions.assertThrows(DataException.class, () -> Values.convertToList((Schema)Schema.STRING_SCHEMA, (Object)"[1, 2, 3, \"four\",,,]"));
    }

    @Test
    public void shouldFailToParseStringOfMapWithIntValuesWithBlankEntry() {
        Assertions.assertThrows(DataException.class, () -> Values.convertToMap((Schema)Schema.STRING_SCHEMA, (Object)" { \"foo\" :  1234567890 ,, \"bar\" : 0,  \"baz\" : -987654321 }  "));
    }

    @Test
    public void shouldFailToParseStringOfMalformedMap() {
        Assertions.assertThrows(DataException.class, () -> Values.convertToMap((Schema)Schema.STRING_SCHEMA, (Object)" { \"foo\" :  1234567890 , \"a\", \"bar\" : 0,  \"baz\" : -987654321 }  "));
    }

    @Test
    public void shouldFailToParseStringOfMapWithIntValuesWithOnlyBlankEntries() {
        Assertions.assertThrows(DataException.class, () -> Values.convertToMap((Schema)Schema.STRING_SCHEMA, (Object)" { ,,  , , }  "));
    }

    @Test
    public void shouldFailToParseStringOfMapWithIntValuesWithBlankEntries() {
        Assertions.assertThrows(DataException.class, () -> Values.convertToMap((Schema)Schema.STRING_SCHEMA, (Object)" { \"foo\" :  \"1234567890\" ,, \"bar\" : \"0\",  \"baz\" : \"boz\" }  "));
    }

    @Test
    public void shouldConsumeMultipleTokens() {
        String value = "a:b:c:d:e:f:g:h";
        Values.Parser parser = new Values.Parser(value);
        String firstFive = parser.next(5);
        Assertions.assertEquals((Object)"a:b:c", (Object)firstFive);
        Assertions.assertEquals((Object)":", (Object)parser.next());
        Assertions.assertEquals((Object)"d", (Object)parser.next());
        Assertions.assertEquals((Object)":", (Object)parser.next());
        String lastEight = parser.next(8);
        Assertions.assertNull((Object)lastEight);
        Assertions.assertEquals((Object)"e", (Object)parser.next());
    }

    @Test
    public void shouldParseStringsWithoutDelimiters() {
        this.assertParsed("  ");
        this.assertParsed("simple");
        this.assertParsed("simple string");
        this.assertParsed("simple \n\t\bstring");
        this.assertParsed("'simple' string");
        this.assertParsed("si\\mple");
        this.assertParsed("si\\\\mple");
    }

    @Test
    public void shouldParseStringsWithEscapedDelimiters() {
        this.assertParsed("si\\\"mple");
        this.assertParsed("si\\{mple");
        this.assertParsed("si\\}mple");
        this.assertParsed("si\\]mple");
        this.assertParsed("si\\[mple");
        this.assertParsed("si\\:mple");
        this.assertParsed("si\\,mple");
    }

    @Test
    public void shouldParseStringsWithSingleDelimiter() {
        this.assertParsed("a{b", "a", "{", "b");
        this.assertParsed("a}b", "a", "}", "b");
        this.assertParsed("a[b", "a", "[", "b");
        this.assertParsed("a]b", "a", "]", "b");
        this.assertParsed("a:b", "a", ":", "b");
        this.assertParsed("a,b", "a", ",", "b");
        this.assertParsed("a\"b", "a", "\"", "b");
        this.assertParsed("{b", "{", "b");
        this.assertParsed("}b", "}", "b");
        this.assertParsed("[b", "[", "b");
        this.assertParsed("]b", "]", "b");
        this.assertParsed(":b", ":", "b");
        this.assertParsed(",b", ",", "b");
        this.assertParsed("\"b", "\"", "b");
        this.assertParsed("{", "{");
        this.assertParsed("}", "}");
        this.assertParsed("[", "[");
        this.assertParsed("]", "]");
        this.assertParsed(":", ":");
        this.assertParsed(",", ",");
        this.assertParsed("\"", "\"");
    }

    @Test
    public void shouldParseStringsWithMultipleDelimiters() {
        this.assertParsed("\"simple\" string", "\"", "simple", "\"", " string");
        this.assertParsed("a{bc}d", "a", "{", "bc", "}", "d");
        this.assertParsed("a { b c } d", "a ", "{", " b c ", "}", " d");
        this.assertParsed("a { b c } d", "a ", "{", " b c ", "}", " d");
    }

    @Test
    public void shouldConvertTimeValues() {
        java.util.Date current = new java.util.Date();
        long currentMillis = current.getTime() % 86400000L;
        java.util.Date t1 = Values.convertToTime((Schema)Time.SCHEMA, (Object)current);
        Assertions.assertEquals((Object)current, (Object)t1);
        t1 = Values.convertToTime((Schema)Timestamp.SCHEMA, (Object)current);
        Assertions.assertEquals((Object)new java.util.Date(currentMillis), (Object)t1);
        java.util.Date t3 = Values.convertToTime((Schema)Time.SCHEMA, (Object)Long.toString(currentMillis));
        Assertions.assertEquals((long)currentMillis, (long)t3.getTime());
        java.util.Date t4 = Values.convertToTime((Schema)Time.SCHEMA, (Object)currentMillis);
        Assertions.assertEquals((long)currentMillis, (long)t4.getTime());
    }

    @Test
    public void shouldConvertDateValues() {
        java.util.Date current = new java.util.Date();
        long currentMillis = current.getTime() % 86400000L;
        long days = current.getTime() / 86400000L;
        java.util.Date d1 = Values.convertToDate((Schema)Date.SCHEMA, (Object)current);
        Assertions.assertEquals((Object)current, (Object)d1);
        java.util.Date currentDate = new java.util.Date(current.getTime() - currentMillis);
        d1 = Values.convertToDate((Schema)Timestamp.SCHEMA, (Object)currentDate);
        Assertions.assertEquals((Object)currentDate, (Object)d1);
        java.util.Date d3 = Values.convertToDate((Schema)Date.SCHEMA, (Object)Long.toString(days));
        Assertions.assertEquals((Object)currentDate, (Object)d3);
        java.util.Date d4 = Values.convertToDate((Schema)Date.SCHEMA, (Object)days);
        Assertions.assertEquals((Object)currentDate, (Object)d4);
    }

    @Test
    public void shouldConvertTimestampValues() {
        java.util.Date current = new java.util.Date();
        long currentMillis = current.getTime() % 86400000L;
        java.util.Date ts1 = Values.convertToTimestamp((Schema)Timestamp.SCHEMA, (Object)current);
        Assertions.assertEquals((Object)current, (Object)ts1);
        java.util.Date currentDate = new java.util.Date(current.getTime() - currentMillis);
        ts1 = Values.convertToTimestamp((Schema)Date.SCHEMA, (Object)currentDate);
        Assertions.assertEquals((Object)currentDate, (Object)ts1);
        ts1 = Values.convertToTimestamp((Schema)Time.SCHEMA, (Object)currentMillis);
        Assertions.assertEquals((Object)new java.util.Date(currentMillis), (Object)ts1);
        java.util.Date ts3 = Values.convertToTimestamp((Schema)Timestamp.SCHEMA, (Object)Long.toString(current.getTime()));
        Assertions.assertEquals((Object)current, (Object)ts3);
        java.util.Date ts4 = Values.convertToTimestamp((Schema)Timestamp.SCHEMA, (Object)current.getTime());
        Assertions.assertEquals((Object)current, (Object)ts4);
    }

    @Test
    public void canConsume() {
    }

    @Test
    public void shouldParseBigIntegerAsDecimalWithZeroScale() {
        BigInteger value = BigInteger.valueOf(Long.MAX_VALUE).add(new BigInteger("1"));
        SchemaAndValue schemaAndValue = Values.parseString((String)String.valueOf(value));
        Assertions.assertEquals((Object)Decimal.schema((int)0), (Object)schemaAndValue.schema());
        Assertions.assertTrue((boolean)(schemaAndValue.value() instanceof BigDecimal));
        Assertions.assertEquals((Object)value, (Object)((BigDecimal)schemaAndValue.value()).unscaledValue());
        value = BigInteger.valueOf(Long.MIN_VALUE).subtract(new BigInteger("1"));
        schemaAndValue = Values.parseString((String)String.valueOf(value));
        Assertions.assertEquals((Object)Decimal.schema((int)0), (Object)schemaAndValue.schema());
        Assertions.assertTrue((boolean)(schemaAndValue.value() instanceof BigDecimal));
        Assertions.assertEquals((Object)value, (Object)((BigDecimal)schemaAndValue.value()).unscaledValue());
    }

    @Test
    public void shouldParseByteAsInt8() {
        Byte value = 127;
        SchemaAndValue schemaAndValue = Values.parseString((String)String.valueOf(value));
        Assertions.assertEquals((Object)Schema.INT8_SCHEMA, (Object)schemaAndValue.schema());
        Assertions.assertTrue((boolean)(schemaAndValue.value() instanceof Byte));
        Assertions.assertEquals((byte)value, (byte)((Byte)schemaAndValue.value()));
        value = -128;
        schemaAndValue = Values.parseString((String)String.valueOf(value));
        Assertions.assertEquals((Object)Schema.INT8_SCHEMA, (Object)schemaAndValue.schema());
        Assertions.assertTrue((boolean)(schemaAndValue.value() instanceof Byte));
        Assertions.assertEquals((byte)value, (byte)((Byte)schemaAndValue.value()));
    }

    @Test
    public void shouldParseShortAsInt16() {
        Short value = Short.MAX_VALUE;
        SchemaAndValue schemaAndValue = Values.parseString((String)String.valueOf(value));
        Assertions.assertEquals((Object)Schema.INT16_SCHEMA, (Object)schemaAndValue.schema());
        Assertions.assertTrue((boolean)(schemaAndValue.value() instanceof Short));
        Assertions.assertEquals((short)value, (short)((Short)schemaAndValue.value()));
        value = Short.MIN_VALUE;
        schemaAndValue = Values.parseString((String)String.valueOf(value));
        Assertions.assertEquals((Object)Schema.INT16_SCHEMA, (Object)schemaAndValue.schema());
        Assertions.assertTrue((boolean)(schemaAndValue.value() instanceof Short));
        Assertions.assertEquals((short)value, (short)((Short)schemaAndValue.value()));
    }

    @Test
    public void shouldParseIntegerAsInt32() {
        Integer value = Integer.MAX_VALUE;
        SchemaAndValue schemaAndValue = Values.parseString((String)String.valueOf(value));
        Assertions.assertEquals((Object)Schema.INT32_SCHEMA, (Object)schemaAndValue.schema());
        Assertions.assertTrue((boolean)(schemaAndValue.value() instanceof Integer));
        Assertions.assertEquals((int)value, (int)((Integer)schemaAndValue.value()));
        value = Integer.MIN_VALUE;
        schemaAndValue = Values.parseString((String)String.valueOf(value));
        Assertions.assertEquals((Object)Schema.INT32_SCHEMA, (Object)schemaAndValue.schema());
        Assertions.assertTrue((boolean)(schemaAndValue.value() instanceof Integer));
        Assertions.assertEquals((int)value, (int)((Integer)schemaAndValue.value()));
    }

    @Test
    public void shouldParseLongAsInt64() {
        Long value = Long.MAX_VALUE;
        SchemaAndValue schemaAndValue = Values.parseString((String)String.valueOf(value));
        Assertions.assertEquals((Object)Schema.INT64_SCHEMA, (Object)schemaAndValue.schema());
        Assertions.assertTrue((boolean)(schemaAndValue.value() instanceof Long));
        Assertions.assertEquals((long)value, (long)((Long)schemaAndValue.value()));
        value = Long.MIN_VALUE;
        schemaAndValue = Values.parseString((String)String.valueOf(value));
        Assertions.assertEquals((Object)Schema.INT64_SCHEMA, (Object)schemaAndValue.schema());
        Assertions.assertTrue((boolean)(schemaAndValue.value() instanceof Long));
        Assertions.assertEquals((long)value, (long)((Long)schemaAndValue.value()));
    }

    @Test
    public void shouldParseFloatAsFloat32() {
        Float value = Float.valueOf(Float.MAX_VALUE);
        SchemaAndValue schemaAndValue = Values.parseString((String)String.valueOf(value));
        Assertions.assertEquals((Object)Schema.FLOAT32_SCHEMA, (Object)schemaAndValue.schema());
        Assertions.assertTrue((boolean)(schemaAndValue.value() instanceof Float));
        Assertions.assertEquals((float)value.floatValue(), (float)((Float)schemaAndValue.value()).floatValue(), (float)0.0f);
        value = Float.valueOf(-3.4028235E38f);
        schemaAndValue = Values.parseString((String)String.valueOf(value));
        Assertions.assertEquals((Object)Schema.FLOAT32_SCHEMA, (Object)schemaAndValue.schema());
        Assertions.assertTrue((boolean)(schemaAndValue.value() instanceof Float));
        Assertions.assertEquals((float)value.floatValue(), (float)((Float)schemaAndValue.value()).floatValue(), (float)0.0f);
    }

    @Test
    public void shouldParseDoubleAsFloat64() {
        Double value = Double.MAX_VALUE;
        SchemaAndValue schemaAndValue = Values.parseString((String)String.valueOf(value));
        Assertions.assertEquals((Object)Schema.FLOAT64_SCHEMA, (Object)schemaAndValue.schema());
        Assertions.assertTrue((boolean)(schemaAndValue.value() instanceof Double));
        Assertions.assertEquals((double)value, (double)((Double)schemaAndValue.value()), (double)0.0);
        value = -1.7976931348623157E308;
        schemaAndValue = Values.parseString((String)String.valueOf(value));
        Assertions.assertEquals((Object)Schema.FLOAT64_SCHEMA, (Object)schemaAndValue.schema());
        Assertions.assertTrue((boolean)(schemaAndValue.value() instanceof Double));
        Assertions.assertEquals((double)value, (double)((Double)schemaAndValue.value()), (double)0.0);
    }

    protected void assertParsed(String input) {
        this.assertParsed(input, input);
    }

    protected void assertParsed(String input, String ... expectedTokens) {
        Values.Parser parser = new Values.Parser(input);
        if (!parser.hasNext()) {
            Assertions.assertEquals((int)1, (int)expectedTokens.length);
            Assertions.assertTrue((boolean)expectedTokens[0].isEmpty());
            return;
        }
        for (String expectedToken : expectedTokens) {
            Assertions.assertTrue((boolean)parser.hasNext());
            int position = parser.mark();
            Assertions.assertEquals((Object)expectedToken, (Object)parser.next());
            Assertions.assertEquals((int)(position + expectedToken.length()), (int)parser.position());
            Assertions.assertEquals((Object)expectedToken, (Object)parser.previous());
            parser.rewindTo(position);
            Assertions.assertEquals((int)position, (int)parser.position());
            Assertions.assertEquals((Object)expectedToken, (Object)parser.next());
            int newPosition = parser.mark();
            Assertions.assertEquals((int)(position + expectedToken.length()), (int)newPosition);
            Assertions.assertEquals((Object)expectedToken, (Object)parser.previous());
        }
        Assertions.assertFalse((boolean)parser.hasNext());
        parser.rewindTo(0);
        this.assertConsumable(parser, expectedTokens);
        parser = new Values.Parser(input);
        this.assertConsumable(parser, expectedTokens);
    }

    protected void assertConsumable(Values.Parser parser, String ... expectedTokens) {
        for (String expectedToken : expectedTokens) {
            if (expectedToken.trim().isEmpty()) continue;
            int position = parser.mark();
            Assertions.assertTrue((boolean)parser.canConsume(expectedToken.trim()));
            parser.rewindTo(position);
            Assertions.assertTrue((boolean)parser.canConsume(expectedToken.trim(), true));
            parser.rewindTo(position);
            Assertions.assertTrue((boolean)parser.canConsume(expectedToken, false));
        }
    }

    protected SchemaAndValue roundTrip(Schema desiredSchema, String currentValue) {
        return this.roundTrip(desiredSchema, new SchemaAndValue(Schema.STRING_SCHEMA, (Object)currentValue));
    }

    protected SchemaAndValue roundTrip(Schema desiredSchema, SchemaAndValue input) {
        String serialized = Values.convertToString((Schema)input.schema(), (Object)input.value());
        if (input != null && input.value() != null) {
            Assertions.assertNotNull((Object)serialized);
        }
        if (desiredSchema == null) {
            desiredSchema = Values.inferSchema((Object)input);
            Assertions.assertNotNull((Object)desiredSchema);
        }
        Object newValue = null;
        Schema newSchema = null;
        switch (desiredSchema.type()) {
            case STRING: {
                newValue = Values.convertToString((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case INT8: {
                newValue = Values.convertToByte((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case INT16: {
                newValue = Values.convertToShort((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case INT32: {
                newValue = Values.convertToInteger((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case INT64: {
                newValue = Values.convertToLong((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case FLOAT32: {
                newValue = Values.convertToFloat((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case FLOAT64: {
                newValue = Values.convertToDouble((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case BOOLEAN: {
                newValue = Values.convertToBoolean((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case ARRAY: {
                newValue = Values.convertToList((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case MAP: {
                newValue = Values.convertToMap((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case STRUCT: {
                newValue = Values.convertToStruct((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case BYTES: {
                Assertions.fail((String)"unexpected schema type");
            }
        }
        newSchema = Values.inferSchema(newValue);
        return new SchemaAndValue(newSchema, newValue);
    }

    protected void assertRoundTrip(Schema schema, String value) {
        this.assertRoundTrip(schema, Schema.STRING_SCHEMA, value);
    }

    protected void assertRoundTrip(Schema schema, Schema currentSchema, Object value) {
        SchemaAndValue result = this.roundTrip(schema, new SchemaAndValue(currentSchema, value));
        if (value == null) {
            Assertions.assertNull((Object)result.schema());
            Assertions.assertNull((Object)result.value());
        } else {
            Assertions.assertEquals((Object)value, (Object)result.value());
            Assertions.assertEquals((Object)schema, (Object)result.schema());
            SchemaAndValue result2 = this.roundTrip(result.schema(), result);
            Assertions.assertEquals((Object)schema, (Object)result2.schema());
            Assertions.assertEquals((Object)value, (Object)result2.value());
            Assertions.assertEquals((Object)result, (Object)result2);
        }
    }

    static {
        STRING_MAP.put("foo", "123");
        STRING_MAP.put("bar", "baz");
        STRING_SHORT_MAP.put("foo", (short)12345);
        STRING_SHORT_MAP.put("bar", (short)0);
        STRING_SHORT_MAP.put("baz", (short)-4321);
        STRING_INT_MAP.put("foo", 1234567890);
        STRING_INT_MAP.put("bar", 0);
        STRING_INT_MAP.put("baz", -987654321);
        STRING_LIST.add("foo");
        STRING_LIST.add("bar");
        INT_LIST.add(1234567890);
        INT_LIST.add(-987654321);
    }
}

