/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.SchemaProjector;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.errors.SchemaProjectorException;
import org.junit.Assert;
import org.junit.Test;

public class SchemaProjectorTest {
    @Test
    public void testPrimitiveTypeProjection() {
        Object projected = SchemaProjector.project((Schema)Schema.BOOLEAN_SCHEMA, (Object)false, (Schema)Schema.BOOLEAN_SCHEMA);
        Assert.assertEquals((Object)false, (Object)projected);
        byte[] bytes = new byte[]{1, 2};
        projected = SchemaProjector.project((Schema)Schema.BYTES_SCHEMA, (Object)bytes, (Schema)Schema.BYTES_SCHEMA);
        Assert.assertEquals((Object)bytes, (Object)projected);
        projected = SchemaProjector.project((Schema)Schema.STRING_SCHEMA, (Object)"abc", (Schema)Schema.STRING_SCHEMA);
        Assert.assertEquals((Object)"abc", (Object)projected);
        projected = SchemaProjector.project((Schema)Schema.BOOLEAN_SCHEMA, (Object)false, (Schema)Schema.OPTIONAL_BOOLEAN_SCHEMA);
        Assert.assertEquals((Object)false, (Object)projected);
        projected = SchemaProjector.project((Schema)Schema.BYTES_SCHEMA, (Object)bytes, (Schema)Schema.OPTIONAL_BYTES_SCHEMA);
        Assert.assertEquals((Object)bytes, (Object)projected);
        projected = SchemaProjector.project((Schema)Schema.STRING_SCHEMA, (Object)"abc", (Schema)Schema.OPTIONAL_STRING_SCHEMA);
        Assert.assertEquals((Object)"abc", (Object)projected);
        try {
            SchemaProjector.project((Schema)Schema.OPTIONAL_BOOLEAN_SCHEMA, (Object)false, (Schema)Schema.BOOLEAN_SCHEMA);
            Assert.fail((String)"Cannot project optional schema to schema with no default value.");
        }
        catch (DataException dataException) {
            // empty catch block
        }
        try {
            SchemaProjector.project((Schema)Schema.OPTIONAL_BYTES_SCHEMA, (Object)bytes, (Schema)Schema.BYTES_SCHEMA);
            Assert.fail((String)"Cannot project optional schema to schema with no default value.");
        }
        catch (DataException dataException) {
            // empty catch block
        }
        try {
            SchemaProjector.project((Schema)Schema.OPTIONAL_STRING_SCHEMA, (Object)"abc", (Schema)Schema.STRING_SCHEMA);
            Assert.fail((String)"Cannot project optional schema to schema with no default value.");
        }
        catch (DataException dataException) {
            // empty catch block
        }
    }

    @Test
    public void testNumericTypeProjection() {
        Object promoted;
        Schema target;
        int j;
        List expected;
        Schema source;
        int i;
        Schema[] promotableSchemas = new Schema[]{Schema.INT8_SCHEMA, Schema.INT16_SCHEMA, Schema.INT32_SCHEMA, Schema.INT64_SCHEMA, Schema.FLOAT32_SCHEMA, Schema.FLOAT64_SCHEMA};
        Schema[] promotableOptionalSchemas = new Schema[]{Schema.OPTIONAL_INT8_SCHEMA, Schema.OPTIONAL_INT16_SCHEMA, Schema.OPTIONAL_INT32_SCHEMA, Schema.OPTIONAL_INT64_SCHEMA, Schema.OPTIONAL_FLOAT32_SCHEMA, Schema.OPTIONAL_FLOAT64_SCHEMA};
        Object[] values = new Object[]{(byte)127, (short)255, Short.MAX_VALUE, 327890L, Float.valueOf(1.2f), 1.2345};
        HashMap<Object, List<Number>> expectedProjected = new HashMap<Object, List<Number>>();
        expectedProjected.put(values[0], Arrays.asList((byte)127, (short)127, 127, 127L, Float.valueOf(127.0f), 127.0));
        expectedProjected.put(values[1], Arrays.asList((short)255, 255, 255L, Float.valueOf(255.0f), 255.0));
        expectedProjected.put(values[2], Arrays.asList(Short.MAX_VALUE, 32767L, Float.valueOf(32767.0f), 32767.0));
        expectedProjected.put(values[3], Arrays.asList(327890L, Float.valueOf(327890.0f), 327890.0));
        expectedProjected.put(values[4], Arrays.asList(Float.valueOf(1.2f), 1.2));
        expectedProjected.put(values[5], Arrays.asList(1.2345));
        for (i = 0; i < promotableSchemas.length; ++i) {
            source = promotableSchemas[i];
            expected = (List)expectedProjected.get(values[i]);
            for (j = i; j < promotableSchemas.length; ++j) {
                target = promotableSchemas[j];
                promoted = SchemaProjector.project((Schema)source, (Object)values[i], (Schema)target);
                if (target.type() == Schema.Type.FLOAT64) {
                    Assert.assertEquals((double)((Double)expected.get(j - i)), (double)((Double)promoted), (double)1.0E-6);
                    continue;
                }
                Assert.assertEquals(expected.get(j - i), (Object)promoted);
            }
            for (j = i; j < promotableOptionalSchemas.length; ++j) {
                target = promotableOptionalSchemas[j];
                promoted = SchemaProjector.project((Schema)source, (Object)values[i], (Schema)target);
                if (target.type() == Schema.Type.FLOAT64) {
                    Assert.assertEquals((double)((Double)expected.get(j - i)), (double)((Double)promoted), (double)1.0E-6);
                    continue;
                }
                Assert.assertEquals(expected.get(j - i), (Object)promoted);
            }
        }
        for (i = 0; i < promotableOptionalSchemas.length; ++i) {
            source = promotableSchemas[i];
            expected = (List)expectedProjected.get(values[i]);
            for (j = i; j < promotableOptionalSchemas.length; ++j) {
                target = promotableOptionalSchemas[j];
                promoted = SchemaProjector.project((Schema)source, (Object)values[i], (Schema)target);
                if (target.type() == Schema.Type.FLOAT64) {
                    Assert.assertEquals((double)((Double)expected.get(j - i)), (double)((Double)promoted), (double)1.0E-6);
                    continue;
                }
                Assert.assertEquals(expected.get(j - i), (Object)promoted);
            }
        }
        Schema[] nonPromotableSchemas = new Schema[]{Schema.BOOLEAN_SCHEMA, Schema.BYTES_SCHEMA, Schema.STRING_SCHEMA};
        for (Schema promotableSchema : promotableSchemas) {
            for (Schema nonPromotableSchema : nonPromotableSchemas) {
                Object dummy = new Object();
                try {
                    SchemaProjector.project((Schema)promotableSchema, (Object)dummy, (Schema)nonPromotableSchema);
                    Assert.fail((String)("Cannot promote " + promotableSchema.type() + " to " + nonPromotableSchema.type()));
                }
                catch (DataException dataException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testPrimitiveOptionalProjection() {
        this.verifyOptionalProjection(Schema.OPTIONAL_BOOLEAN_SCHEMA, Schema.Type.BOOLEAN, false, true, false, true);
        this.verifyOptionalProjection(Schema.OPTIONAL_BOOLEAN_SCHEMA, Schema.Type.BOOLEAN, false, true, false, false);
        byte[] bytes = new byte[]{1, 2};
        byte[] defaultBytes = new byte[]{3, 4};
        this.verifyOptionalProjection(Schema.OPTIONAL_BYTES_SCHEMA, Schema.Type.BYTES, bytes, defaultBytes, bytes, true);
        this.verifyOptionalProjection(Schema.OPTIONAL_BYTES_SCHEMA, Schema.Type.BYTES, bytes, defaultBytes, bytes, false);
        this.verifyOptionalProjection(Schema.OPTIONAL_STRING_SCHEMA, Schema.Type.STRING, "abc", "def", "abc", true);
        this.verifyOptionalProjection(Schema.OPTIONAL_STRING_SCHEMA, Schema.Type.STRING, "abc", "def", "abc", false);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT8_SCHEMA, Schema.Type.INT8, (byte)12, (byte)127, (byte)12, true);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT8_SCHEMA, Schema.Type.INT8, (byte)12, (byte)127, (byte)12, false);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT8_SCHEMA, Schema.Type.INT16, (byte)12, (short)127, (short)12, true);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT8_SCHEMA, Schema.Type.INT16, (byte)12, (short)127, (short)12, false);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT8_SCHEMA, Schema.Type.INT32, (byte)12, 12789, 12, true);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT8_SCHEMA, Schema.Type.INT32, (byte)12, 12789, 12, false);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT8_SCHEMA, Schema.Type.INT64, (byte)12, 127890L, 12L, true);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT8_SCHEMA, Schema.Type.INT64, (byte)12, 127890L, 12L, false);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT8_SCHEMA, Schema.Type.FLOAT32, (byte)12, Float.valueOf(3.45f), Float.valueOf(12.0f), true);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT8_SCHEMA, Schema.Type.FLOAT32, (byte)12, Float.valueOf(3.45f), Float.valueOf(12.0f), false);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT8_SCHEMA, Schema.Type.FLOAT64, (byte)12, 3.4567, 12.0, true);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT8_SCHEMA, Schema.Type.FLOAT64, (byte)12, 3.4567, 12.0, false);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT16_SCHEMA, Schema.Type.INT16, (short)12, (short)127, (short)12, true);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT16_SCHEMA, Schema.Type.INT16, (short)12, (short)127, (short)12, false);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT16_SCHEMA, Schema.Type.INT32, (short)12, 12789, 12, true);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT16_SCHEMA, Schema.Type.INT32, (short)12, 12789, 12, false);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT16_SCHEMA, Schema.Type.INT64, (short)12, 127890L, 12L, true);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT16_SCHEMA, Schema.Type.INT64, (short)12, 127890L, 12L, false);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT16_SCHEMA, Schema.Type.FLOAT32, (short)12, Float.valueOf(3.45f), Float.valueOf(12.0f), true);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT16_SCHEMA, Schema.Type.FLOAT32, (short)12, Float.valueOf(3.45f), Float.valueOf(12.0f), false);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT16_SCHEMA, Schema.Type.FLOAT64, (short)12, 3.4567, 12.0, true);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT16_SCHEMA, Schema.Type.FLOAT64, (short)12, 3.4567, 12.0, false);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT32_SCHEMA, Schema.Type.INT32, 12, 12789, 12, true);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT32_SCHEMA, Schema.Type.INT32, 12, 12789, 12, false);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT32_SCHEMA, Schema.Type.INT64, 12, 127890L, 12L, true);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT32_SCHEMA, Schema.Type.INT64, 12, 127890L, 12L, false);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT32_SCHEMA, Schema.Type.FLOAT32, 12, Float.valueOf(3.45f), Float.valueOf(12.0f), true);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT32_SCHEMA, Schema.Type.FLOAT32, 12, Float.valueOf(3.45f), Float.valueOf(12.0f), false);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT32_SCHEMA, Schema.Type.FLOAT64, 12, 3.4567, 12.0, true);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT32_SCHEMA, Schema.Type.FLOAT64, 12, 3.4567, 12.0, false);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT64_SCHEMA, Schema.Type.INT64, 12L, 127890L, 12L, true);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT64_SCHEMA, Schema.Type.INT64, 12L, 127890L, 12L, false);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT64_SCHEMA, Schema.Type.FLOAT32, 12L, Float.valueOf(3.45f), Float.valueOf(12.0f), true);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT64_SCHEMA, Schema.Type.FLOAT32, 12L, Float.valueOf(3.45f), Float.valueOf(12.0f), false);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT64_SCHEMA, Schema.Type.FLOAT64, 12L, 3.4567, 12.0, true);
        this.verifyOptionalProjection(Schema.OPTIONAL_INT64_SCHEMA, Schema.Type.FLOAT64, 12L, 3.4567, 12.0, false);
        this.verifyOptionalProjection(Schema.OPTIONAL_FLOAT32_SCHEMA, Schema.Type.FLOAT32, Float.valueOf(12.345f), Float.valueOf(3.45f), Float.valueOf(12.345f), true);
        this.verifyOptionalProjection(Schema.OPTIONAL_FLOAT32_SCHEMA, Schema.Type.FLOAT32, Float.valueOf(12.345f), Float.valueOf(3.45f), Float.valueOf(12.345f), false);
        this.verifyOptionalProjection(Schema.OPTIONAL_FLOAT32_SCHEMA, Schema.Type.FLOAT64, Float.valueOf(12.345f), 3.4567, 12.345, true);
        this.verifyOptionalProjection(Schema.OPTIONAL_FLOAT32_SCHEMA, Schema.Type.FLOAT64, Float.valueOf(12.345f), 3.4567, 12.345, false);
        this.verifyOptionalProjection(Schema.OPTIONAL_FLOAT32_SCHEMA, Schema.Type.FLOAT64, 12.345, 3.4567, 12.345, true);
        this.verifyOptionalProjection(Schema.OPTIONAL_FLOAT32_SCHEMA, Schema.Type.FLOAT64, 12.345, 3.4567, 12.345, false);
    }

    @Test
    public void testStructAddField() {
        Schema source = SchemaBuilder.struct().field("field", Schema.INT32_SCHEMA).build();
        Struct sourceStruct = new Struct(source);
        sourceStruct.put("field", (Object)1);
        Schema target = SchemaBuilder.struct().field("field", Schema.INT32_SCHEMA).field("field2", SchemaBuilder.int32().defaultValue((Object)123).build()).build();
        Struct targetStruct = (Struct)SchemaProjector.project((Schema)source, (Object)sourceStruct, (Schema)target);
        Assert.assertEquals((long)1L, (long)targetStruct.getInt32("field").intValue());
        Assert.assertEquals((long)123L, (long)targetStruct.getInt32("field2").intValue());
        Schema incompatibleTargetSchema = SchemaBuilder.struct().field("field", Schema.INT32_SCHEMA).field("field2", Schema.INT32_SCHEMA).build();
        try {
            SchemaProjector.project((Schema)source, (Object)sourceStruct, (Schema)incompatibleTargetSchema);
            Assert.fail((String)"Incompatible schema.");
        }
        catch (DataException dataException) {
            // empty catch block
        }
    }

    @Test
    public void testStructRemoveField() {
        Schema source = SchemaBuilder.struct().field("field", Schema.INT32_SCHEMA).field("field2", Schema.INT32_SCHEMA).build();
        Struct sourceStruct = new Struct(source);
        sourceStruct.put("field", (Object)1);
        sourceStruct.put("field2", (Object)234);
        Schema target = SchemaBuilder.struct().field("field", Schema.INT32_SCHEMA).build();
        Struct targetStruct = (Struct)SchemaProjector.project((Schema)source, (Object)sourceStruct, (Schema)target);
        Assert.assertEquals((Object)1, (Object)targetStruct.get("field"));
        try {
            targetStruct.get("field2");
            Assert.fail((String)"field2 is not part of the projected struct");
        }
        catch (DataException dataException) {
            // empty catch block
        }
    }

    @Test
    public void testStructDefaultValue() {
        Schema source = SchemaBuilder.struct().optional().field("field", Schema.INT32_SCHEMA).field("field2", Schema.INT32_SCHEMA).build();
        SchemaBuilder builder = SchemaBuilder.struct().field("field", Schema.INT32_SCHEMA).field("field2", Schema.INT32_SCHEMA);
        Struct defaultStruct = new Struct((Schema)builder).put("field", (Object)12).put("field2", (Object)345);
        builder.defaultValue((Object)defaultStruct);
        Schema target = builder.build();
        Object projected = SchemaProjector.project((Schema)source, null, (Schema)target);
        Assert.assertEquals((Object)defaultStruct, (Object)projected);
        Struct sourceStruct = new Struct(source).put("field", (Object)45).put("field2", (Object)678);
        Struct targetStruct = (Struct)SchemaProjector.project((Schema)source, (Object)sourceStruct, (Schema)target);
        Assert.assertEquals((Object)sourceStruct.get("field"), (Object)targetStruct.get("field"));
        Assert.assertEquals((Object)sourceStruct.get("field2"), (Object)targetStruct.get("field2"));
    }

    @Test
    public void testNestedSchemaProjection() {
        Schema sourceFlatSchema = SchemaBuilder.struct().field("field", Schema.INT32_SCHEMA).build();
        Schema targetFlatSchema = SchemaBuilder.struct().field("field", Schema.INT32_SCHEMA).field("field2", SchemaBuilder.int32().defaultValue((Object)123).build()).build();
        Schema sourceNestedSchema = SchemaBuilder.struct().field("first", Schema.INT32_SCHEMA).field("second", Schema.STRING_SCHEMA).field("array", SchemaBuilder.array((Schema)Schema.INT32_SCHEMA).build()).field("map", SchemaBuilder.map((Schema)Schema.INT32_SCHEMA, (Schema)Schema.STRING_SCHEMA).build()).field("nested", sourceFlatSchema).build();
        Schema targetNestedSchema = SchemaBuilder.struct().field("first", Schema.INT32_SCHEMA).field("second", Schema.STRING_SCHEMA).field("array", SchemaBuilder.array((Schema)Schema.INT32_SCHEMA).build()).field("map", SchemaBuilder.map((Schema)Schema.INT32_SCHEMA, (Schema)Schema.STRING_SCHEMA).build()).field("nested", targetFlatSchema).build();
        Struct sourceFlatStruct = new Struct(sourceFlatSchema);
        sourceFlatStruct.put("field", (Object)113);
        Struct sourceNestedStruct = new Struct(sourceNestedSchema);
        sourceNestedStruct.put("first", (Object)1);
        sourceNestedStruct.put("second", (Object)"abc");
        sourceNestedStruct.put("array", Arrays.asList(1, 2));
        sourceNestedStruct.put("map", Collections.singletonMap(5, "def"));
        sourceNestedStruct.put("nested", (Object)sourceFlatStruct);
        Struct targetNestedStruct = (Struct)SchemaProjector.project((Schema)sourceNestedSchema, (Object)sourceNestedStruct, (Schema)targetNestedSchema);
        Assert.assertEquals((Object)1, (Object)targetNestedStruct.get("first"));
        Assert.assertEquals((Object)"abc", (Object)targetNestedStruct.get("second"));
        Assert.assertEquals(Arrays.asList(1, 2), (Object)targetNestedStruct.get("array"));
        Assert.assertEquals(Collections.singletonMap(5, "def"), (Object)targetNestedStruct.get("map"));
        Struct projectedStruct = (Struct)targetNestedStruct.get("nested");
        Assert.assertEquals((Object)113, (Object)projectedStruct.get("field"));
        Assert.assertEquals((Object)123, (Object)projectedStruct.get("field2"));
    }

    @Test
    public void testLogicalTypeProjection() {
        Schema[] logicalTypeSchemas = new Schema[]{Decimal.schema((int)2), Date.SCHEMA, Time.SCHEMA, Timestamp.SCHEMA};
        BigDecimal testDecimal = new BigDecimal(new BigInteger("156"), 2);
        Object projected = SchemaProjector.project((Schema)Decimal.schema((int)2), (Object)testDecimal, (Schema)Decimal.schema((int)2));
        Assert.assertEquals((Object)testDecimal, (Object)projected);
        projected = SchemaProjector.project((Schema)Date.SCHEMA, (Object)1000, (Schema)Date.SCHEMA);
        Assert.assertEquals((Object)1000, (Object)projected);
        projected = SchemaProjector.project((Schema)Time.SCHEMA, (Object)231, (Schema)Time.SCHEMA);
        Assert.assertEquals((Object)231, (Object)projected);
        projected = SchemaProjector.project((Schema)Timestamp.SCHEMA, (Object)34567L, (Schema)Timestamp.SCHEMA);
        Assert.assertEquals((Object)34567L, (Object)projected);
        java.util.Date date = new java.util.Date();
        projected = SchemaProjector.project((Schema)Date.SCHEMA, (Object)date, (Schema)Date.SCHEMA);
        Assert.assertEquals((Object)date, (Object)projected);
        projected = SchemaProjector.project((Schema)Time.SCHEMA, (Object)date, (Schema)Time.SCHEMA);
        Assert.assertEquals((Object)date, (Object)projected);
        projected = SchemaProjector.project((Schema)Timestamp.SCHEMA, (Object)date, (Schema)Timestamp.SCHEMA);
        Assert.assertEquals((Object)date, (Object)projected);
        Schema namedSchema = SchemaBuilder.int32().name("invalidLogicalTypeName").build();
        for (Schema logicalTypeSchema : logicalTypeSchemas) {
            try {
                SchemaProjector.project((Schema)logicalTypeSchema, null, (Schema)Schema.BOOLEAN_SCHEMA);
                Assert.fail((String)"Cannot project logical types to non-logical types.");
            }
            catch (SchemaProjectorException schemaProjectorException) {
                // empty catch block
            }
            try {
                SchemaProjector.project((Schema)logicalTypeSchema, null, (Schema)namedSchema);
                Assert.fail((String)"Reader name is not a valid logical type name.");
            }
            catch (SchemaProjectorException schemaProjectorException) {
                // empty catch block
            }
            try {
                SchemaProjector.project((Schema)Schema.BOOLEAN_SCHEMA, null, (Schema)logicalTypeSchema);
                Assert.fail((String)"Cannot project non-logical types to logical types.");
            }
            catch (SchemaProjectorException schemaProjectorException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testArrayProjection() {
        Schema source = SchemaBuilder.array((Schema)Schema.INT32_SCHEMA).build();
        Object projected = SchemaProjector.project((Schema)source, Arrays.asList(1, 2, 3), (Schema)source);
        Assert.assertEquals(Arrays.asList(1, 2, 3), (Object)projected);
        Schema optionalSource = SchemaBuilder.array((Schema)Schema.INT32_SCHEMA).optional().build();
        Schema target = SchemaBuilder.array((Schema)Schema.INT32_SCHEMA).defaultValue(Arrays.asList(1, 2, 3)).build();
        projected = SchemaProjector.project((Schema)optionalSource, Arrays.asList(4, 5), (Schema)target);
        Assert.assertEquals(Arrays.asList(4, 5), (Object)projected);
        projected = SchemaProjector.project((Schema)optionalSource, null, (Schema)target);
        Assert.assertEquals(Arrays.asList(1, 2, 3), (Object)projected);
        Schema promotedTarget = SchemaBuilder.array((Schema)Schema.INT64_SCHEMA).defaultValue(Arrays.asList(1L, 2L, 3L)).build();
        projected = SchemaProjector.project((Schema)optionalSource, Arrays.asList(4, 5), (Schema)promotedTarget);
        List<Long> expectedProjected = Arrays.asList(4L, 5L);
        Assert.assertEquals(expectedProjected, (Object)projected);
        projected = SchemaProjector.project((Schema)optionalSource, null, (Schema)promotedTarget);
        Assert.assertEquals(Arrays.asList(1L, 2L, 3L), (Object)projected);
        Schema noDefaultValueTarget = SchemaBuilder.array((Schema)Schema.INT32_SCHEMA).build();
        try {
            SchemaProjector.project((Schema)optionalSource, null, (Schema)noDefaultValueTarget);
            Assert.fail((String)"Target schema does not provide a default value.");
        }
        catch (SchemaProjectorException schemaProjectorException) {
            // empty catch block
        }
        Schema nonPromotableTarget = SchemaBuilder.array((Schema)Schema.BOOLEAN_SCHEMA).build();
        try {
            SchemaProjector.project((Schema)optionalSource, null, (Schema)nonPromotableTarget);
            Assert.fail((String)"Neither source type matches target type nor source type can be promoted to target type");
        }
        catch (SchemaProjectorException schemaProjectorException) {
            // empty catch block
        }
    }

    @Test
    public void testMapProjection() {
        Schema source = SchemaBuilder.map((Schema)Schema.INT32_SCHEMA, (Schema)Schema.INT32_SCHEMA).optional().build();
        Schema target = SchemaBuilder.map((Schema)Schema.INT32_SCHEMA, (Schema)Schema.INT32_SCHEMA).defaultValue(Collections.singletonMap(1, 2)).build();
        Object projected = SchemaProjector.project((Schema)source, Collections.singletonMap(3, 4), (Schema)target);
        Assert.assertEquals(Collections.singletonMap(3, 4), (Object)projected);
        projected = SchemaProjector.project((Schema)source, null, (Schema)target);
        Assert.assertEquals(Collections.singletonMap(1, 2), (Object)projected);
        Schema promotedTarget = SchemaBuilder.map((Schema)Schema.INT64_SCHEMA, (Schema)Schema.FLOAT32_SCHEMA).defaultValue(Collections.singletonMap(3L, Float.valueOf(4.5f))).build();
        projected = SchemaProjector.project((Schema)source, Collections.singletonMap(3, 4), (Schema)promotedTarget);
        Assert.assertEquals(Collections.singletonMap(3L, Float.valueOf(4.0f)), (Object)projected);
        projected = SchemaProjector.project((Schema)source, null, (Schema)promotedTarget);
        Assert.assertEquals(Collections.singletonMap(3L, Float.valueOf(4.5f)), (Object)projected);
        Schema noDefaultValueTarget = SchemaBuilder.map((Schema)Schema.INT32_SCHEMA, (Schema)Schema.INT32_SCHEMA).build();
        try {
            SchemaProjector.project((Schema)source, null, (Schema)noDefaultValueTarget);
            Assert.fail((String)"Reader does not provide a default value.");
        }
        catch (SchemaProjectorException schemaProjectorException) {
            // empty catch block
        }
        Schema nonPromotableTarget = SchemaBuilder.map((Schema)Schema.BOOLEAN_SCHEMA, (Schema)Schema.STRING_SCHEMA).build();
        try {
            SchemaProjector.project((Schema)source, null, (Schema)nonPromotableTarget);
            Assert.fail((String)"Neither source type matches target type nor source type can be promoted to target type");
        }
        catch (SchemaProjectorException schemaProjectorException) {
            // empty catch block
        }
    }

    @Test
    public void testMaybeCompatible() {
        Schema source = SchemaBuilder.int32().name("source").build();
        Schema target = SchemaBuilder.int32().name("target").build();
        try {
            SchemaProjector.project((Schema)source, (Object)12, (Schema)target);
            Assert.fail((String)"Source name and target name mismatch.");
        }
        catch (SchemaProjectorException schemaProjectorException) {
            // empty catch block
        }
        SchemaBuilder targetWithParameters = SchemaBuilder.int32().parameters(Collections.singletonMap("key", "value"));
        try {
            SchemaProjector.project((Schema)source, (Object)34, (Schema)targetWithParameters);
            Assert.fail((String)"Source parameters and target parameters mismatch.");
        }
        catch (SchemaProjectorException schemaProjectorException) {
            // empty catch block
        }
    }

    @Test
    public void testProjectMissingDefaultValuedStructField() {
        Schema source = SchemaBuilder.struct().build();
        Schema target = SchemaBuilder.struct().field("id", SchemaBuilder.int64().defaultValue((Object)42L).build()).build();
        Assert.assertEquals((long)42L, (long)((Struct)SchemaProjector.project((Schema)source, (Object)new Struct(source), (Schema)target)).getInt64("id"));
    }

    @Test
    public void testProjectMissingOptionalStructField() {
        Schema source = SchemaBuilder.struct().build();
        Schema target = SchemaBuilder.struct().field("id", SchemaBuilder.OPTIONAL_INT64_SCHEMA).build();
        Assert.assertEquals(null, (Object)((Struct)SchemaProjector.project((Schema)source, (Object)new Struct(source), (Schema)target)).getInt64("id"));
    }

    @Test(expected=SchemaProjectorException.class)
    public void testProjectMissingRequiredField() {
        Schema source = SchemaBuilder.struct().build();
        Schema target = SchemaBuilder.struct().field("id", SchemaBuilder.INT64_SCHEMA).build();
        SchemaProjector.project((Schema)source, (Object)new Struct(source), (Schema)target);
    }

    private void verifyOptionalProjection(Schema source, Schema.Type targetType, Object value, Object defaultValue, Object expectedProjected, boolean optional) {
        assert (source.isOptional());
        assert (value != null);
        Schema target = optional ? SchemaBuilder.type((Schema.Type)targetType).optional().defaultValue(defaultValue).build() : SchemaBuilder.type((Schema.Type)targetType).defaultValue(defaultValue).build();
        Object projected = SchemaProjector.project((Schema)source, (Object)value, (Schema)target);
        if (targetType == Schema.Type.FLOAT64) {
            Assert.assertEquals((double)((Double)expectedProjected), (double)((Double)projected), (double)1.0E-6);
        } else {
            Assert.assertEquals((Object)expectedProjected, (Object)projected);
        }
        projected = SchemaProjector.project((Schema)source, null, (Schema)target);
        if (optional) {
            Assert.assertEquals(null, (Object)projected);
        } else {
            Assert.assertEquals((Object)defaultValue, (Object)projected);
        }
    }
}

