/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.tck;

import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.jaxb.EntityCreator;
import org.junit.Assert;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.DeleteBinding;
import org.uddi.api_v3.SaveBinding;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.sub_v3.DeleteSubscription;
import org.uddi.sub_v3.Subscription;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISubscriptionPortType;

public class TckSubscriptionListener {
    public static final String LISTENER_HTTP_SERVICE_XML = "uddi_data/subscriptionnotifier/listenerService.xml";
    public static final String LISTENER_SMTP_SERVICE_XML = "uddi_data/subscriptionnotifier/listenerServiceSMTP.xml";
    public static final String LISTENER_SMTP_SERVICE_EXTERNAL_XML = "uddi_data/subscriptionnotifier/listenerServiceSMTP-external.xml";
    public static final String LISTENER_RMI_SERVICE_XML = "uddi_data/subscriptionnotifier/listenerServiceRMI.xml";
    public static final String LISTENER_SERVICE_KEY = "uddi:uddi.joepublisher.com:listenerone";
    public static final String SUBSCRIPTION_XML = "uddi_data/subscriptionnotifier/subscription1.xml";
    public static final String SUBSCRIPTION2_XML = "uddi_data/subscriptionnotifier/subscription2.xml";
    public static final String SUBSCRIPTION2_SMTP_XML = "uddi_data/subscriptionnotifier/subscription2SMTP.xml";
    public static final String SUBSCRIPTION_SMTP_XML = "uddi_data/subscriptionnotifier/subscription1SMTP.xml";
    public static final String SUBSCRIPTION3_XML = "uddi_data/subscriptionnotifier/subscription3.xml";
    public static final String SUBSCRIPTION3_SMTP_XML = "uddi_data/subscriptionnotifier/subscription3SMTP.xml";
    public static final String SUBSCRIPTION_KEY = "uddi:uddi.joepublisher.com:subscriptionone";
    public static final String SUBSCRIPTION_SMTP_KEY = "uddi:uddi.joepublisher.com:subscriptiononesmtp";
    private Log logger = LogFactory.getLog(this.getClass());
    private UDDIPublicationPortType publication = null;
    private UDDISubscriptionPortType subscription = null;
    private SaveService ss = null;

    public TckSubscriptionListener(UDDISubscriptionPortType subscription, UDDIPublicationPortType publication) {
        this.subscription = subscription;
        this.publication = publication;
    }

    public void saveNotifierBinding(String authInfo, String bindingXML, String bindingKey, Integer port) {
        try {
            SaveBinding sb = new SaveBinding();
            sb.setAuthInfo(authInfo);
            BindingTemplate btIn = (BindingTemplate)EntityCreator.buildFromDoc((String)bindingXML, (String)"org.uddi.api_v3");
            String value = btIn.getAccessPoint().getValue();
            value = value.replace("{randomPort}", port.toString());
            sb.getBindingTemplate().add(btIn);
            this.publication.saveBinding(sb);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)("No exception should be thrown: " + e.getMessage()));
        }
    }

    public void deleteBinding(String authInfo, String bindingKey) {
        try {
            DeleteBinding db = new DeleteBinding();
            db.setAuthInfo(authInfo);
            db.getBindingKey().add(bindingKey);
            this.publication.deleteBinding(db);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }

    public void saveService(String authInfo, String listenerService, Integer port, String hostname) {
        try {
            this.ss = new SaveService();
            this.ss.setAuthInfo(authInfo);
            BusinessService bsIn = (BusinessService)EntityCreator.buildFromDoc((String)listenerService, (String)"org.uddi.api_v3");
            for (BindingTemplate btIn : bsIn.getBindingTemplates().getBindingTemplate()) {
                String value = btIn.getAccessPoint().getValue();
                value = value.replace("{randomPort}", port.toString());
                value = value.replace("{hostname}", hostname);
                btIn.getAccessPoint().setValue(value);
                this.logger.info((Object)("service " + bsIn.getServiceKey() + " access point " + btIn.getAccessPoint().getValue() + " key:" + btIn.getBindingKey()));
            }
            this.ss.getBusinessService().add(bsIn);
            ServiceDetail bsOut = this.publication.saveService(this.ss);
            Assert.assertNotNull((Object)bsOut);
            Assert.assertEquals((Object)((BusinessService)bsOut.getBusinessService().get(0)).getBusinessKey(), (Object)bsIn.getBusinessKey());
            if (bsIn.getBindingTemplates() != null) {
                Assert.assertNotNull((Object)((BusinessService)bsOut.getBusinessService().get(0)).getBindingTemplates());
                Assert.assertEquals((long)((BusinessService)bsOut.getBusinessService().get(0)).getBindingTemplates().getBindingTemplate().size(), (long)bsIn.getBindingTemplates().getBindingTemplate().size());
                for (int i = 0; i < bsIn.getBindingTemplates().getBindingTemplate().size(); ++i) {
                    Assert.assertEquals((Object)((BindingTemplate)bsIn.getBindingTemplates().getBindingTemplate().get(i)).getAccessPoint().getValue(), (Object)((BindingTemplate)((BusinessService)bsOut.getBusinessService().get(0)).getBindingTemplates().getBindingTemplate().get(i)).getAccessPoint().getValue());
                }
            }
            Assert.assertEquals((Object)((BusinessService)bsOut.getBusinessService().get(0)).getServiceKey(), (Object)bsIn.getServiceKey());
            this.logger.info((Object)("service " + bsIn.getServiceKey() + " saved"));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }

    public void saveNotifierSubscription(String authInfo, String subscriptionXML) {
        this.saveSubscription(authInfo, subscriptionXML, SUBSCRIPTION_KEY);
    }

    public void deleteNotifierSubscription(String authInfo, String subscriptionKey) {
        this.deleteSubscription(authInfo, subscriptionKey);
    }

    public void saveSubscription(String authInfo, String subscriptionXML, String subscriptionKey) {
        this.saveSubscription(authInfo, subscriptionXML, subscriptionKey, null);
    }

    public void saveSubscription(String authInfo, String subscriptionXML, String subscriptionKey, String bindingkey) {
        try {
            this.logger.info((Object)("saving subscription " + subscriptionKey + " " + subscriptionXML + " " + bindingkey));
            Subscription subIn = (Subscription)EntityCreator.buildFromDoc((String)subscriptionXML, (String)"org.uddi.sub_v3");
            ArrayList<Subscription> subscriptionList = new ArrayList<Subscription>();
            subscriptionList.add(subIn);
            Holder subscriptionHolder = new Holder();
            subscriptionHolder.value = subscriptionList;
            this.subscription.saveSubscription(authInfo, subscriptionHolder);
            Subscription subDirectOut = (Subscription)((List)subscriptionHolder.value).get(0);
            Assert.assertEquals((Object)subIn.getSubscriptionKey(), (Object)subDirectOut.getSubscriptionKey());
            List outSubscriptionList = this.subscription.getSubscriptions(authInfo);
            Assert.assertNotNull((Object)outSubscriptionList);
            Subscription subOut = (Subscription)outSubscriptionList.get(0);
            Assert.assertEquals((long)subDirectOut.getExpiresAfter().getMonth(), (long)subOut.getExpiresAfter().getMonth());
            Assert.assertEquals((long)subDirectOut.getExpiresAfter().getDay(), (long)subOut.getExpiresAfter().getDay());
            Assert.assertEquals((long)subDirectOut.getExpiresAfter().getYear(), (long)subOut.getExpiresAfter().getYear());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    public void deleteSubscription(String authInfo, String subscriptionKey) {
        try {
            DeleteSubscription ds = new DeleteSubscription();
            ds.setAuthInfo(authInfo);
            ds.getSubscriptionKey().add(subscriptionKey);
            this.subscription.deleteSubscription(ds);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }
}

