/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.tck;

import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.jaxb.EntityCreator;
import org.apache.juddi.v3.tck.TckValidator;
import org.junit.Assert;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.ServiceInfo;
import org.uddi.api_v3.ServiceInfos;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelList;
import org.uddi.sub_v3.DeleteSubscription;
import org.uddi.sub_v3.GetSubscriptionResults;
import org.uddi.sub_v3.KeyBag;
import org.uddi.sub_v3.Subscription;
import org.uddi.sub_v3.SubscriptionResultsList;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDISecurityPortType;
import org.uddi.v3_service.UDDISubscriptionPortType;

public class TckSubscription {
    static final String JOE_SUBSCRIPTION_XML = "uddi_data/subscription/subscription1.xml";
    static final String JOE_SUBSCRIPTION_KEY = "uddi:uddi.joepublisher.com:subscriptionone";
    static final String JOE_SUBSCRIPTIONRESULTS_XML = "uddi_data/subscription/subscriptionresults1.xml";
    static final String SAM_SUBSCRIPTION_XML = "uddi_data/subscription/subscription2.xml";
    static final String SAM_SUBSCRIPTION_KEY = "uddi:www.samco.com:subscriptionone";
    static final String SAM_SUBSCRIPTIONRESULTS_XML = "uddi_data/subscription/subscriptionresults2.xml";
    static final String SAM_DUMMYBUSINESSKEY = "uddi:www.this.key.doesnot.exist";
    static final String SAM_SUBSCRIPTION2_XML = "uddi_data/subscription/subscription3.xml";
    static final String SAM_SUBSCRIPTION2_KEY = "uddi:www.samco.com:subscriptiontwo";
    static final String SAM_SUBSCRIPTIONRESULTS2_XML = "uddi_data/subscription/subscriptionresults3.xml";
    static int FINDQUALIFIER_TMODEL_TOTAL = 22;
    static final String SAM_SUBSCRIPTION3_XML = "uddi_data/subscription/subscription4.xml";
    static final String SAM_SUBSCRIPTION3_KEY = "uddi:www.samco.com:subscriptionthree";
    static final String SAM_SUBSCRIPTIONRESULTS3_XML = "uddi_data/subscription/subscriptionresults4.xml";
    private Log logger = LogFactory.getLog(this.getClass());
    UDDISubscriptionPortType subscription = null;
    UDDISecurityPortType security = null;
    UDDIInquiryPortType inquiry = null;

    public TckSubscription(UDDISubscriptionPortType subscription, UDDISecurityPortType security, UDDIInquiryPortType inquiry) {
        this.subscription = subscription;
        this.security = security;
        this.inquiry = inquiry;
    }

    public void saveJoePublisherSubscription(String authInfoJoe, String subscriptionXML, String subscriptionKey) {
        this.saveSubscription(authInfoJoe, subscriptionXML, subscriptionKey, null);
    }

    public void saveJoePublisherSubscription(String authInfoJoe) {
        this.saveSubscription(authInfoJoe, JOE_SUBSCRIPTION_XML, JOE_SUBSCRIPTION_KEY, null);
    }

    public void saveJoePublisherSubscription(String authInfoJoe, String bindingkey) {
        this.saveSubscription(authInfoJoe, JOE_SUBSCRIPTION_XML, JOE_SUBSCRIPTION_KEY, bindingkey);
    }

    public void deleteJoePublisherSubscription(String authInfoJoe) {
        this.deleteSubscription(authInfoJoe, JOE_SUBSCRIPTION_KEY);
    }

    public void getJoePublisherSubscriptionResults(String authInfoJoe) {
        try {
            List siList;
            GetSubscriptionResults getSubResultsIn = (GetSubscriptionResults)EntityCreator.buildFromDoc((String)JOE_SUBSCRIPTIONRESULTS_XML, (String)"org.uddi.sub_v3");
            getSubResultsIn.setAuthInfo(authInfoJoe);
            SubscriptionResultsList result = this.subscription.getSubscriptionResults(getSubResultsIn);
            if (result == null) {
                Assert.fail((String)"Null result from getSubscriptionResults operation");
            }
            ServiceInfos sInfos = null;
            if (result.getServiceList() != null) {
                sInfos = result.getServiceList().getServiceInfos();
            }
            if (sInfos == null) {
                Assert.fail((String)"No result from getSubscriptionResults operation");
            }
            if ((siList = sInfos.getServiceInfo()) == null || siList.size() == 0) {
                Assert.fail((String)"No result from getSubscriptionResults operation");
            }
            ServiceInfo siOut = (ServiceInfo)siList.get(0);
            BusinessService bsIn = (BusinessService)EntityCreator.buildFromDoc((String)"uddi_data/joepublisher/businessService.xml", (String)"org.uddi.api_v3");
            junit.framework.Assert.assertEquals((String)bsIn.getServiceKey(), (String)siOut.getServiceKey());
            TckValidator.checkNames(bsIn.getName(), siOut.getName());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    public void saveSamSyndicatorSubscription(String authInfoSam) {
        this.saveSubscription(authInfoSam, SAM_SUBSCRIPTION_XML, SAM_SUBSCRIPTION_KEY, null);
    }

    public void saveSamSyndicatorSubscriptionWithChunkingOnFind(String authInfoSam) {
        this.saveSubscription(authInfoSam, SAM_SUBSCRIPTION2_XML, SAM_SUBSCRIPTION2_KEY, null);
    }

    public void saveSamSyndicatorSubscriptionWithChunkingOnGet(String authInfoSam) {
        this.saveSubscription(authInfoSam, SAM_SUBSCRIPTION3_XML, SAM_SUBSCRIPTION3_KEY, null);
    }

    public void deleteSamSyndicatorSubscription(String authInfoSam) {
        this.deleteSubscription(authInfoSam, SAM_SUBSCRIPTION_KEY);
    }

    public void deleteSamSyndicatorSubscriptionWithChunkingOnFind(String authInfoSam) {
        this.deleteSubscription(authInfoSam, SAM_SUBSCRIPTION2_KEY);
    }

    public void deleteSamSyndicatorSubscriptionWithChunkingOnGet(String authInfoSam) {
        this.deleteSubscription(authInfoSam, SAM_SUBSCRIPTION3_KEY);
    }

    public void getSamSyndicatorSubscriptionResults(String authInfoSam) {
        try {
            List beList;
            BusinessDetail busDetail;
            GetSubscriptionResults getSubResultsIn = (GetSubscriptionResults)EntityCreator.buildFromDoc((String)SAM_SUBSCRIPTIONRESULTS_XML, (String)"org.uddi.sub_v3");
            getSubResultsIn.setAuthInfo(authInfoSam);
            SubscriptionResultsList result = this.subscription.getSubscriptionResults(getSubResultsIn);
            if (result == null) {
                Assert.fail((String)"Null result from getSubscriptionResults operation");
            }
            if ((busDetail = result.getBusinessDetail()) == null) {
                Assert.fail((String)"No result from getSubscriptionResults operation");
            }
            if ((beList = busDetail.getBusinessEntity()) == null || beList.size() == 0) {
                Assert.fail((String)"No result from getSubscriptionResults operation");
            }
            BusinessEntity beOut = (BusinessEntity)beList.get(0);
            BusinessEntity beIn = (BusinessEntity)EntityCreator.buildFromDoc((String)"uddi_data/samsyndicator/businessEntity.xml", (String)"org.uddi.api_v3");
            junit.framework.Assert.assertEquals((String)beIn.getBusinessKey(), (String)beOut.getBusinessKey());
            TckValidator.checkNames(beIn.getName(), beOut.getName());
            TckValidator.checkDescriptions(beIn.getDescription(), beOut.getDescription());
            TckValidator.checkDiscoveryUrls(beIn.getDiscoveryURLs(), beOut.getDiscoveryURLs());
            TckValidator.checkContacts(beIn.getContacts(), beOut.getContacts());
            TckValidator.checkCategories(beIn.getCategoryBag(), beOut.getCategoryBag());
            List keyBagList = result.getKeyBag();
            if (keyBagList == null || keyBagList.size() == 0) {
                Assert.fail((String)"No keyBag from SamSyndicator getSubscriptionResults operation");
            }
            KeyBag keyBag = (KeyBag)keyBagList.get(0);
            junit.framework.Assert.assertEquals((String)SAM_DUMMYBUSINESSKEY, (String)((String)keyBag.getBusinessKey().get(0)));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    public void getSamSyndicatorSubscriptionResultsWithChunkingOnFind(String authInfoSam) {
        try {
            GetSubscriptionResults getSubResultsIn = (GetSubscriptionResults)EntityCreator.buildFromDoc((String)SAM_SUBSCRIPTIONRESULTS2_XML, (String)"org.uddi.sub_v3");
            getSubResultsIn.setAuthInfo(authInfoSam);
            FindTModel ftm = new FindTModel();
            ftm.setAuthInfo(authInfoSam);
            ftm.setCategoryBag(new CategoryBag());
            ftm.getCategoryBag().getKeyedReference().add(new KeyedReference("uddi:uddi.org:categorization:types", "uddi-org:types:findQualifier", "findQualifier"));
            TModelList findTModel = this.inquiry.findTModel(ftm);
            FINDQUALIFIER_TMODEL_TOTAL = findTModel.getListDescription().getActualCount();
            Subscription subIn = (Subscription)EntityCreator.buildFromDoc((String)SAM_SUBSCRIPTION2_XML, (String)"org.uddi.sub_v3");
            int expectedIterations = FINDQUALIFIER_TMODEL_TOTAL / subIn.getMaxEntities();
            if (FINDQUALIFIER_TMODEL_TOTAL % subIn.getMaxEntities() > 0) {
                ++expectedIterations;
            }
            this.logger.info((Object)("getSamSyndicatorSubscriptionResultsWithChunkingOnFind loading from uddi_data/subscription/subscription3.xml expecting " + FINDQUALIFIER_TMODEL_TOTAL + " find qualifier tmodels. Fetching " + subIn.getMaxEntities() + " at a time, expected iterations " + expectedIterations));
            String chunkToken = "";
            int iterations = 0;
            while (chunkToken != null && !chunkToken.equalsIgnoreCase("0")) {
                ++iterations;
                getSubResultsIn.setChunkToken(chunkToken);
                SubscriptionResultsList result = this.subscription.getSubscriptionResults(getSubResultsIn);
                if (result == null) {
                    Assert.fail((String)"Null result from getSubscriptionResults operation");
                }
                Assert.assertNotNull((String)"Chunk token should either be not null or '0'", (Object)result.getChunkToken());
                TModelList tmodelList = result.getTModelList();
                if (tmodelList == null || tmodelList.getTModelInfos() == null) {
                    Assert.fail((String)("No result from getSubscriptionResults operation on chunk attempt " + iterations));
                }
                int resultSize = tmodelList.getTModelInfos().getTModelInfo().size();
                if (iterations < expectedIterations) {
                    junit.framework.Assert.assertEquals((int)resultSize, (int)subIn.getMaxEntities());
                } else if (FINDQUALIFIER_TMODEL_TOTAL % subIn.getMaxEntities() > 0) {
                    junit.framework.Assert.assertEquals((int)resultSize, (int)(FINDQUALIFIER_TMODEL_TOTAL % subIn.getMaxEntities()));
                } else {
                    junit.framework.Assert.assertEquals((int)resultSize, (int)subIn.getMaxEntities());
                }
                chunkToken = result.getChunkToken();
            }
            junit.framework.Assert.assertEquals((int)iterations, (int)expectedIterations);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    public void getSamSyndicatorSubscriptionResultsWithChunkingOnGet(String authInfoSam) {
        try {
            GetSubscriptionResults getSubResultsIn = (GetSubscriptionResults)EntityCreator.buildFromDoc((String)SAM_SUBSCRIPTIONRESULTS3_XML, (String)"org.uddi.sub_v3");
            getSubResultsIn.setAuthInfo(authInfoSam);
            Subscription subIn = (Subscription)EntityCreator.buildFromDoc((String)SAM_SUBSCRIPTION3_XML, (String)"org.uddi.sub_v3");
            FINDQUALIFIER_TMODEL_TOTAL = 22;
            int expectedIterations = FINDQUALIFIER_TMODEL_TOTAL / subIn.getMaxEntities();
            if (FINDQUALIFIER_TMODEL_TOTAL % subIn.getMaxEntities() > 0) {
                ++expectedIterations;
            }
            String chunkToken = "";
            int iterations = 0;
            while (chunkToken != null && !chunkToken.equalsIgnoreCase("0")) {
                ++iterations;
                getSubResultsIn.setChunkToken(chunkToken);
                SubscriptionResultsList result = this.subscription.getSubscriptionResults(getSubResultsIn);
                if (result == null) {
                    Assert.fail((String)"Null result from getSubscriptionResults operation");
                }
                Assert.assertNotNull((String)"Chunk token should either be not null or '0'", (Object)result.getChunkToken());
                TModelDetail tmodelDetail = result.getTModelDetail();
                if (tmodelDetail == null) {
                    Assert.fail((String)("No result from getSubscriptionResults operation on chunk attempt " + iterations));
                }
                int resultSize = tmodelDetail.getTModel().size();
                if (iterations < expectedIterations) {
                    junit.framework.Assert.assertEquals((int)resultSize, (int)subIn.getMaxEntities());
                } else if (FINDQUALIFIER_TMODEL_TOTAL % subIn.getMaxEntities() > 0) {
                    junit.framework.Assert.assertEquals((int)resultSize, (int)(FINDQUALIFIER_TMODEL_TOTAL % subIn.getMaxEntities()));
                } else {
                    junit.framework.Assert.assertEquals((int)resultSize, (int)subIn.getMaxEntities());
                }
                chunkToken = result.getChunkToken();
            }
            junit.framework.Assert.assertEquals((int)iterations, (int)expectedIterations);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    public void saveSubscription(String authInfo, String subscriptionXML, String subscriptionKey, String bindingkey) {
        try {
            Subscription subIn = (Subscription)EntityCreator.buildFromDoc((String)subscriptionXML, (String)"org.uddi.sub_v3");
            ArrayList<Subscription> subscriptionList = new ArrayList<Subscription>();
            subIn.setSubscriptionKey(subscriptionKey);
            subIn.setBindingKey(bindingkey);
            subscriptionList.add(subIn);
            Holder subscriptionHolder = new Holder();
            subscriptionHolder.value = subscriptionList;
            this.subscription.saveSubscription(authInfo, subscriptionHolder);
            Subscription subDirectOut = (Subscription)((List)subscriptionHolder.value).get(0);
            junit.framework.Assert.assertEquals((String)subIn.getSubscriptionKey(), (String)subDirectOut.getSubscriptionKey());
            List outSubscriptionList = this.subscription.getSubscriptions(authInfo);
            Assert.assertNotNull((Object)outSubscriptionList);
            Subscription subOut = (Subscription)outSubscriptionList.get(0);
            junit.framework.Assert.assertEquals((String)subIn.getSubscriptionKey(), (String)subOut.getSubscriptionKey());
            junit.framework.Assert.assertEquals((int)subDirectOut.getExpiresAfter().getMonth(), (int)subOut.getExpiresAfter().getMonth());
            junit.framework.Assert.assertEquals((int)subDirectOut.getExpiresAfter().getDay(), (int)subOut.getExpiresAfter().getDay());
            junit.framework.Assert.assertEquals((int)subDirectOut.getExpiresAfter().getYear(), (int)subOut.getExpiresAfter().getYear());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown");
        }
    }

    public void deleteSubscription(String authInfo, String subscriptionKey) {
        try {
            DeleteSubscription ds = new DeleteSubscription();
            ds.setAuthInfo(authInfo);
            ds.getSubscriptionKey().add(subscriptionKey);
            this.subscription.deleteSubscription(ds);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }
}

