/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.tck;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.jaxb.EntityCreator;
import org.apache.juddi.v3.tck.TckValidator;
import org.junit.Assert;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessInfo;
import org.uddi.api_v3.BusinessInfos;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.DispositionReport;
import org.uddi.api_v3.FindBinding;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindRelatedBusinesses;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.RelatedBusinessInfo;
import org.uddi.api_v3.RelatedBusinessInfos;
import org.uddi.api_v3.RelatedBusinessesList;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.ServiceInfo;
import org.uddi.api_v3.ServiceInfos;
import org.uddi.api_v3.ServiceList;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelInfo;
import org.uddi.api_v3.TModelInfos;
import org.uddi.api_v3.TModelList;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDIInquiryPortType;

public class TckFindEntity {
    static final String FIND_BUSINESS_XML = "uddi_data/find/findBusiness1.xml";
    static final String FIND_ALL_BUSINESSES_XML = "uddi_data/find/findAllBusinesses.xml";
    static final String FIND_ALL_SIGNED_BUSINESSES_XML = "uddi_data/find/findAllSignedBusinesses.xml";
    static final String FIND_RELATED_BUSINESS_SORT_BY_NAME_XML = "uddi_data/find/findRelatedBusinesses_sortByName.xml";
    static final String FIND_RELATED_BUSINESS_FROM_KEY = "uddi_data/find/findRelatedBusinesses_fromKey.xml";
    static final String FIND_RELATED_BUSINESS_TO_KEY = "uddi_data/find/findRelatedBusinesses_toKey.xml";
    static final String FIND_SERVICE_XML = "uddi_data/find/findService1.xml";
    static final String FIND_BINDING_XML = "uddi_data/find/findBinding1.xml";
    static final String FIND_TMODEL_XML = "uddi_data/find/findTModel1.xml";
    static final String COMBINE_CAT_FIND_SERVICES = "uddi_data/joepublisher/combineCatBagsFindServices.xml";
    private Log logger = LogFactory.getLog(this.getClass());
    UDDIInquiryPortType inquiry = null;

    public TckFindEntity(UDDIInquiryPortType inquiry) {
        this.inquiry = inquiry;
    }

    public void findBusiness() {
        try {
            List biList;
            BusinessInfos bInfos;
            FindBusiness body = (FindBusiness)EntityCreator.buildFromDoc((String)FIND_BUSINESS_XML, (String)"org.uddi.api_v3");
            BusinessList result = this.inquiry.findBusiness(body);
            if (result == null) {
                Assert.fail((String)"Null result from find business operation");
            }
            if ((bInfos = result.getBusinessInfos()) == null) {
                Assert.fail((String)"No result from find business operation");
            }
            if ((biList = bInfos.getBusinessInfo()) == null || biList.size() == 0) {
                Assert.fail((String)"No result from find business operation");
            }
            BusinessInfo biOut = (BusinessInfo)biList.get(0);
            BusinessEntity beIn = (BusinessEntity)EntityCreator.buildFromDoc((String)"uddi_data/joepublisher/businessEntity.xml", (String)"org.uddi.api_v3");
            junit.framework.Assert.assertEquals((String)beIn.getBusinessKey(), (String)biOut.getBusinessKey());
            TckValidator.checkNames(beIn.getName(), biOut.getName());
            TckValidator.checkDescriptions(beIn.getDescription(), biOut.getDescription());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }

    public void getNonExitingBusiness() {
        String nonExistingKey = "nonexistingKey";
        try {
            GetBusinessDetail body = new GetBusinessDetail();
            body.getBusinessKey().add(nonExistingKey);
            BusinessDetail result = this.inquiry.getBusinessDetail(body);
            Assert.fail((String)"No business should be found");
            System.out.println(result.getBusinessEntity().size());
        }
        catch (Exception e) {
            try {
                System.out.println("(Expected) Error message = " + e.getMessage());
                DispositionReport report = DispositionReportFaultMessage.getDispositionReport((Exception)e);
                junit.framework.Assert.assertNotNull((Object)report);
                junit.framework.Assert.assertTrue((boolean)report.countainsErrorCode("E_invalidKeyPassed"));
            }
            catch (Exception e1) {
                Assert.fail((String)("We only expect DispositionReportFaultMessage, not " + e1.getClass()));
                this.logger.error((Object)e.getMessage(), (Throwable)e1);
            }
        }
    }

    public void findAllBusiness() {
        try {
            List biList;
            BusinessInfos bInfos;
            FindBusiness body = (FindBusiness)EntityCreator.buildFromDoc((String)FIND_ALL_BUSINESSES_XML, (String)"org.uddi.api_v3");
            BusinessList result = this.inquiry.findBusiness(body);
            if (result == null) {
                Assert.fail((String)"Null result from find business operation");
            }
            if ((bInfos = result.getBusinessInfos()) == null) {
                Assert.fail((String)"No result from find business operation");
            }
            if ((biList = bInfos.getBusinessInfo()) == null || biList.size() == 0) {
                Assert.fail((String)"No result from find business operation");
            }
            Assert.assertTrue((biList.size() > 1 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }

    public List<BusinessInfo> findAllSignedBusiness() {
        List biList = null;
        try {
            BusinessInfos bInfos;
            FindBusiness body = (FindBusiness)EntityCreator.buildFromDoc((String)FIND_ALL_SIGNED_BUSINESSES_XML, (String)"org.uddi.api_v3");
            BusinessList result = this.inquiry.findBusiness(body);
            if (result == null) {
                Assert.fail((String)"Null result from find business operation");
            }
            if ((bInfos = result.getBusinessInfos()) == null) {
                Assert.fail((String)"No result from find business operation");
            }
            if ((biList = bInfos.getBusinessInfo()) == null || biList.size() == 0) {
                Assert.fail((String)"No result from find business operation");
            }
            Assert.assertTrue((biList.size() == 1 ? 1 : 0) != 0);
            return biList;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
            return biList;
        }
    }

    public void findRelatedBusiness_sortByName(boolean isOneSided) {
        try {
            FindRelatedBusinesses body = (FindRelatedBusinesses)EntityCreator.buildFromDoc((String)FIND_RELATED_BUSINESS_SORT_BY_NAME_XML, (String)"org.uddi.api_v3");
            RelatedBusinessesList result = this.inquiry.findRelatedBusinesses(body);
            if (result == null) {
                Assert.fail((String)"Null result from find related business operation");
            }
            RelatedBusinessInfos bInfos = result.getRelatedBusinessInfos();
            if (isOneSided) {
                Assert.assertNull((Object)bInfos);
            } else {
                List biList;
                if (bInfos == null) {
                    Assert.fail((String)"No result from find related business operation");
                }
                if ((biList = bInfos.getRelatedBusinessInfo()) == null || biList.size() == 0) {
                    Assert.fail((String)"No result from find related business operation");
                }
                HashSet<String> keys = new HashSet<String>();
                for (RelatedBusinessInfo relatedBusinessInfo : biList) {
                    keys.add(relatedBusinessInfo.getBusinessKey());
                }
                Assert.assertTrue((boolean)keys.contains("uddi:www.samco.com:samco"));
                Assert.assertTrue((boolean)keys.contains("uddi:uddi.marypublisher.com:marybusinessone"));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }

    public void findRelatedBusinessToKey(boolean isOneSided) {
        try {
            FindRelatedBusinesses body = (FindRelatedBusinesses)EntityCreator.buildFromDoc((String)FIND_RELATED_BUSINESS_TO_KEY, (String)"org.uddi.api_v3");
            RelatedBusinessesList result = this.inquiry.findRelatedBusinesses(body);
            if (result == null) {
                Assert.fail((String)"Null result from find related business operation");
            }
            RelatedBusinessInfos bInfos = result.getRelatedBusinessInfos();
            if (isOneSided) {
                Assert.assertNull((Object)bInfos);
            } else {
                List biList;
                if (bInfos == null) {
                    Assert.fail((String)"No result from find related business operation");
                }
                if ((biList = bInfos.getRelatedBusinessInfo()) == null || biList.size() == 0) {
                    Assert.fail((String)"No result from find related business operation");
                }
                HashSet<String> keys = new HashSet<String>();
                for (RelatedBusinessInfo relatedBusinessInfo : biList) {
                    keys.add(relatedBusinessInfo.getBusinessKey());
                }
                Assert.assertTrue((boolean)keys.contains("uddi:uddi.joepublisher.com:businessone"));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }

    public void findRelatedBusinessFromKey(boolean isOneSided) {
        try {
            FindRelatedBusinesses body = (FindRelatedBusinesses)EntityCreator.buildFromDoc((String)FIND_RELATED_BUSINESS_FROM_KEY, (String)"org.uddi.api_v3");
            RelatedBusinessesList result = this.inquiry.findRelatedBusinesses(body);
            if (result == null) {
                Assert.fail((String)"Null result from find related business operation");
            }
            RelatedBusinessInfos bInfos = result.getRelatedBusinessInfos();
            if (isOneSided) {
                Assert.assertNull((Object)bInfos);
            } else {
                List biList;
                if (bInfos == null) {
                    Assert.fail((String)"No result from find related business operation");
                }
                if ((biList = bInfos.getRelatedBusinessInfo()) == null || biList.size() == 0) {
                    Assert.fail((String)"No result from find related business operation");
                }
                HashSet<String> keys = new HashSet<String>();
                for (RelatedBusinessInfo relatedBusinessInfo : biList) {
                    keys.add(relatedBusinessInfo.getBusinessKey());
                }
                Assert.assertTrue((boolean)keys.contains("uddi:www.samco.com:samco"));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }

    public String findService(String findQualifier) {
        String serviceKey = null;
        try {
            List siList;
            ServiceInfos sInfos;
            ServiceList result;
            FindService body = (FindService)EntityCreator.buildFromDoc((String)FIND_SERVICE_XML, (String)"org.uddi.api_v3");
            if (findQualifier != null) {
                body.getFindQualifiers().getFindQualifier().add(findQualifier);
            }
            if ((result = this.inquiry.findService(body)) == null) {
                Assert.fail((String)"Null result from find service operation");
            }
            if ((sInfos = result.getServiceInfos()) == null) {
                Assert.fail((String)"No result from find service operation");
            }
            if ((siList = sInfos.getServiceInfo()) == null || siList.size() == 0) {
                Assert.fail((String)"No result from find service operation");
            }
            ServiceInfo siOut = (ServiceInfo)siList.get(0);
            BusinessService bsIn = (BusinessService)EntityCreator.buildFromDoc((String)"uddi_data/joepublisher/businessService.xml", (String)"org.uddi.api_v3");
            junit.framework.Assert.assertEquals((String)bsIn.getServiceKey(), (String)siOut.getServiceKey());
            TckValidator.checkNames(bsIn.getName(), siOut.getName());
            serviceKey = siOut.getServiceKey();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
        return serviceKey;
    }

    public String findService_CombinedCatBag() {
        String serviceKey = null;
        try {
            List siList;
            ServiceInfos sInfos;
            FindService body = (FindService)EntityCreator.buildFromDoc((String)COMBINE_CAT_FIND_SERVICES, (String)"org.uddi.api_v3");
            ServiceList result = this.inquiry.findService(body);
            if (result == null) {
                Assert.fail((String)"Null result from find service operation");
            }
            if ((sInfos = result.getServiceInfos()) == null) {
                Assert.fail((String)"No result from find service operation");
            }
            if ((siList = sInfos.getServiceInfo()) == null || siList.size() == 0) {
                Assert.fail((String)"No result from find service operation");
            }
            ServiceInfo siOut = (ServiceInfo)siList.get(0);
            serviceKey = siOut.getServiceKey();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
        return serviceKey;
    }

    public void findServiceDetail(String serviceKey) {
        try {
            BindingTemplates templates;
            GetServiceDetail getServiceDetail = new GetServiceDetail();
            getServiceDetail.getServiceKey().add(serviceKey);
            ServiceDetail result = this.inquiry.getServiceDetail(getServiceDetail);
            if (result == null) {
                Assert.fail((String)"Null result from find service operation");
            }
            if ((templates = ((BusinessService)result.getBusinessService().get(0)).getBindingTemplates()) != null && templates.getBindingTemplate() != null) {
                System.out.println(templates.getBindingTemplate().size());
                System.out.println("key=" + ((BindingTemplate)templates.getBindingTemplate().get(0)).getBindingKey());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }

    public void findBinding(String findQualifier) {
        try {
            List btList;
            BindingDetail result;
            FindBinding body = (FindBinding)EntityCreator.buildFromDoc((String)FIND_BINDING_XML, (String)"org.uddi.api_v3");
            if (findQualifier != null) {
                body.getFindQualifiers().getFindQualifier().add(findQualifier);
            }
            if ((result = this.inquiry.findBinding(body)) == null) {
                Assert.fail((String)"Null result from find binding operation");
            }
            if ((btList = result.getBindingTemplate()) == null || btList.size() == 0) {
                Assert.fail((String)"No result from find binding operation");
            }
            BindingTemplate btOut = (BindingTemplate)btList.get(0);
            BindingTemplate btIn = (BindingTemplate)EntityCreator.buildFromDoc((String)"uddi_data/joepublisher/bindingTemplate.xml", (String)"org.uddi.api_v3");
            junit.framework.Assert.assertEquals((String)btIn.getServiceKey(), (String)btOut.getServiceKey());
            junit.framework.Assert.assertEquals((String)btIn.getBindingKey(), (String)btOut.getBindingKey());
            TckValidator.checkDescriptions(btIn.getDescription(), btOut.getDescription());
            TckValidator.checkCategories(btIn.getCategoryBag(), btOut.getCategoryBag());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)("No exception should be thrown:  " + e.getMessage()));
        }
    }

    public void findTModel(String findQualifier) {
        try {
            List tiList;
            TModelInfos tInfos;
            TModelList result;
            FindTModel body = (FindTModel)EntityCreator.buildFromDoc((String)FIND_TMODEL_XML, (String)"org.uddi.api_v3");
            if (findQualifier != null) {
                body.getFindQualifiers().getFindQualifier().add(findQualifier);
            }
            if ((result = this.inquiry.findTModel(body)) == null) {
                Assert.fail((String)"Null result from find tModel operation");
            }
            if ((tInfos = result.getTModelInfos()) == null) {
                Assert.fail((String)"No result from find tModel operation");
            }
            if ((tiList = tInfos.getTModelInfo()) == null || tiList.size() == 0) {
                Assert.fail((String)"No result from find tModel operation");
            }
            TModelInfo tiOut = (TModelInfo)tiList.get(0);
            TModel tmIn = (TModel)EntityCreator.buildFromDoc((String)"uddi_data/joepublisher/tModelKeyGen.xml", (String)"org.uddi.api_v3");
            junit.framework.Assert.assertEquals((String)tmIn.getTModelKey(), (String)tiOut.getTModelKey());
            junit.framework.Assert.assertEquals((String)tmIn.getName().getLang(), (String)tiOut.getName().getLang());
            junit.framework.Assert.assertEquals((String)tmIn.getName().getValue(), (String)tiOut.getName().getValue());
            TckValidator.checkDescriptions(tmIn.getDescription(), tiOut.getDescription());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Assert.fail((String)"No exception should be thrown.");
        }
    }
}

