/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.transport.wrapper;

import java.rmi.Remote;
import java.util.HashMap;
import org.apache.juddi.v3.client.ClassUtil;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.config.UDDIClientContainer;
import org.apache.juddi.v3.client.transport.Transport;
import org.apache.juddi.v3.client.transport.wrapper.Handler;
import org.apache.juddi.v3.client.transport.wrapper.RequestHandler;
import org.uddi.api_v3.DiscardAuthToken;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.v3_service.UDDISecurityPortType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UDDISecurityService {
    private static final String DEFAULT_NODE_NAME = "default";
    private String clientName = System.getProperty("org.apache.juddi.v3.client.name");
    private String nodeName = System.getProperty("org.apache.juddi.v3.client.node.name", "default");
    private HashMap<String, Handler> operations = new HashMap();

    public UDDISecurityService() {
        this.operations.put("get_authToken", new Handler("getAuthToken", GetAuthToken.class));
        this.operations.put("discard_authToken", new Handler("discardAuthToken", DiscardAuthToken.class));
    }

    public void validateRequest(String operation) throws UnsupportedOperationException {
        if (operation == null || operation.trim().length() == 0) {
            throw new UnsupportedOperationException("operation " + operation + " not supported");
        }
    }

    public Node secure(Element uddiReq) throws Exception {
        return this.secure(uddiReq, this.nodeName, this.clientName);
    }

    public Node secure(Element uddiReq, String nodeName, String clientName) throws Exception {
        UDDIClient client = UDDIClientContainer.getUDDIClient(clientName);
        String clazz = client.getClientConfig().getUDDINode(nodeName).getProxyTransport();
        Class<?> transportClass = ClassUtil.forName(clazz, this.getClass());
        Transport transport = (Transport)transportClass.getConstructor(String.class, String.class).newInstance(clientName, nodeName);
        UDDISecurityPortType security = transport.getUDDISecurityService();
        RequestHandler requestHandler = new RequestHandler();
        requestHandler.setPortType((Remote)security);
        String operation = requestHandler.getOperation(uddiReq);
        Handler opHandler = this.operations.get(operation);
        if (opHandler == null) {
            throw new IllegalArgumentException("Operation not found: " + operation);
        }
        requestHandler.setMethodName(opHandler.getMethodName());
        requestHandler.setOperationClass(opHandler.getParameter());
        String version = requestHandler.getVersion(uddiReq, operation);
        this.validateRequest(operation);
        return requestHandler.invoke(uddiReq);
    }
}

