/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.juddi.v3.client.config.TokenResolver;

public class UDDIKeyConvention {
    public static final String DEFAULT_BUSINESS_KEY_FORMAT = "uddi:${keyDomain}:business_${businessName}";
    public static final String DEFAULT_SERVICE_KEY_FORMAT = "uddi:${keyDomain}:service_${serviceName}";
    public static final String DEFAULT_SUBSCRIPTION_KEY_FORMAT = "uddi:${keyDomain}:service_cache_${serverName}";
    public static final String DEFAULT_BINDING_KEY_FORMAT = "uddi:${keyDomain}:binding_${serverName}_${serviceName}_${portName}_${serverPort}";

    public static String getBusinessKey(Properties properties) {
        String businessKey = properties.getProperty("businessKey");
        if (businessKey == null) {
            String keyFormat = properties.getProperty("businessKeyFormat", DEFAULT_BUSINESS_KEY_FORMAT);
            businessKey = TokenResolver.replaceTokens(keyFormat, properties).toLowerCase();
        }
        return businessKey;
    }

    public static String getSubscriptionKey(Properties properties) {
        String keyFormat = properties.getProperty("subscriptionKeyFormat", DEFAULT_SUBSCRIPTION_KEY_FORMAT);
        String subscriptionKey = TokenResolver.replaceTokens(keyFormat, properties).toLowerCase();
        return subscriptionKey;
    }

    public static String getServiceKey(Properties properties, String serviceName) {
        Properties tempProperties = new Properties();
        if (properties != null) {
            tempProperties.putAll((Map<?, ?>)properties);
        }
        tempProperties.put("serviceName", serviceName);
        String keyFormat = tempProperties.getProperty("bpelServiceKeyFormat", DEFAULT_SERVICE_KEY_FORMAT);
        String serviceKey = TokenResolver.replaceTokens(keyFormat, tempProperties).toLowerCase();
        return serviceKey;
    }

    public static String getBindingKey(Properties properties, QName serviceName, String portName, URL bindingUrl) {
        String bindingKey = null;
        try {
            URI bindingURI = bindingUrl.toURI();
            bindingKey = UDDIKeyConvention.getBindingKey(properties, serviceName, portName, bindingURI);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return bindingKey;
    }

    public static String getBindingKey(Properties properties, QName serviceName, String portName, URI bindingUrl) {
        Properties tempProperties = new Properties();
        if (properties != null) {
            tempProperties.putAll((Map<?, ?>)properties);
        }
        tempProperties.put("serviceName", serviceName.getLocalPart());
        tempProperties.put("portName", portName);
        int port = bindingUrl.getPort();
        if (port == -1) {
            if ("http".equals(bindingUrl.getScheme())) {
                port = 80;
            } else if ("https".equals(bindingUrl.getScheme())) {
                port = 443;
            }
        }
        tempProperties.put("serverPort", String.valueOf(port));
        String keyFormat = tempProperties.getProperty("bindingKeyFormat", DEFAULT_BINDING_KEY_FORMAT);
        String bindingKey = TokenResolver.replaceTokens(keyFormat, tempProperties).toLowerCase();
        return bindingKey;
    }
}

