/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.Node;
import org.apache.juddi.v3.client.config.TokenResolver;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.config.UDDIKeyConvention;
import org.apache.juddi.v3.client.config.UDDINode;
import org.apache.juddi.v3.client.config.XRegistration;
import org.apache.juddi.v3.client.cryptor.CryptorFactory;

public class ClientConfig {
    public static final String UDDI_CONFIG_FILENAME_PROPERTY = "uddi.client.xml";
    public static final String DEFAULT_UDDI_CONFIG = "META-INF/uddi.xml";
    private Log log = LogFactory.getLog(ClientConfig.class);
    private Configuration config = null;
    private Map<String, UDDINode> uddiNodes = null;
    private Map<String, UDDIClerk> uddiClerks = null;
    private Set<XRegistration> xBusinessRegistrations = null;
    private Set<XRegistration> xServiceBindingRegistrations = null;
    private String clientName = null;
    private String clientCallbackUrl = null;
    private String configurationFile = null;

    public ClientConfig(String configurationFile) throws ConfigurationException {
        this.loadConfiguration(configurationFile, null);
    }

    public ClientConfig(String configurationFile, Properties properties) throws ConfigurationException {
        this.loadConfiguration(configurationFile, properties);
    }

    public void saveConfig() throws ConfigurationException {
        if (this.log.isDebugEnabled()) {
            System.out.println("DEBUG dumping current cfg");
            Iterator keys = this.config.getKeys();
            while (keys.hasNext()) {
                String k = (String)keys.next();
                System.out.println(k + " = " + this.config.getProperty(k));
            }
        }
        XMLConfiguration saveConfiguration = new XMLConfiguration();
        CompositeConfiguration cc = new CompositeConfiguration((Configuration)saveConfiguration);
        saveConfiguration.setRootElementName("uddi");
        cc.addProperty("client(0).selection.policy", this.config.getProperty("client.selection.policy"));
        cc.addProperty("reloadDelay", this.config.getProperty("reloadDelay"));
        this.addCurrentNodeConfig((Configuration)cc);
        this.addCurrentClerks((Configuration)cc);
        try {
            this.addDigitalSubscription((Configuration)cc);
        }
        catch (Exception ex) {
            throw new ConfigurationException("error", (Throwable)ex);
        }
        this.addSubscriptionCallback((Configuration)cc);
        this.addXRegistration((Configuration)cc);
        if (this.log.isDebugEnabled()) {
            System.out.println("DEBUG dumping NEW cfg");
            Iterator keys = cc.getKeys();
            while (keys.hasNext()) {
                String k = (String)keys.next();
                System.out.println(k + " = " + this.config.getProperty(k));
            }
        }
        saveConfiguration.save(this.configurationFile);
    }

    public void saveConfigRaw() throws ConfigurationException {
        XMLConfiguration saveConfiguration = new XMLConfiguration(this.configurationFile);
        CompositeConfiguration cc = new CompositeConfiguration((Configuration)saveConfiguration);
        Iterator keys = this.config.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!key.startsWith("client") && !key.startsWith("config")) continue;
            cc.setProperty(key, this.config.getProperty(key));
        }
        saveConfiguration.save();
    }

    protected void readConfig(Properties properties) throws ConfigurationException {
        this.uddiNodes = this.readNodeConfig(this.config, properties);
        this.uddiClerks = this.readClerkConfig(this.config, this.uddiNodes);
        this.xServiceBindingRegistrations = this.readXServiceBindingRegConfig(this.config, this.uddiClerks);
        this.xBusinessRegistrations = this.readXBusinessRegConfig(this.config, this.uddiClerks);
    }

    private void loadConfiguration(String configurationFile, Properties properties) throws ConfigurationException {
        String filename;
        CompositeConfiguration compositeConfig = new CompositeConfiguration();
        compositeConfig.addConfiguration((Configuration)new SystemConfiguration());
        if (System.getProperty(UDDI_CONFIG_FILENAME_PROPERTY) != null) {
            this.log.info((Object)"Using system property config override");
            configurationFile = System.getProperty(UDDI_CONFIG_FILENAME_PROPERTY);
        }
        XMLConfiguration xmlConfig = null;
        xmlConfig = configurationFile != null ? new XMLConfiguration(configurationFile) : ((filename = System.getProperty(UDDI_CONFIG_FILENAME_PROPERTY)) != null ? new XMLConfiguration(filename) : new XMLConfiguration(DEFAULT_UDDI_CONFIG));
        this.log.info((Object)("Reading UDDI Client properties file " + xmlConfig.getBasePath() + " use -D" + UDDI_CONFIG_FILENAME_PROPERTY + " to override"));
        this.configurationFile = xmlConfig.getBasePath();
        long refreshDelay = xmlConfig.getLong("reloadDelay", 1000L);
        this.log.debug((Object)("Setting refreshDelay to " + refreshDelay));
        FileChangedReloadingStrategy fileChangedReloadingStrategy = new FileChangedReloadingStrategy();
        fileChangedReloadingStrategy.setRefreshDelay(refreshDelay);
        xmlConfig.setReloadingStrategy((ReloadingStrategy)fileChangedReloadingStrategy);
        compositeConfig.addConfiguration((Configuration)xmlConfig);
        this.config = compositeConfig;
        this.readConfig(properties);
        this.validateConfig();
    }

    private Map<String, UDDIClerk> readClerkConfig(Configuration config, Map<String, UDDINode> uddiNodes) throws ConfigurationException {
        this.clientName = config.getString("client[@name]");
        this.clientCallbackUrl = config.getString("client[@callbackUrl]");
        HashMap<String, UDDIClerk> clerks = new HashMap<String, UDDIClerk>();
        if (config.containsKey("client.clerks.clerk[@name]")) {
            String[] names = config.getStringArray("client.clerks.clerk[@name]");
            this.log.debug((Object)("clerk names=" + names.length));
            for (int i = 0; i < names.length; ++i) {
                UDDIClerk uddiClerk = new UDDIClerk();
                uddiClerk.setManagerName(this.clientName);
                uddiClerk.setName(config.getString("client.clerks.clerk(" + i + ")[@name]"));
                String nodeRef = config.getString("client.clerks.clerk(" + i + ")[@node]");
                if (!uddiNodes.containsKey(nodeRef)) {
                    throw new ConfigurationException("Could not find Node with name=" + nodeRef);
                }
                UDDINode uddiNode = uddiNodes.get(nodeRef);
                uddiClerk.setUDDINode(uddiNode);
                uddiClerk.setPublisher(config.getString("client.clerks.clerk(" + i + ")[@publisher]"));
                uddiClerk.setPassword(config.getString("client.clerks.clerk(" + i + ")[@password]"));
                uddiClerk.setIsPasswordEncrypted(config.getBoolean("client.clerks.clerk(" + i + ")[@isPasswordEncrypted]", false));
                uddiClerk.setCryptoProvider(config.getString("client.clerks.clerk(" + i + ")[@cryptoProvider]"));
                String clerkBusinessKey = config.getString("client.clerks.clerk(" + i + ")[@businessKey]");
                String clerkBusinessName = config.getString("client.clerks.clerk(" + i + ")[@businessName]");
                String clerkKeyDomain = config.getString("client.clerks.clerk(" + i + ")[@keyDomain]");
                String[] classes = config.getStringArray("client.clerks.clerk(" + i + ").class");
                uddiClerk.setClassWithAnnotations(classes);
                int numberOfWslds = config.getStringArray("client.clerks.clerk(" + i + ").wsdl").length;
                if (numberOfWslds > 0) {
                    UDDIClerk.WSDL[] wsdls = new UDDIClerk.WSDL[numberOfWslds];
                    for (int w = 0; w < wsdls.length; ++w) {
                        UDDIClerk.WSDL wsdl = new UDDIClerk.WSDL();
                        String fileName = config.getString("client.clerks.clerk(" + i + ").wsdl(" + w + ")");
                        wsdl.setFileName(fileName);
                        if (!new File(fileName).exists()) {
                            this.log.warn((Object)("The wsdl file referenced in the config at '" + fileName + "' doesn't exist!"));
                        }
                        String businessKey = config.getString("client.clerks.clerk(" + i + ").wsdl(" + w + ")[@businessKey]");
                        String businessName = config.getString("client.clerks.clerk(" + i + ").wsdl(" + w + ")[@businessName]");
                        String keyDomain = config.getString("client.clerks.clerk(" + i + ").wsdl(" + w + ")[@keyDomain]");
                        if (businessKey == null) {
                            businessKey = clerkBusinessKey;
                        }
                        if (businessKey == null) {
                            businessKey = uddiClerk.getUDDINode().getProperties().getProperty("businessKey");
                        }
                        if (businessKey == null) {
                            if (businessName == null) {
                                businessName = clerkBusinessName;
                            }
                            if (keyDomain == null) {
                                keyDomain = clerkKeyDomain;
                            }
                            if (keyDomain == null) {
                                keyDomain = uddiClerk.getUDDINode().getProperties().getProperty("keyDomain");
                            }
                            if (businessName == null && !uddiClerk.getUDDINode().getProperties().containsKey("businessName") || keyDomain == null && !uddiClerk.getUDDINode().getProperties().containsKey("keyDomain")) {
                                throw new ConfigurationException("Either the wsdl(" + wsdls[w] + ") or clerk (" + uddiClerk.name + ") elements require a businessKey, or businessName & keyDomain attributes");
                            }
                            Properties properties = new Properties(uddiClerk.getUDDINode().getProperties());
                            if (businessName != null) {
                                properties.put("businessName", businessName);
                            }
                            if (keyDomain != null) {
                                properties.put("keyDomain", keyDomain);
                            }
                            businessKey = UDDIKeyConvention.getBusinessKey(properties);
                        }
                        if (!businessKey.toLowerCase().startsWith("uddi:") || !businessKey.substring(5).contains(":")) {
                            throw new ConfigurationException("The businessKey '" + businessKey + "' does not implement a valid UDDI v3 key format. See config file at client.clerks.clerk(" + i + ").wsdl(" + w + ")[@businessKey]");
                        }
                        wsdl.setBusinessKey(businessKey);
                        if (keyDomain == null) {
                            keyDomain = businessKey.split(":")[1];
                        }
                        wsdl.setKeyDomain(keyDomain);
                        wsdls[w] = wsdl;
                    }
                    uddiClerk.setWsdls(wsdls);
                }
                clerks.put(names[i], uddiClerk);
            }
        }
        return clerks;
    }

    public boolean isRegisterOnStartup() {
        boolean isRegisterOnStartup = false;
        if (this.config.containsKey("client.clerks[@registerOnStartup]")) {
            isRegisterOnStartup = this.config.getBoolean("client.clerks[@registerOnStartup]");
        }
        return isRegisterOnStartup;
    }

    private Map<String, UDDINode> readNodeConfig(Configuration config, Properties properties) throws ConfigurationException {
        String[] names = config.getStringArray("client.nodes.node.name");
        HashMap<String, UDDINode> nodes = new HashMap<String, UDDINode>();
        this.log.debug((Object)("node names=" + names.length));
        for (int i = 0; i < names.length; ++i) {
            UDDINode uddiNode = new UDDINode();
            String nodeName = config.getString("client.nodes.node(" + i + ").name");
            String[] propertyKeys = config.getStringArray("client.nodes.node(" + i + ").properties.property[@name]");
            if (propertyKeys != null && propertyKeys.length > 0) {
                if (properties == null) {
                    properties = new Properties();
                }
                for (int p = 0; p < propertyKeys.length; ++p) {
                    String name = config.getString("client.nodes.node(" + i + ").properties.property(" + p + ")[@name]");
                    String value = config.getString("client.nodes.node(" + i + ").properties.property(" + p + ")[@value]");
                    this.log.debug((Object)("Property: name=" + name + " value=" + value));
                    properties.put(name, value);
                }
                uddiNode.setProperties(properties);
            }
            uddiNode.setHomeJUDDI(config.getBoolean("client.nodes.node(" + i + ")[@isHomeJUDDI]", false));
            uddiNode.setName(TokenResolver.replaceTokens(config.getString("client.nodes.node(" + i + ").name"), properties));
            uddiNode.setClientName(TokenResolver.replaceTokens(config.getString("client[@name]"), properties));
            uddiNode.setDescription(TokenResolver.replaceTokens(config.getString("client.nodes.node(" + i + ").description"), properties));
            uddiNode.setProxyTransport(TokenResolver.replaceTokens(config.getString("client.nodes.node(" + i + ").proxyTransport"), properties));
            uddiNode.setInquiryUrl(TokenResolver.replaceTokens(config.getString("client.nodes.node(" + i + ").inquiryUrl"), properties));
            uddiNode.setInquiryRESTUrl(TokenResolver.replaceTokens(config.getString("client.nodes.node(" + i + ").inquiryRESTUrl"), properties));
            uddiNode.setPublishUrl(TokenResolver.replaceTokens(config.getString("client.nodes.node(" + i + ").publishUrl"), properties));
            uddiNode.setCustodyTransferUrl(TokenResolver.replaceTokens(config.getString("client.nodes.node(" + i + ").custodyTransferUrl"), properties));
            uddiNode.setSecurityUrl(TokenResolver.replaceTokens(config.getString("client.nodes.node(" + i + ").securityUrl"), properties));
            uddiNode.setReplicationUrl(TokenResolver.replaceTokens(config.getString("client.nodes.node(" + i + ").replicationUrl"), properties));
            uddiNode.setSubscriptionUrl(TokenResolver.replaceTokens(config.getString("client.nodes.node(" + i + ").subscriptionUrl"), properties));
            uddiNode.setSubscriptionListenerUrl(TokenResolver.replaceTokens(config.getString("client.nodes.node(" + i + ").subscriptionListenerUrl"), properties));
            uddiNode.setJuddiApiUrl(TokenResolver.replaceTokens(config.getString("client.nodes.node(" + i + ").juddiApiUrl"), properties));
            uddiNode.setFactoryInitial(TokenResolver.replaceTokens(config.getString("client.nodes.node(" + i + ").javaNamingFactoryInitial"), properties));
            uddiNode.setFactoryURLPkgs(TokenResolver.replaceTokens(config.getString("client.nodes.node(" + i + ").javaNamingFactoryUrlPkgs"), properties));
            uddiNode.setFactoryNamingProvider(TokenResolver.replaceTokens(config.getString("client.nodes.node(" + i + ").javaNamingProviderUrl"), properties));
            nodes.put(nodeName, uddiNode);
        }
        return nodes;
    }

    private Set<XRegistration> readXBusinessRegConfig(Configuration config, Map<String, UDDIClerk> clerks) throws ConfigurationException {
        return this.readXRegConfig(config, clerks, "business");
    }

    private Set<XRegistration> readXServiceBindingRegConfig(Configuration config, Map<String, UDDIClerk> clerks) throws ConfigurationException {
        return this.readXRegConfig(config, clerks, "servicebinding");
    }

    private Set<XRegistration> readXRegConfig(Configuration config, Map<String, UDDIClerk> clerks, String entityType) throws ConfigurationException {
        String[] entityKeys = config.getStringArray("client.clerks.xregister." + entityType + "[@entityKey]");
        HashSet<XRegistration> xRegistrations = new HashSet<XRegistration>();
        if (entityKeys.length > 0) {
            this.log.info((Object)("XRegistration " + entityKeys.length + " " + entityType + "Keys"));
        }
        for (int i = 0; i < entityKeys.length; ++i) {
            XRegistration xRegistration = new XRegistration();
            xRegistration.setEntityKey(config.getString("client.clerks.xregister." + entityType + "(" + i + ")[@entityKey]"));
            String fromClerkRef = config.getString("client.clerks.xregister." + entityType + "(" + i + ")[@fromClerk]");
            if (!clerks.containsKey(fromClerkRef)) {
                throw new ConfigurationException("Could not find fromClerk with name=" + fromClerkRef);
            }
            UDDIClerk fromClerk = clerks.get(fromClerkRef);
            xRegistration.setFromClerk(fromClerk);
            String toClerkRef = config.getString("client.clerks.xregister." + entityType + "(" + i + ")[@toClerk]");
            if (!clerks.containsKey(toClerkRef)) {
                throw new ConfigurationException("Could not find toClerk with name=" + toClerkRef);
            }
            UDDIClerk toClerk = clerks.get(toClerkRef);
            xRegistration.setToClerk(toClerk);
            this.log.debug((Object)xRegistration);
            xRegistrations.add(xRegistration);
        }
        return xRegistrations;
    }

    protected Map<String, UDDINode> getUDDINodes() {
        return this.uddiNodes;
    }

    public List<Node> getUDDINodeList() {
        ArrayList<Node> ret = new ArrayList<Node>();
        for (UDDINode next : this.uddiNodes.values()) {
            Node n = new Node();
            n.setClientName(next.getClientName());
            n.setDescription(next.getDescription());
            n.setName(next.getName());
            n.setProxyTransport(next.getProxyTransport());
            n.setCustodyTransferUrl(next.getCustodyTransferUrl());
            n.setFactoryInitial(next.getFactoryInitial());
            n.setFactoryNamingProvider(next.getFactoryNamingProvider());
            n.setFactoryURLPkgs(next.getFactoryURLPkgs());
            n.setInquiryUrl(next.getInquiryUrl());
            n.setJuddiApiUrl(next.getJuddiApiUrl());
            n.setPublishUrl(next.getPublishUrl());
            n.setReplicationUrl(next.getReplicationUrl());
            n.setSecurityUrl(next.getSecurityUrl());
            n.setSubscriptionListenerUrl(next.getSubscriptionListenerUrl());
            n.setSubscriptionUrl(next.getSubscriptionUrl());
            ret.add(n);
        }
        return ret;
    }

    public UDDINode getHomeNode() throws ConfigurationException {
        if (this.uddiNodes == null) {
            throw new ConfigurationException("The juddi client configuration must contain at least one node element.");
        }
        if (this.uddiNodes.values().size() == 1) {
            return this.uddiNodes.values().iterator().next();
        }
        UDDINode ret = null;
        for (UDDINode uddiNode : this.uddiNodes.values()) {
            if (!uddiNode.isHomeJUDDI()) continue;
            if (ret != null) {
                throw new ConfigurationException("Only one of the node elements in the client configuration needs to a 'isHomeJUDDI=\"true\"' attribute.");
            }
            ret = uddiNode;
        }
        if (ret != null) {
            return ret;
        }
        throw new ConfigurationException("One of the node elements in the client configuration needs to a 'isHomeJUDDI=\"true\"' attribute.");
    }

    public UDDINode getUDDINode(String nodeName) throws ConfigurationException {
        if (!this.uddiNodes.containsKey(nodeName)) {
            throw new ConfigurationException("Node '" + nodeName + "' cannot be found in the config '" + this.getClientName() + "'");
        }
        return this.uddiNodes.get(nodeName);
    }

    public Map<String, UDDIClerk> getUDDIClerks() {
        return this.uddiClerks;
    }

    public Set<XRegistration> getXServiceBindingRegistrations() {
        return this.xServiceBindingRegistrations;
    }

    public Set<XRegistration> getXBusinessRegistrations() {
        return this.xBusinessRegistrations;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public String getClientName() {
        return this.clientName;
    }

    @Deprecated
    public String getClientCallbackUrl() {
        return this.clientCallbackUrl;
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }

    public boolean isX_To_Wsdl_Ignore_SSL_Errors() {
        return this.config.getBoolean("client.XtoWsdl.IgnoreSSLErrors", false);
    }

    public Properties getDigitalSignatureConfiguration() throws Exception {
        String prov;
        String enc;
        Properties p = new Properties();
        p.setProperty("CanonicalizationMethod", this.config.getString("client.signature.canonicalizationMethod", "http://www.w3.org/2001/10/xml-exc-c14n#"));
        p.setProperty("checkTimestamps", Boolean.valueOf(this.config.getBoolean("client.signature.checkTimestamps", true)).toString());
        p.setProperty("checkRevocationCRL", Boolean.valueOf(this.config.getBoolean("client.signature.checkRevocationCRL", true)).toString());
        p.setProperty("checkRevocationOCSP", Boolean.valueOf(this.config.getBoolean("client.signature.checkRevocationOCSP", true)).toString());
        p.setProperty("checkTrust", Boolean.valueOf(this.config.getBoolean("client.signature.checkTrust", true)).toString());
        p.setProperty("keyStorePath", this.config.getString("client.signature.signingKeyStorePath", ""));
        p.setProperty("keyStoreType", this.config.getString("client.signature.signingKeyStoreType", ""));
        if (this.config.getBoolean("client.signature.signingKeyPassword[@isPasswordEncrypted]", false)) {
            enc = this.config.getString("client.signature.signingKeyPassword", "");
            prov = this.config.getString("client.signature.signingKeyPassword[@cryptoProvider]", "");
            p.setProperty("keyPassword", CryptorFactory.getCryptor(prov).decrypt(enc));
            p.setProperty("signatureKeystoreKeyPassENC", "true");
            p.setProperty("signatureKeystoreKeyPassENCProvider", prov);
            p.setProperty("signatureKeyStoreCipherPass", enc);
        } else {
            this.log.warn((Object)"Hey, you should consider encrypting your key password!");
            p.setProperty("keyPassword", this.config.getString("client.signature.signingKeyPassword", ""));
            p.setProperty("signatureKeystoreKeyPassENC", "false");
        }
        if (this.config.getBoolean("client.signature.signingKeyStoreFilePassword[@isPasswordEncrypted]", false)) {
            enc = this.config.getString("client.signature.signingKeyStoreFilePassword", "");
            prov = this.config.getString("client.signature.signingKeyStoreFilePassword[@cryptoProvider]", "");
            p.setProperty("filePassword", CryptorFactory.getCryptor(prov).decrypt(enc));
            p.setProperty("signatureKeystoreFileENCProvider", prov);
            p.setProperty("signatureKeystoreFileKeyPass", enc);
        } else {
            this.log.warn((Object)"Hey, you should consider encrypting your keystore password!");
            p.setProperty("filePassword", this.config.getString("client.signature.signingKeyStoreFilePassword", ""));
        }
        p.setProperty("keyAlias", this.config.getString("client.signature.signingKeyAlias", ""));
        p.setProperty("SignatureMethod", this.config.getString("client.signature.signatureMethod", "http://www.w3.org/2000/09/xmldsig#rsa-sha1"));
        p.setProperty("SUBJECTDN", this.config.getString("client.signature.keyInfoInclusionSubjectDN", "true"));
        p.setProperty("BASE64", this.config.getString("client.signature.keyInfoInclusionBase64PublicKey", "true"));
        p.setProperty("SERIAL", this.config.getString("client.signature.keyInfoInclusionSerial", "true"));
        p.setProperty("digestMethod", this.config.getString("client.signature.digestMethod", "http://www.w3.org/2000/09/xmldsig#sha1"));
        p.setProperty("trustStorePath", this.config.getString("client.signature.trustStorePath", ""));
        p.setProperty("trustStoreType", this.config.getString("client.signature.trustStoreType", ""));
        if (this.config.getBoolean("client.signature.trustStorePassword[@isPasswordEncrypted]", false)) {
            enc = this.config.getString("client.signature.trustStorePassword", "");
            prov = this.config.getString("client.signature.trustStorePassword[@cryptoProvider]", "");
            p.setProperty("trustStorePassword", CryptorFactory.getCryptor(prov).decrypt(enc));
            p.setProperty("truststoreFilePassENCProvider", prov);
            p.setProperty("truststoreFilePass", enc);
        } else {
            this.log.warn((Object)"Hey, you should consider encrypting your trust store password!");
            p.setProperty("trustStorePassword", this.config.getString("client.signature.trustStorePassword", ""));
        }
        return p;
    }

    public void addUDDINode(UDDINode node) throws ConfigurationException {
        if (node == null) {
            throw new ConfigurationException("The new node is null");
        }
        if (this.uddiNodes.containsKey(node.getName())) {
            throw new ConfigurationException("Node '" + node.getName() + "' already existings in the collection!");
        }
        if (node.getClientName() == null || "".equalsIgnoreCase(node.getClientName())) {
            this.log.info((Object)"ClientName wasn't specified, I'll configure it with the defaults");
            node.setClientName(this.clientName);
        }
        if (node.getName() == null || "".equalsIgnoreCase(node.getName())) {
            throw new ConfigurationException("Node Name wasn't specified. It cannot be null");
        }
        this.uddiNodes.put(node.getName(), node);
    }

    public void removeUDDINode(String name) throws ConfigurationException {
        if (this.uddiNodes.containsKey(name)) {
            this.uddiNodes.remove(name);
        }
    }

    private void validateConfig() throws ConfigurationException {
        if (this.config == null) {
            throw new ConfigurationException("config is null!");
        }
        if (this.uddiNodes == null) {
            throw new ConfigurationException("nodes is null!");
        }
        if (this.uddiClerks == null) {
            throw new ConfigurationException("clerks is null!");
        }
        for (Map.Entry<String, UDDIClerk> next : this.uddiClerks.entrySet()) {
            if (next.getValue().uddiNode != null) continue;
            throw new ConfigurationException("clerk " + next.getValue().name + " references a node that doesn't exist!");
        }
    }

    private void addCurrentNodeConfig(Configuration cc) {
        cc.addProperty("[@xmlns]", this.config.getProperty("[@xmlns]"));
        cc.addProperty("client(0)[@name]", (Object)this.clientName);
        Iterator<Map.Entry<String, UDDINode>> iterator = this.uddiNodes.entrySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            this.log.debug((Object)("node names=" + this.uddiNodes.size()));
            UDDINode uddiNode = iterator.next().getValue();
            Properties properties = uddiNode.getProperties();
            if (properties == null) {
                properties = new Properties();
            }
            Iterator<Map.Entry<Object, Object>> iterator1 = properties.entrySet().iterator();
            int x = 0;
            while (iterator1.hasNext()) {
                Map.Entry<Object, Object> next = iterator1.next();
                cc.addProperty("client(0).nodes.node(" + i + ").properties.property(" + x + ")[@name]", next.getKey());
                cc.addProperty("client(0).nodes.node(" + i + ").properties.property(" + x + ")[@value]", next.getValue());
                this.log.debug((Object)("Property: name=" + next.getKey() + " value=" + next.getValue()));
                ++x;
            }
            cc.addProperty("client(0).nodes.node(" + i + ")[@isHomeJUDDI]", (Object)uddiNode.isHomeJUDDI());
            cc.addProperty("client(0).nodes.node(" + i + ").name", (Object)uddiNode.getName());
            cc.addProperty("client(0).nodes.node(" + i + ").description", (Object)uddiNode.getDescription());
            cc.addProperty("client(0).nodes.node(" + i + ").proxyTransport", (Object)uddiNode.getProxyTransport());
            cc.addProperty("client(0).nodes.node(" + i + ").inquiryUrl", (Object)uddiNode.getInquiryUrl());
            cc.addProperty("client(0).nodes.node(" + i + ").inquiryRESTUrl", (Object)uddiNode.getInquiry_REST_Url());
            cc.addProperty("client(0).nodes.node(" + i + ").publishUrl", (Object)uddiNode.getPublishUrl());
            cc.addProperty("client(0).nodes.node(" + i + ").custodyTransferUrl", (Object)uddiNode.getCustodyTransferUrl());
            cc.addProperty("client(0).nodes.node(" + i + ").securityUrl", (Object)uddiNode.getSecurityUrl());
            cc.addProperty("client(0).nodes.node(" + i + ").replicationUrl", (Object)uddiNode.getReplicationUrl());
            cc.addProperty("client(0).nodes.node(" + i + ").subscriptionUrl", (Object)uddiNode.getSubscriptionUrl());
            cc.addProperty("client(0).nodes.node(" + i + ").juddiApiUrl", (Object)uddiNode.getJuddiApiUrl());
            cc.addProperty("client(0).nodes.node(" + i + ").subscriptionListenerUrl", (Object)uddiNode.getSubscriptionListenerUrl());
            cc.addProperty("client(0).nodes.node(" + i + ").javaNamingFactoryInitial", (Object)uddiNode.getFactoryInitial());
            cc.addProperty("client(0).nodes.node(" + i + ").javaNamingFactoryUrlPkgs", (Object)uddiNode.getFactoryURLPkgs());
            cc.addProperty("client(0).nodes.node(" + i + ").javaNamingProviderUrl", (Object)uddiNode.getFactoryNamingProvider());
            ++i;
        }
    }

    private void addCurrentClerks(Configuration cc) {
        XRegistration next;
        Iterator<XRegistration> iterator1;
        Iterator<Map.Entry<String, UDDIClerk>> iterator = this.uddiClerks.entrySet().iterator();
        this.clientName = this.config.getString("client[@name]");
        this.clientCallbackUrl = this.config.getString("client(0)[@callbackUrl]");
        cc.addProperty("client(0).clerks[@registerOnStartup]", (Object)this.isRegisterOnStartup());
        int i = 0;
        while (iterator.hasNext()) {
            UDDIClerk.WSDL[] wsdls;
            UDDIClerk uddiClerk = iterator.next().getValue();
            cc.addProperty("client(0).clerks.clerk(" + i + ")[@name]", (Object)uddiClerk.getName());
            cc.addProperty("client(0).clerks.clerk(" + i + ")[@node]", (Object)uddiClerk.getUDDINode().getName());
            cc.addProperty("client(0).clerks.clerk(" + i + ")[@publisher]", (Object)uddiClerk.getPublisher());
            cc.addProperty("client(0).clerks.clerk(" + i + ")[@password]", (Object)uddiClerk.getRawPassword());
            cc.addProperty("client(0).clerks.clerk(" + i + ")[@isPasswordEncrypted]", (Object)uddiClerk.getIsPasswordEncrypted());
            cc.addProperty("client(0).clerks.clerk(" + i + ")[@cryptoProvider]", (Object)uddiClerk.getCryptoProvider());
            String[] classes = uddiClerk.getClassWithAnnotations();
            if (classes != null) {
                for (int x = 0; x < classes.length; ++x) {
                    cc.addProperty("client(0).clerks.clerk(" + i + ").class(" + x + ")", (Object)classes[x]);
                }
            }
            if ((wsdls = uddiClerk.getWsdls()) != null) {
                for (int w = 0; w < wsdls.length; ++w) {
                    cc.addProperty("client(0).clerks.clerk(" + i + ").wsdl(" + w + ")", (Object)wsdls[w].getFileName());
                    cc.addProperty("client(0).clerks.clerk(" + i + ").wsdl(" + w + ")[@businessKey]", (Object)wsdls[w].getBusinessKey());
                    cc.addProperty("client(0).clerks.clerk(" + i + ").wsdl(" + w + ")[@keyDomain]", (Object)wsdls[w].getKeyDomain());
                }
            }
            ++i;
        }
        if (this.xBusinessRegistrations != null) {
            iterator1 = this.xBusinessRegistrations.iterator();
            int x = 0;
            while (iterator1.hasNext()) {
                next = iterator1.next();
                cc.addProperty("client(0).clerks.business(" + x + ")[@fromClerk]", (Object)next.getFromClerk().name);
                cc.addProperty("client(0).clerks.business(" + x + ")[@toClerk]", (Object)next.getToClerk().name);
                cc.addProperty("client(0).clerks.business(" + x + ")[@entityKey]", (Object)next.getEntityKey());
                ++x;
            }
        }
        if (this.xServiceBindingRegistrations != null) {
            iterator1 = this.xServiceBindingRegistrations.iterator();
            int x = 0;
            while (iterator1.hasNext()) {
                next = iterator1.next();
                cc.addProperty("client(0).clerks.servicebinding(" + x + ")[@fromClerk]", (Object)next.getFromClerk().name);
                cc.addProperty("client(0).clerks.servicebinding(" + x + ")[@toClerk]", (Object)next.getToClerk().name);
                cc.addProperty("client(0).clerks.servicebinding(" + x + ")[@entityKey]", (Object)next.getEntityKey());
                ++x;
            }
        }
    }

    private void addSubscriptionCallback(Configuration cc) {
        if (this.config.containsKey("client.subscriptionCallbacks.autoRegisterBindingTemplate")) {
            cc.addProperty("client.subscriptionCallbacks.autoRegisterBindingTemplate", this.config.getProperty("client.subscriptionCallbacks.autoRegisterBindingTemplate"));
        }
        if (this.config.containsKey("client.subscriptionCallbacks.autoRegisterBusinessServiceKey")) {
            cc.addProperty("client.subscriptionCallbacks.autoRegisterBusinessServiceKey", this.config.getProperty("client.subscriptionCallbacks.autoRegisterBusinessServiceKey"));
        }
        if (this.config.containsKey("client.subscriptionCallbacks.keyDomain")) {
            cc.addProperty("client.subscriptionCallbacks.keyDomain", this.config.getProperty("client.subscriptionCallbacks.keyDomain"));
        }
        if (this.config.containsKey("client.subscriptionCallbacks.listenUrl")) {
            cc.addProperty("client.subscriptionCallbacks.listenUrl", this.config.getProperty("client.subscriptionCallbacks.listenUrl"));
        }
        if (this.config.containsKey("client.subscriptionCallbacks.node")) {
            cc.addProperty("client.subscriptionCallbacks.node", this.config.getProperty("client.subscriptionCallbacks.node"));
        }
        if (this.config.containsKey("client.subscriptionCallbacks.signatureBehavior")) {
            cc.addProperty("client.subscriptionCallbacks.signatureBehavior", this.config.getProperty("client.subscriptionCallbacks.signatureBehavior"));
        }
    }

    private void addDigitalSubscription(Configuration cc) throws Exception {
        Properties p = this.getDigitalSignatureConfiguration();
        for (Map.Entry<Object, Object> next : p.entrySet()) {
            String key = (String)next.getKey();
            Object val = next.getValue();
            if (val == null) continue;
            if (key.equalsIgnoreCase("CanonicalizationMethod")) {
                cc.addProperty("client(0).signature.canonicalizationMethod", val);
                continue;
            }
            if (key.equalsIgnoreCase("checkTimestamps")) {
                cc.addProperty("client(0).signature.checkTimestamps", val);
                continue;
            }
            if (key.equalsIgnoreCase("checkRevocationCRL")) {
                cc.addProperty("client(0).signature.checkRevocationCRL", val);
                continue;
            }
            if (key.equalsIgnoreCase("checkRevocationOCSP")) {
                cc.addProperty("client(0).signature.checkRevocationOCSP", val);
                continue;
            }
            if (key.equalsIgnoreCase("checkTrust")) {
                cc.addProperty("client(0).signature.checkTrust", val);
                continue;
            }
            if (key.equalsIgnoreCase("keyStorePath")) {
                cc.addProperty("client(0).signature.signingKeyStorePath", val);
                continue;
            }
            if (key.equalsIgnoreCase("keyStoreType")) {
                cc.addProperty("client(0).signature.signingKeyStoreType", val);
                continue;
            }
            if (key.equalsIgnoreCase("keyPassword")) {
                cc.addProperty("client(0).signature.signingKeyPassword", val);
                continue;
            }
            if (key.equalsIgnoreCase("signatureKeystoreKeyPassENC")) {
                cc.addProperty("client(0).signature.signingKeyPassword[@isPasswordEncrypted]", val);
                continue;
            }
            if (key.equalsIgnoreCase("signatureKeystoreKeyPassENCProvider")) {
                cc.addProperty("client(0).signature.signingKeyPassword[@cryptoProvider]", val);
                continue;
            }
            if (key.equalsIgnoreCase("signatureKeyStoreCipherPass")) {
                cc.addProperty("client(0).signature.signingKeyPassword", val);
                continue;
            }
            if (key.equalsIgnoreCase("keyAlias")) {
                cc.addProperty("client(0).signature.signingKeyAlias", val);
                continue;
            }
            if (key.equalsIgnoreCase("SignatureMethod")) {
                cc.addProperty("client(0).signature.signatureMethod", val);
                continue;
            }
            if (key.equalsIgnoreCase("SUBJECTDN")) {
                cc.addProperty("client(0).signature.keyInfoInclusionSubjectDN", val);
                continue;
            }
            if (key.equalsIgnoreCase("BASE64")) {
                cc.addProperty("client(0).signature.keyInfoInclusionBase64PublicKey", val);
                continue;
            }
            if (key.equalsIgnoreCase("SERIAL")) {
                cc.addProperty("client(0).signature.keyInfoInclusionSerial", val);
                continue;
            }
            if (key.equalsIgnoreCase("digestMethod")) {
                cc.addProperty("client(0).signature.digestMethod", val);
                continue;
            }
            if (key.equalsIgnoreCase("trustStorePath")) {
                cc.addProperty("client(0).signature.trustStorePath", val);
                continue;
            }
            if (key.equalsIgnoreCase("trustStoreType")) {
                cc.addProperty("client(0).signature.trustStoreType", val);
                continue;
            }
            if (key.equalsIgnoreCase("signatureKeystoreFilePassENC")) {
                cc.addProperty("client(0).signature.signingKeyStoreFilePassword[@isPasswordEncrypted]", val);
                continue;
            }
            if (key.equalsIgnoreCase("signatureKeystoreFileENCProvider")) {
                cc.addProperty("client(0).signature.signingKeyStoreFilePassword[@cryptoProvider]", val);
                continue;
            }
            if (key.equalsIgnoreCase("truststoreFilePassENC")) {
                cc.addProperty("client(0).signature.trustStorePassword[@isPasswordEncrypted]", val);
                continue;
            }
            if (!key.equalsIgnoreCase("truststoreFilePassENCProvider")) continue;
            cc.addProperty("client(0).signature.trustStorePassword[@cryptoProvider]", val);
        }
        if (p.getProperty("signatureKeystoreFilePassENC", "false").equalsIgnoreCase("true")) {
            cc.addProperty("client(0).signature.signingKeyStoreFilePassword", (Object)p.getProperty("signatureKeystoreFileKeyPass"));
        } else {
            cc.addProperty("client(0).signature.signingKeyStoreFilePassword", (Object)p.getProperty("filePassword"));
        }
        if (p.getProperty("truststoreFilePassENC", "false").equalsIgnoreCase("true")) {
            cc.addProperty("client(0).signature.trustStorePassword", (Object)p.getProperty("truststoreFilePass"));
        } else {
            cc.addProperty("client(0).signature.trustStorePassword", (Object)p.getProperty("trustStorePassword"));
        }
        if (p.getProperty("signatureKeystoreKeyPassENC", "false").equalsIgnoreCase("true")) {
            cc.addProperty("client(0).signature.signingKeyPassword", (Object)p.getProperty("signatureKeyStoreCipherPass"));
        } else {
            cc.addProperty("client(0).signature.signingKeyPassword", (Object)p.getProperty("keyPassword"));
        }
    }

    private void addXRegistration(Configuration cc) {
        cc.addProperty("client.XtoWsdl.IgnoreSSLErrors", (Object)this.isX_To_Wsdl_Ignore_SSL_Errors());
    }
}

