/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.transport.wrapper;

import java.rmi.RemoteException;
import java.util.Map;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.UDDIServiceV2;
import org.apache.juddi.v3.client.mapping.MapUDDIv2Tov3;
import org.apache.juddi.v3.client.mapping.MapUDDIv3Tov2;
import org.uddi.api_v2.BusinessDetail;
import org.uddi.api_v2.BusinessEntity;
import org.uddi.api_v2.BusinessService;
import org.uddi.api_v2.GetBusinessDetail;
import org.uddi.api_v2.GetTModelDetail;
import org.uddi.api_v2.TModel;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.FindBinding;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindRelatedBusinesses;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetBindingDetail;
import org.uddi.api_v3.GetOperationalInfo;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.OperationalInfo;
import org.uddi.api_v3.OperationalInfos;
import org.uddi.api_v3.RelatedBusinessesList;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.ServiceList;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelList;
import org.uddi.v2_service.DispositionReport;
import org.uddi.v2_service.Inquire;
import org.uddi.v3_service.DispositionReportFaultMessage;
import org.uddi.v3_service.UDDIInquiryPortType;

public class Inquiry3to2
implements UDDIInquiryPortType,
BindingProvider {
    private static Log logger = LogFactory.getLog(Inquiry3to2.class);
    Inquire inquiryService = null;
    public static final String VERSION = "2.0";

    public Inquiry3to2() {
        UDDIServiceV2 service = new UDDIServiceV2();
        this.inquiryService = service.getInquire();
    }

    public Inquire getUDDIv2WebServiceClient() {
        return this.inquiryService;
    }

    public BindingDetail findBinding(FindBinding body) throws DispositionReportFaultMessage, RemoteException {
        try {
            return MapUDDIv2Tov3.MapBindingDetail(this.inquiryService.findBinding(MapUDDIv3Tov2.MapFindBinding(body)));
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    public BusinessList findBusiness(FindBusiness body) throws DispositionReportFaultMessage, RemoteException {
        try {
            org.uddi.api_v2.FindBusiness MapFindBusiness = MapUDDIv3Tov2.MapFindBusiness(body);
            org.uddi.api_v2.BusinessList s = this.inquiryService.findBusiness(MapFindBusiness);
            return MapUDDIv2Tov3.MapBusinessList(s);
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    public RelatedBusinessesList findRelatedBusinesses(FindRelatedBusinesses body) throws DispositionReportFaultMessage, RemoteException {
        try {
            return MapUDDIv2Tov3.MapRelatedBusinessesList(this.inquiryService.findRelatedBusinesses(MapUDDIv3Tov2.MapFindRelatedBusiness(body)));
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    public ServiceList findService(FindService body) throws DispositionReportFaultMessage, RemoteException {
        try {
            return MapUDDIv2Tov3.MapServiceList(this.inquiryService.findService(MapUDDIv3Tov2.MapFindService(body)));
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    public TModelList findTModel(FindTModel body) throws DispositionReportFaultMessage, RemoteException {
        try {
            return MapUDDIv2Tov3.MapTModelList(this.inquiryService.findTModel(MapUDDIv3Tov2.MapFindTModel(body)));
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    public BindingDetail getBindingDetail(GetBindingDetail body) throws DispositionReportFaultMessage, RemoteException {
        try {
            return MapUDDIv2Tov3.MapBindingDetail(this.inquiryService.getBindingDetail(MapUDDIv3Tov2.MapGetBindingDetail(body)));
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    public org.uddi.api_v3.BusinessDetail getBusinessDetail(org.uddi.api_v3.GetBusinessDetail body) throws DispositionReportFaultMessage, RemoteException {
        try {
            return MapUDDIv2Tov3.MapBusinessDetail(this.inquiryService.getBusinessDetail(MapUDDIv3Tov2.MapGetBusinessDetail(body)));
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    public OperationalInfos getOperationalInfo(GetOperationalInfo body) throws DispositionReportFaultMessage, RemoteException {
        OperationalInfos ret = new OperationalInfos();
        for (int i = 0; i < body.getEntityKey().size(); ++i) {
            BusinessDetail z;
            OperationalInfo oi = new OperationalInfo();
            oi.setEntityKey((String)body.getEntityKey().get(i));
            try {
                GetBusinessDetail businessDetail = new GetBusinessDetail();
                businessDetail.setGeneric(VERSION);
                businessDetail.getBusinessKey().add(body.getEntityKey().get(i));
                z = this.inquiryService.getBusinessDetail(businessDetail);
                oi.setNodeID(z.getOperator());
                oi.setAuthorizedName(((BusinessEntity)z.getBusinessEntity().get(0)).getAuthorizedName());
            }
            catch (Exception businessDetail) {
                // empty catch block
            }
            if (oi.getAuthorizedName() != null) continue;
            try {
                GetTModelDetail tModelDetail = new GetTModelDetail();
                tModelDetail.setGeneric(VERSION);
                tModelDetail.getTModelKey().add(body.getEntityKey().get(i));
                z = this.inquiryService.getTModelDetail(tModelDetail);
                oi.setNodeID(z.getOperator());
                oi.setAuthorizedName(((TModel)z.getTModel().get(0)).getAuthorizedName());
            }
            catch (Exception tModelDetail) {
                // empty catch block
            }
            if (oi.getAuthorizedName() != null) continue;
            try {
                org.uddi.api_v2.GetServiceDetail serviceDetail = new org.uddi.api_v2.GetServiceDetail();
                serviceDetail.setGeneric(VERSION);
                serviceDetail.getServiceKey().add(body.getEntityKey().get(i));
                z = this.inquiryService.getServiceDetail(serviceDetail);
                oi.setNodeID(z.getOperator());
                GetBusinessDetail businessDetail = new GetBusinessDetail();
                businessDetail.setGeneric(VERSION);
                businessDetail.getBusinessKey().add(((BusinessService)z.getBusinessService().get(0)).getBusinessKey());
                BusinessDetail z2 = this.inquiryService.getBusinessDetail(businessDetail);
                oi.setNodeID(z.getOperator());
                oi.setAuthorizedName(((BusinessEntity)z2.getBusinessEntity().get(0)).getAuthorizedName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ret.getOperationalInfo().add(oi);
            ret.setTruncated(Boolean.valueOf(false));
        }
        return ret;
    }

    public ServiceDetail getServiceDetail(GetServiceDetail body) throws DispositionReportFaultMessage, RemoteException {
        try {
            return MapUDDIv2Tov3.MapServiceDetail(this.inquiryService.getServiceDetail(MapUDDIv3Tov2.MapGetServiceDetail(body)));
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    public TModelDetail getTModelDetail(org.uddi.api_v3.GetTModelDetail body) throws DispositionReportFaultMessage, RemoteException {
        try {
            return MapUDDIv2Tov3.MapTModelDetail(this.inquiryService.getTModelDetail(MapUDDIv3Tov2.MapGetTModelDetail(body)));
        }
        catch (DispositionReport ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
        catch (SOAPFaultException ex) {
            throw MapUDDIv2Tov3.MapException(ex);
        }
    }

    public Map<String, Object> getRequestContext() {
        return ((BindingProvider)this.inquiryService).getRequestContext();
    }

    public Map<String, Object> getResponseContext() {
        return ((BindingProvider)this.inquiryService).getResponseContext();
    }

    public Binding getBinding() {
        return ((BindingProvider)this.inquiryService).getBinding();
    }

    public EndpointReference getEndpointReference() {
        return ((BindingProvider)this.inquiryService).getEndpointReference();
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        return (T)((BindingProvider)this.inquiryService).getEndpointReference(clazz);
    }
}

