/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.transport;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.config.UDDIClientContainer;
import org.apache.juddi.v3.client.cryptor.CryptorFactory;
import org.apache.juddi.v3.client.transport.JAXWSTransport;
import org.apache.juddi.v3.client.transport.TransportException;
import org.apache.juddi.v3.client.transport.wrapper.Inquiry3to2;
import org.apache.juddi.v3.client.transport.wrapper.Publish3to2;
import org.apache.juddi.v3.client.transport.wrapper.Security3to2;
import org.uddi.v2_service.Inquire;
import org.uddi.v2_service.Publish;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISecurityPortType;

public class JAXWSv2TranslationTransport
extends JAXWSTransport {
    private static Log logger = LogFactory.getLog(JAXWSv2TranslationTransport.class);
    Inquiry3to2 inquiryv2 = null;
    Security3to2 securityv2 = null;
    Publish3to2 publishv2 = null;

    public JAXWSv2TranslationTransport() {
        this.nodeName = "default";
    }

    public JAXWSv2TranslationTransport(String nodeName) {
        this.nodeName = nodeName;
    }

    public JAXWSv2TranslationTransport(String clientName, String nodeName) {
        this.clientName = clientName;
        this.nodeName = nodeName;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    private void setCredentials(Map<String, Object> requestContext) throws ConfigurationException {
        UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
        Properties properties = client.getClientConfig().getUDDINode(this.nodeName).getProperties();
        if (properties != null) {
            String username = null;
            String password = null;
            if (properties.containsKey("basicAuthUsername")) {
                username = properties.getProperty("basicAuthUsername");
            }
            if (properties.containsKey("basicAuthPassword")) {
                password = properties.getProperty("basicAuthPassword");
            }
            String cipher = null;
            boolean isEncrypted = false;
            if (properties.containsKey("basicAuthPasswordCryptoProvider")) {
                cipher = properties.getProperty("basicAuthPasswordCryptoProvider");
            }
            if (properties.containsKey("basicAuthPasswordIsEncrypted")) {
                isEncrypted = Boolean.parseBoolean(properties.getProperty("basicAuthPasswordIsEncrypted"));
            }
            if (username != null && password != null) {
                requestContext.put("javax.xml.ws.security.auth.username", username);
                if (isEncrypted) {
                    try {
                        requestContext.put("javax.xml.ws.security.auth.password", CryptorFactory.getCryptor(cipher).decrypt(password));
                    }
                    catch (Exception ex) {
                        logger.error((Object)"Unable to decrypt password!", (Throwable)ex);
                    }
                } else {
                    requestContext.put("javax.xml.ws.security.auth.password", password);
                }
            }
        }
    }

    @Override
    public UDDIInquiryPortType getUDDIInquiryService(String endpointURL) throws TransportException {
        try {
            if (this.inquiryv2 == null) {
                this.inquiryv2 = new Inquiry3to2();
            }
            if (endpointURL == null) {
                UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
                endpointURL = client.getClientConfig().getUDDINode(this.nodeName).getInquiryUrl();
            }
            Map requestContext = this.inquiryv2.getRequestContext();
            requestContext.put("javax.xml.ws.service.endpoint.address", endpointURL);
            this.setCredentials(requestContext);
        }
        catch (Exception e) {
            throw new TransportException(e.getMessage(), e);
        }
        return this.inquiryv2;
    }

    @Override
    public UDDISecurityPortType getUDDISecurityService(String endpointURL) throws TransportException {
        try {
            if (this.securityv2 == null) {
                this.securityv2 = new Security3to2();
            }
            if (endpointURL == null) {
                UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
                endpointURL = client.getClientConfig().getUDDINode(this.nodeName).getPublishUrl();
            }
            if (endpointURL.toLowerCase().startsWith("http:")) {
                logger.warn((Object)"You should consider use a secure protocol (https) when sending your password!");
            }
            Map requestContext = this.securityv2.getRequestContext();
            requestContext.put("javax.xml.ws.service.endpoint.address", endpointURL);
            this.setCredentials(requestContext);
        }
        catch (Exception e) {
            throw new TransportException(e.getMessage(), e);
        }
        return this.securityv2;
    }

    @Override
    public UDDIPublicationPortType getUDDIPublishService(String endpointURL) throws TransportException {
        try {
            if (this.publishv2 == null) {
                this.publishv2 = new Publish3to2();
            }
            if (endpointURL == null) {
                UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
                endpointURL = client.getClientConfig().getUDDINode(this.nodeName).getPublishUrl();
            }
            Map requestContext = this.publishv2.getRequestContext();
            requestContext.put("javax.xml.ws.service.endpoint.address", endpointURL);
            this.setCredentials(requestContext);
        }
        catch (Exception e) {
            throw new TransportException(e.getMessage(), e);
        }
        return this.publishv2;
    }

    public Inquire getUDDIv2InquiryService() throws TransportException {
        return this.getUDDIv2InquiryService(null);
    }

    public Inquire getUDDIv2InquiryService(String endpointURL) throws TransportException {
        try {
            if (this.inquiryv2 == null) {
                this.inquiryv2 = new Inquiry3to2();
            }
            if (endpointURL == null) {
                UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
                endpointURL = client.getClientConfig().getUDDINode(this.nodeName).getInquiryUrl();
            }
            Map requestContext = this.inquiryv2.getRequestContext();
            requestContext.put("javax.xml.ws.service.endpoint.address", endpointURL);
            this.setCredentials(requestContext);
        }
        catch (Exception e) {
            throw new TransportException(e.getMessage(), e);
        }
        return this.inquiryv2.getUDDIv2WebServiceClient();
    }

    public Publish getUDDIv2PublishService(String endpointURL) throws TransportException {
        try {
            if (this.publishv2 == null) {
                this.publishv2 = new Publish3to2();
            }
            if (endpointURL == null) {
                UDDIClient client = UDDIClientContainer.getUDDIClient(this.clientName);
                endpointURL = client.getClientConfig().getUDDINode(this.nodeName).getPublishUrl();
            }
            Map requestContext = this.publishv2.getRequestContext();
            requestContext.put("javax.xml.ws.service.endpoint.address", endpointURL);
            this.setCredentials(requestContext);
        }
        catch (Exception e) {
            throw new TransportException(e.getMessage(), e);
        }
        return this.publishv2.getUDDIv2PublishWebServiceClient();
    }

    public Publish getUDDIv2PublishService() throws TransportException {
        return this.getUDDIv2PublishService(null);
    }
}

