/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.mapping;

import java.net.BindException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.AccessPointType;
import org.apache.juddi.v3.client.ClassUtil;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.config.UDDIKeyConvention;
import org.apache.juddi.v3.client.mapping.SelectionPolicy;
import org.apache.juddi.v3.client.mapping.Topology;
import org.apache.juddi.v3.client.mapping.UDDIServiceCache;
import org.apache.juddi.v3.client.mapping.URLLocalizer;
import org.apache.juddi.v3.client.mapping.URLLocalizerDefaultImpl;
import org.apache.juddi.v3.client.transport.TransportException;
import org.uddi.api_v3.AccessPoint;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.Name;

public class ServiceLocator {
    private static final Log log = LogFactory.getLog(ServiceLocator.class);
    private UDDIClerk clerk;
    private Properties properties = new Properties();
    private UDDIServiceCache serviceCache = null;
    private String policy = null;
    private SelectionPolicy selectionPolicy = null;
    private URLLocalizer urlLocalizer = null;
    private ConcurrentHashMap<String, Topology> simpleCache = null;

    public ServiceLocator(UDDIClerk clerk) {
        this.clerk = clerk;
        this.properties = clerk.getUDDINode().getProperties();
    }

    public ServiceLocator(UDDIClerk clerk, URLLocalizer urlLocalizer, Properties properties) throws ConfigurationException {
        this.clerk = clerk;
        this.urlLocalizer = urlLocalizer;
        this.properties = properties;
        if (properties == null) {
            this.properties = clerk.getUDDINode().getProperties();
        }
    }

    public ServiceLocator withCache(URL baseCallbackURL) throws ConfigurationException {
        if (this.serviceCache == null) {
            this.serviceCache = this.initCache(baseCallbackURL);
        }
        return this;
    }

    public ServiceLocator withLiveCache(URL baseCallbackURL) throws ConfigurationException, BindException {
        if (this.serviceCache == null) {
            this.serviceCache = this.initCache(baseCallbackURL);
            this.serviceCache.registerAsMBean();
        }
        if (!this.serviceCache.hasListener()) {
            this.serviceCache.publishAndRegisterHttpCallbackEndpoint();
        }
        return this;
    }

    public ServiceLocator withSimpleCache() {
        if (this.simpleCache == null) {
            this.simpleCache = new ConcurrentHashMap();
        }
        return this;
    }

    public UDDIServiceCache getUDDIServiceCache() {
        return this.serviceCache;
    }

    public ServiceLocator setPolicy(String policy) {
        this.policy = policy;
        return this;
    }

    public SelectionPolicy getPolicy() throws ConfigurationException {
        try {
            if (this.selectionPolicy == null) {
                if (this.policy == null) {
                    this.policy = this.properties.getProperty("juddi.client.selection.policy", "org.apache.juddi.v3.client.mapping.PolicyLocalFirst");
                }
                Class<?> selectionPolicyClass = ClassUtil.forName(this.policy, this.getClass());
                this.selectionPolicy = (SelectionPolicy)selectionPolicyClass.getConstructor(Properties.class).newInstance(this.properties);
            }
            return this.selectionPolicy;
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    private UDDIServiceCache initCache(URL baseCallbackURL) throws ConfigurationException {
        if (this.clerk == null) {
            throw new ConfigurationException("The UDDIClerk is needed to use the UDDIServiceCache and is null");
        }
        if (this.urlLocalizer == null) {
            this.urlLocalizer = new URLLocalizerDefaultImpl(baseCallbackURL);
        }
        if (this.properties == null) {
            this.properties = new Properties();
        }
        try {
            log.info((Object)"Creating a UDDICLientCache");
            return new UDDIServiceCache(this.clerk, this.urlLocalizer, this.properties);
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    public void clearCaches() {
        if (this.serviceCache != null) {
            this.serviceCache.removeAll();
        }
        if (this.simpleCache != null) {
            this.simpleCache.clear();
        }
    }

    public void shutdown() throws RemoteException, ConfigurationException, TransportException {
        if (this.serviceCache != null) {
            this.serviceCache.shutdown();
        }
    }

    public String lookupEndpoint(String serviceKey) throws RemoteException, ConfigurationException, TransportException {
        Topology topology = null;
        if (this.simpleCache != null && this.simpleCache.containsKey(serviceKey)) {
            topology = this.simpleCache.get(serviceKey);
        } else if (this.serviceCache == null) {
            topology = this.lookupEndpointInUDDI(serviceKey);
        } else {
            topology = this.serviceCache.lookupService(serviceKey);
            if (topology == null) {
                topology = this.lookupEndpointInUDDI(serviceKey);
            }
        }
        if (topology != null && topology.getEprs().size() > 0) {
            if (this.simpleCache != null) {
                this.simpleCache.put(serviceKey, topology);
            }
            String epr = this.getPolicy().select(topology);
            return epr;
        }
        return null;
    }

    public String lookupEndpoint(QName serviceQName, String portName) throws RemoteException, ConfigurationException, TransportException {
        String serviceKey = UDDIKeyConvention.getServiceKey(this.properties, serviceQName.getLocalPart());
        return this.lookupEndpoint(serviceKey);
    }

    private Topology lookupEndpointInUDDI(String serviceKey) throws RemoteException, ConfigurationException, TransportException {
        Topology topology = null;
        BusinessService service = this.clerk.getServiceDetail(serviceKey);
        if (service == null) {
            log.warn((Object)("No Service with key " + serviceKey + " was found in the registry."));
        }
        if (service != null && service.getBindingTemplates() != null && service.getBindingTemplates().getBindingTemplate() != null) {
            ArrayList<String> eprs = new ArrayList<String>();
            BindingTemplates bindingTemplates = service.getBindingTemplates();
            if (bindingTemplates == null) {
                log.warn((Object)("Found service " + ((Name)service.getName().get(0)).getValue() + " with serviceKey '" + serviceKey + "' but no EPRs"));
            } else {
                log.debug((Object)("Found service " + ((Name)service.getName().get(0)).getValue() + " with serviceKey '" + serviceKey + "' and " + bindingTemplates.getBindingTemplate().size() + " EPRs"));
                for (BindingTemplate bindingTemplate : bindingTemplates.getBindingTemplate()) {
                    AccessPoint accessPoint = bindingTemplate.getAccessPoint();
                    if (accessPoint == null) continue;
                    if (AccessPointType.END_POINT.toString().equals(accessPoint.getUseType())) {
                        String url = accessPoint.getValue();
                        log.debug((Object)("epr= " + url));
                        eprs.add(url);
                        continue;
                    }
                    if (!AccessPointType.WSDL_DEPLOYMENT.toString().equals(accessPoint.getUseType()) && !AccessPointType.BINDING_TEMPLATE.toString().equals(accessPoint.getUseType())) continue;
                }
                if (eprs.size() > 0) {
                    topology = new Topology(eprs);
                }
            }
        }
        if (this.serviceCache != null && topology != null) {
            this.serviceCache.addService(serviceKey, topology);
        }
        return topology;
    }
}

