/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cryptor;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.ws.BindingProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportSecurityHelper {
    private static final Log log = LogFactory.getLog(TransportSecurityHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean applyTransportSecurity(BindingProvider webServicePort) {
        try {
            File currentdir = new File(".");
            String s = System.getProperty("javax.net.ssl.keyStore");
            String st = System.getProperty("javax.net.ssl.trustStore");
            log.info((Object)("Attempting to initialize keystore and truststore from " + s + " " + st));
            if (s == null) {
                log.warn((Object)"keystore isn't defined!");
                return false;
            }
            if (st == null) {
                log.warn((Object)("truststore isn't defined! " + s));
                return false;
            }
            File keystore = new File(s);
            if (keystore == null || !keystore.exists()) {
                log.warn((Object)("keystore doesn't exist! input was " + s + " working dir is " + currentdir.getAbsolutePath()));
                return false;
            }
            String pwd = System.getProperty("javax.net.ssl.keyStorePassword");
            if (pwd == null) {
                log.warn((Object)"keystore password isn't defined!");
                return false;
            }
            File truststore = new File(st);
            if (truststore == null || !truststore.exists()) {
                log.warn((Object)("truststore doesn't exist! input was " + s + " working dir is " + currentdir.getAbsolutePath()));
                return false;
            }
            String pwdt = System.getProperty("javax.net.ssl.trustStorePassword");
            if (pwdt == null) {
                log.warn((Object)"truststore password isn't defined!");
                return false;
            }
            if (keystore.exists()) {
                TrustManagerFactory tmFact = null;
                FileInputStream fis = null;
                SSLContext sc = SSLContext.getInstance("SSLv3");
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                try {
                    log.info((Object)("Using keystore from " + keystore.getAbsolutePath() + " current dir is " + currentdir.getAbsolutePath()));
                    log.info((Object)("Using truststore from " + truststore.getAbsolutePath() + " current dir is " + currentdir.getAbsolutePath()));
                    KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                    try {
                        fis = new FileInputStream(keystore);
                        ks.load(fis, pwd.toCharArray());
                    }
                    catch (Exception ex) {
                        log.warn((Object)("unable to load key store " + keystore.getAbsolutePath()), (Throwable)ex);
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    kmf.init(ks, pwd.toCharArray());
                    String alg = TrustManagerFactory.getDefaultAlgorithm();
                    tmFact = TrustManagerFactory.getInstance(alg);
                }
                catch (Exception ex) {
                    log.warn((Object)"unable to establish ssl settings", (Throwable)ex);
                }
                try {
                    fis = new FileInputStream(st);
                    KeyStore kst = KeyStore.getInstance("jks");
                    try {
                        kst.load(fis, pwdt.toCharArray());
                    }
                    catch (Exception ex) {
                        log.warn((Object)("unable to load key store " + st), (Throwable)ex);
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    tmFact.init(kst);
                    sc.init(kmf.getKeyManagers(), tmFact.getTrustManagers(), null);
                    HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                    webServicePort.getRequestContext().put("com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory", sc.getSocketFactory());
                    webServicePort.getRequestContext().put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", sc.getSocketFactory());
                    return true;
                }
                catch (Exception ex) {
                    log.warn((Object)"unable to establish ssl settings", (Throwable)ex);
                }
            }
            return false;
        }
        catch (Exception x) {
            log.error((Object)"unexpected error", (Throwable)x);
            return false;
        }
    }
}

