/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cryptor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.ClassUtil;
import org.apache.juddi.v3.client.cryptor.Cryptor;

public abstract class CryptorFactory {
    private static final Log log = LogFactory.getLog(CryptorFactory.class);
    private static Cryptor cryptor = null;
    private static Map<String, Cryptor> cache = new HashMap<String, Cryptor>();

    public static Cryptor getCryptor(String className) throws Exception {
        if (cache.containsKey(className)) {
            return cache.get(className);
        }
        Class<?> cryptorClass = null;
        try {
            cryptorClass = ClassUtil.forName(className, CryptorFactory.class);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("The specified Cryptor class '" + className + "' was not found in classpath."));
            log.error((Object)e);
            throw e;
        }
        try {
            cryptor = (Cryptor)cryptorClass.newInstance();
            cache.put(className, cryptor);
        }
        catch (Exception e) {
            log.error((Object)("Exception while attempting to instantiate the implementation of Cryptor: " + cryptorClass.getName() + "\n" + e.getMessage()));
            log.error((Object)e);
            throw e;
        }
        return cryptor;
    }

    public static synchronized Cryptor getCryptor() {
        if (cryptor == null) {
            cryptor = CryptorFactory.createCryptor();
        }
        return cryptor;
    }

    private static synchronized Cryptor createCryptor() {
        if (cryptor != null) {
            return cryptor;
        }
        String className = "org.apache.juddi.v3.client.cryptor.DefaultCryptor";
        log.debug((Object)("Cryptor Implementation = " + className));
        Class<?> cryptorClass = null;
        try {
            cryptorClass = ClassUtil.forName(className, CryptorFactory.class);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("The specified Cryptor class '" + className + "' was not found in classpath."));
            log.error((Object)e);
        }
        if (cryptorClass != null) {
            try {
                cryptor = (Cryptor)cryptorClass.newInstance();
            }
            catch (Exception e) {
                log.error((Object)("Exception while attempting to instantiate the implementation of Cryptor: " + cryptorClass.getName() + "\n" + e.getMessage()));
                log.error((Object)e);
            }
        }
        return cryptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String loadKeyFromFile(String provider) {
        String fs = System.getProperty("juddi.encryptionKeyFile." + provider);
        if (fs == null || fs.length() == 0) {
            return null;
        }
        File cwd = new File(".");
        log.debug((Object)("CWD=" + cwd.getAbsolutePath()));
        File f = new File(fs);
        if (f.exists() && f.isFile()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(f));
                String line = null;
                StringBuilder stringBuilder = new StringBuilder();
                String ls = System.getProperty("line.separator");
                while ((line = reader.readLine()) != null) {
                    stringBuilder.append(line);
                    stringBuilder.append(ls);
                }
                reader.close();
                String string = stringBuilder.toString().trim();
                return string;
            }
            catch (Exception ex) {
                log.warn((Object)("the system property juddi.encryptionKeyFile." + provider + " is defined, however there was an error reading the file!"), (Throwable)ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        log.warn((Object)("the system property juddi.encryptionKeyFile." + provider + " is defined, however that file either couldn't be found or isn't a file"));
        return null;
    }
}

