/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cli;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.cryptor.DigSigUtil;
import org.apache.juddi.v3.client.transport.Transport;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.api_v3.GetTModelDetail;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISecurityPortType;

public class UddiDigitalSignatureTmodel {
    private UDDISecurityPortType security = null;
    private UDDIInquiryPortType inquiry = null;
    private UDDIPublicationPortType publish = null;
    private UDDIClient clerkManager = null;

    public UddiDigitalSignatureTmodel() {
        try {
            this.clerkManager = new UDDIClient("META-INF/simple-publish-uddi.xml");
            Transport transport = this.clerkManager.getTransport();
            this.security = transport.getUDDISecurityService();
            this.inquiry = transport.getUDDIInquiryService();
            this.publish = transport.getUDDIPublishService();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        UddiDigitalSignatureTmodel sp = new UddiDigitalSignatureTmodel();
        sp.fire(null, null);
    }

    public void fire(String token, String key) {
        try {
            TModel be;
            DigSigUtil ds = null;
            ds = new DigSigUtil();
            ds.put("keyStorePath", "keystore.jks");
            ds.put("keyStoreType", "JKS");
            ds.put("filePassword", "Test");
            ds.put("keyAlias", "Test");
            ds.put("BASE64", "true");
            ds.put("SERIAL", "true");
            ds.put("SUBJECTDN", "true");
            ds.put("trustStorePath", "truststore.jks");
            ds.put("trustStoreType", "JKS");
            ds.put("trustStorePassword", "Test");
            if (token == null) {
                token = this.getAuthKey(this.clerkManager.getClerk("default").getPublisher(), this.clerkManager.getClerk("default").getPassword());
            }
            if (key == null) {
                SaveTModel stm = new SaveTModel();
                stm.setAuthInfo(token);
                TModel tm = new TModel();
                tm.setName(new Name("my cool signed tmodel", null));
                stm.getTModel().add(tm);
                TModelDetail saveTModel = this.publish.saveTModel(stm);
                key = ((TModel)saveTModel.getTModel().get(0)).getTModelKey();
            }
            if (!(be = this.getTmodelDetails(key)).getSignature().isEmpty()) {
                System.out.println("WARN, the entity with the key " + key + " is already signed! aborting");
                return;
            }
            System.out.println("signing");
            TModel signUDDI_JAXBObject = (TModel)ds.signUddiEntity((Object)be);
            DigSigUtil.JAXB_ToStdOut((Object)signUDDI_JAXBObject);
            System.out.println("signed, saving");
            SaveTModel sb = new SaveTModel();
            sb.setAuthInfo(token);
            sb.getTModel().add(signUDDI_JAXBObject);
            this.publish.saveTModel(sb);
            System.out.println("saved, fetching");
            be = this.getTmodelDetails(key);
            DigSigUtil.JAXB_ToStdOut((Object)be);
            System.out.println("verifing");
            AtomicReference msg = new AtomicReference();
            boolean verifySigned_UDDI_JAXB_Object = ds.verifySignedUddiEntity((Object)be, msg);
            if (verifySigned_UDDI_JAXB_Object) {
                System.out.println("signature validation passed (expected)");
            } else {
                System.out.println("signature validation failed (not expected)");
            }
            System.out.println((String)msg.get());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private TModel getTmodelDetails(String key) throws Exception {
        GetTModelDetail r = new GetTModelDetail();
        r.getTModelKey().add(key);
        return (TModel)this.inquiry.getTModelDetail(r).getTModel().get(0);
    }

    private String getAuthKey(String username, String password) {
        try {
            GetAuthToken getAuthTokenRoot = new GetAuthToken();
            getAuthTokenRoot.setUserID(username);
            getAuthTokenRoot.setCred(password);
            AuthToken rootAuthToken = this.security.getAuthToken(getAuthTokenRoot);
            System.out.println("root AUTHTOKEN = don't log auth tokens!");
            return rootAuthToken.getAuthInfo();
        }
        catch (Exception ex) {
            System.out.println("Could not authenticate with the provided credentials " + ex.getMessage());
            return null;
        }
    }
}

