/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cli;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.apache.juddi.v3.client.cryptor.DigSigUtil;
import org.apache.juddi.v3.client.transport.Transport;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISecurityPortType;

public class UddiDigitalSignatureBusiness {
    private UDDISecurityPortType security = null;
    private UDDIInquiryPortType inquiry = null;
    private UDDIPublicationPortType publish = null;
    private UDDIClient clerkManager = null;

    public UddiDigitalSignatureBusiness() {
        try {
            this.clerkManager = new UDDIClient("META-INF/simple-publish-uddi.xml");
            Transport transport = this.clerkManager.getTransport();
            this.security = transport.getUDDISecurityService();
            this.inquiry = transport.getUDDIInquiryService();
            this.publish = transport.getUDDIPublishService();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UddiDigitalSignatureBusiness(Transport transport) {
        try {
            this.security = transport.getUDDISecurityService();
            this.inquiry = transport.getUDDIInquiryService();
            this.publish = transport.getUDDIPublishService();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        UddiDigitalSignatureBusiness sp = new UddiDigitalSignatureBusiness();
        sp.fire(null, null);
    }

    public void fire(String token, String key) {
        try {
            DigSigUtil ds = null;
            ds = new DigSigUtil();
            ds.put("keyStorePath", "keystore.jks");
            ds.put("keyStoreType", "JKS");
            ds.put("filePassword", "Test");
            ds.put("keyAlias", "Test");
            ds.put("BASE64", "true");
            ds.put("SERIAL", "true");
            ds.put("SUBJECTDN", "true");
            ds.put("trustStorePath", "truststore.jks");
            ds.put("trustStoreType", "JKS");
            ds.put("trustStorePassword", "Test");
            if (token == null) {
                token = this.getAuthKey(this.clerkManager.getClerk("default").getPublisher(), this.clerkManager.getClerk("default").getPassword());
            }
            if (key == null) {
                SaveBusiness sb = new SaveBusiness();
                sb.setAuthInfo(token);
                BusinessEntity ob = new BusinessEntity();
                Name name = new Name();
                name.setValue("My Signed Business");
                ob.getName().add(name);
                sb.getBusinessEntity().add(ob);
                BusinessDetail saveBusiness = this.publish.saveBusiness(sb);
                System.out.println("business created with key " + ((BusinessEntity)saveBusiness.getBusinessEntity().get(0)).getBusinessKey());
                BusinessEntity be = (BusinessEntity)saveBusiness.getBusinessEntity().get(0);
                key = be.getBusinessKey();
            }
            BusinessEntity be = this.clerkManager.getClerk("default").getBusinessDetail(key);
            DigSigUtil.JAXB_ToStdOut((Object)be);
            if (!be.getSignature().isEmpty()) {
                System.out.println("WARN, the entity with the key " + key + " is already signed! aborting");
                return;
            }
            System.out.println("signing");
            BusinessEntity signUDDI_JAXBObject = (BusinessEntity)ds.signUddiEntity((Object)be);
            DigSigUtil.JAXB_ToStdOut((Object)signUDDI_JAXBObject);
            System.out.println("signed, saving");
            SaveBusiness sb = new SaveBusiness();
            sb.setAuthInfo(token);
            sb.getBusinessEntity().add(signUDDI_JAXBObject);
            this.publish.saveBusiness(sb);
            System.out.println("saved, fetching");
            GetBusinessDetail gb = new GetBusinessDetail();
            gb.setAuthInfo(token);
            gb.getBusinessKey().add(be.getBusinessKey());
            be = (BusinessEntity)this.inquiry.getBusinessDetail(gb).getBusinessEntity().get(0);
            DigSigUtil.JAXB_ToStdOut((Object)be);
            System.out.println("verifing");
            AtomicReference msg = new AtomicReference();
            boolean verifySigned_UDDI_JAXB_Object = ds.verifySignedUddiEntity((Object)be, msg);
            if (verifySigned_UDDI_JAXB_Object) {
                System.out.println("signature validation passed (expected)");
            } else {
                System.out.println("signature validation failed (not expected)");
            }
            System.out.println((String)msg.get());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getAuthKey(String username, String password) {
        try {
            GetAuthToken getAuthTokenRoot = new GetAuthToken();
            getAuthTokenRoot.setUserID(username);
            getAuthTokenRoot.setCred(password);
            AuthToken rootAuthToken = this.security.getAuthToken(getAuthTokenRoot);
            System.out.println("root AUTHTOKEN = don't log auth tokens!");
            return rootAuthToken.getAuthInfo();
        }
        catch (Exception ex) {
            System.out.println("Could not authenticate with the provided credentials " + ex.getMessage());
            return null;
        }
    }
}

