/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Text;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

public final class XmlUtil {
    private static final String ALL_TEXT_NODES = "//text()";
    private static final Logger LOG = Logger.getLogger(XmlUtil.class);

    private XmlUtil() {
    }

    public static List<Element> parse(String xml, String requestedNodes) {
        if (StringUtils.isNotEmpty((CharSequence)xml) && StringUtils.isNotEmpty((CharSequence)requestedNodes)) {
            HashSet readed = new HashSet();
            SAXBuilder builder = new SAXBuilder();
            try {
                Enumeration<URL> resources = XmlUtil.class.getClassLoader().getResources(xml);
                while (resources.hasMoreElements()) {
                    URL resource = resources.nextElement();
                    LOG.debug((Object)("reading " + resource.toString()));
                    Document doc = builder.build(resource);
                    XPathFactory xpfac = XPathFactory.instance();
                    XPathExpression xp = xpfac.compile(requestedNodes, Filters.element());
                    readed.addAll(xp.evaluate((Object)doc));
                }
                return new ArrayList<Element>(readed);
            }
            catch (IOException ioe) {
                LOG.error((Object)("Couldn't load all " + xml + " resources"), (Throwable)ioe);
            }
            catch (JDOMException jdome) {
                LOG.error((Object)("error parsing " + xml + " resources"), (Throwable)jdome);
            }
        }
        return Collections.emptyList();
    }

    public static List<Element> parse(InputStream xmlStream, String requestedNodes) {
        if (xmlStream != null && StringUtils.isNotEmpty((CharSequence)requestedNodes)) {
            SAXBuilder builder = new SAXBuilder();
            try {
                Document doc = builder.build(xmlStream);
                XPathFactory xpfac = XPathFactory.instance();
                XPathExpression xp = xpfac.compile(requestedNodes, Filters.element());
                return xp.evaluate((Object)doc);
            }
            catch (IOException ioe) {
                LOG.error((Object)("Couldn't load all " + xmlStream + " resources"), (Throwable)ioe);
            }
            catch (JDOMException jdome) {
                LOG.error((Object)("error parsing " + xmlStream + " resources"), (Throwable)jdome);
            }
        }
        return Collections.emptyList();
    }

    public static String extractTextFromDocument(Document doc) {
        if (doc == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List nodes = XPathFactory.instance().compile(ALL_TEXT_NODES).evaluate((Object)doc);
        for (Object el : nodes) {
            if (!(el instanceof Text)) continue;
            sb.append(((Text)el).getValue());
        }
        return sb.toString();
    }
}

