/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public final class Serializer {
    protected static final String BASE64_PREFIX = "base64 ";

    private Serializer() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, ? extends Serializable> deserializeFromBase64(String rawString) throws IOException {
        byte[] decodedBytes = Base64.getDecoder().decode(rawString.getBytes(StandardCharsets.UTF_8));
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(decodedBytes);
        try (ObjectInputStream in = new ObjectInputStream(bytesIn);){
            HashMap hashMap = (HashMap)in.readObject();
            return hashMap;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not deserialiaze user profile attributes. Reason: " + e.getMessage());
        }
    }

    public static String serializeToBase64(Map<String, Serializable> map) throws IOException {
        HashMap<String, Serializable> serialMap = new HashMap<String, Serializable>();
        serialMap.putAll(map);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytesOut);
        out.writeObject(serialMap);
        out.close();
        byte[] result = Base64.getEncoder().encode(bytesOut.toByteArray());
        return new String(result);
    }
}

