/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Random;

public final class CryptoUtil {
    private static final String SSHA = "{SSHA}";
    private static final Random RANDOM = new SecureRandom();
    private static final int DEFAULT_SALT_SIZE = 8;
    private static final Object HELP = "--help";
    private static final Object HASH = "--hash";
    private static final Object VERIFY = "--verify";

    private CryptoUtil() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args.length == 1 && HELP.equals(args[0])) {
            System.out.println("Usage: CryptoUtil [options] ");
            System.out.println("   --hash   password             create hash for password");
            System.out.println("   --verify password digest      verify password for digest");
            System.exit(0);
        }
        if (HASH.equals(args[0])) {
            if (args.length < 2) {
                throw new IllegalArgumentException("Error: --hash requires a 'password' argument.");
            }
            String password = args[1].trim();
            System.out.println(CryptoUtil.getSaltedPassword(password.getBytes(StandardCharsets.UTF_8)));
        } else if (VERIFY.equals(args[0])) {
            if (args.length < 3) {
                throw new IllegalArgumentException("Error: --hash requires 'password' and 'digest' arguments.");
            }
            String password = args[1].trim();
            String digest = args[2].trim();
            System.out.println(CryptoUtil.verifySaltedPassword(password.getBytes(StandardCharsets.UTF_8), digest));
        } else {
            System.out.println("Wrong usage. Try --help.");
        }
    }

    public static String getSaltedPassword(byte[] password) throws NoSuchAlgorithmException {
        byte[] salt = new byte[8];
        RANDOM.nextBytes(salt);
        return CryptoUtil.getSaltedPassword(password, salt);
    }

    protected static String getSaltedPassword(byte[] password, byte[] salt) throws NoSuchAlgorithmException {
        int i;
        MessageDigest digest = MessageDigest.getInstance("SHA");
        digest.update(password);
        byte[] hash = digest.digest(salt);
        byte[] all = new byte[hash.length + salt.length];
        for (i = 0; i < hash.length; ++i) {
            all[i] = hash[i];
        }
        for (i = 0; i < salt.length; ++i) {
            all[hash.length + i] = salt[i];
        }
        byte[] base64 = Base64.getEncoder().encode(all);
        return SSHA + new String(base64, StandardCharsets.UTF_8);
    }

    public static boolean verifySaltedPassword(byte[] password, String entry) throws NoSuchAlgorithmException {
        if (!entry.startsWith(SSHA)) {
            throw new IllegalArgumentException("Hash not prefixed by {SSHA}; is it really a salted hash?");
        }
        byte[] challenge = Base64.getDecoder().decode(entry.substring(6).getBytes(StandardCharsets.UTF_8));
        byte[] passwordHash = CryptoUtil.extractPasswordHash(challenge);
        byte[] salt = CryptoUtil.extractSalt(challenge);
        MessageDigest digest = MessageDigest.getInstance("SHA");
        digest.update(password);
        byte[] hash = digest.digest(salt);
        return Arrays.equals(passwordHash, hash);
    }

    protected static byte[] extractPasswordHash(byte[] digest) throws IllegalArgumentException {
        if (digest.length < 20) {
            throw new IllegalArgumentException("Hash was less than 20 characters; could not extract password hash!");
        }
        byte[] hash = new byte[20];
        for (int i = 0; i < 20; ++i) {
            hash[i] = digest[i];
        }
        return hash;
    }

    protected static byte[] extractSalt(byte[] digest) throws IllegalArgumentException {
        if (digest.length <= 20) {
            throw new IllegalArgumentException("Hash was less than 21 characters; we found no salt!");
        }
        byte[] salt = new byte[digest.length - 20];
        for (int i = 20; i < digest.length; ++i) {
            salt[i - 20] = digest[i];
        }
        return salt;
    }
}

