/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wiki.util.XmlUtil;
import org.jdom2.Element;

public final class ClassUtil {
    private static final Logger log = Logger.getLogger(ClassUtil.class);
    public static final String MAPPINGS = "ini/classmappings.xml";
    public static final String MAPPINGS_EXTRA = "ini/classmappings-extra.xml";
    private static Map<String, String> c_classMappings = ClassUtil.populateClassMappingsFrom("ini/classmappings.xml");
    private static Map<String, String> c_classMappingsExtra = ClassUtil.populateClassMappingsFrom("ini/classmappings-extra.xml");
    private static boolean classLoaderSetup = false;
    private static ClassLoader loader = null;

    private static Map<String, String> populateClassMappingsFrom(String fileLoc) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        List<Element> nodes = XmlUtil.parse(fileLoc, "/classmappings/mapping");
        if (!nodes.isEmpty()) {
            for (Element f : nodes) {
                String key = f.getChildText("requestedClass");
                String className = f.getChildText("mappedClass");
                map.put(key, className);
                log.debug((Object)("Mapped class '" + key + "' to class '" + className + "'"));
            }
        } else {
            log.info((Object)"Didn't find class mapping document in ini/classmappings.xml");
        }
        return map;
    }

    private ClassUtil() {
    }

    public static Class<?> findClass(List<String> packages, List<String> externaljars, String className) throws ClassNotFoundException {
        if (!classLoaderSetup) {
            loader = ClassUtil.setupClassLoader(externaljars);
        }
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            for (String packageName : packages) {
                try {
                    return loader.loadClass(packageName + "." + className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw new ClassNotFoundException("Class '" + className + "' not found in search path!");
        }
    }

    private static ClassLoader setupClassLoader(List<String> externaljars) {
        classLoaderSetup = true;
        log.info((Object)"setting up classloaders for external (plugin) jars");
        if (externaljars.size() == 0) {
            log.info((Object)"no external jars configured, using standard classloading");
            return ClassUtil.class.getClassLoader();
        }
        URL[] urls = new URL[externaljars.size()];
        int i = 0;
        for (String externaljar : externaljars) {
            try {
                File jarFile = new File(externaljar);
                URL ucl = jarFile.toURI().toURL();
                urls[i++] = ucl;
                log.info((Object)("added " + ucl + " to list of external jars"));
            }
            catch (MalformedURLException e) {
                log.error((Object)("exception (" + e.getMessage() + ") while setting up classloaders for external jar:" + externaljar + ", continuing without external jars."));
            }
        }
        if (i == 0) {
            log.error((Object)"all external jars threw an exception while setting up classloaders for them, continuing with standard classloading. See https://jspwiki-wiki.apache.org/Wiki.jsp?page=InstallingPlugins for help on how to install custom plugins.");
            return ClassUtil.class.getClassLoader();
        }
        return new URLClassLoader(urls, ClassUtil.class.getClassLoader());
    }

    public static Class<?> findClass(String packageName, String className) throws ClassNotFoundException {
        try {
            return ClassUtil.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return ClassUtil.class.getClassLoader().loadClass(packageName + "." + className);
        }
    }

    public static List<String> classpathEntriesUnder(String rootPackage) {
        ArrayList<String> results = new ArrayList<String>();
        Enumeration<URL> en = null;
        if (StringUtils.isNotEmpty((CharSequence)rootPackage)) {
            try {
                en = ClassUtil.class.getClassLoader().getResources(rootPackage);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        while (en != null && en.hasMoreElements()) {
            URL url = en.nextElement();
            try {
                if ("jar".equals(url.getProtocol())) {
                    ClassUtil.jarEntriesUnder(results, (JarURLConnection)url.openConnection(), rootPackage);
                    continue;
                }
                if (!"file".equals(url.getProtocol())) continue;
                ClassUtil.fileEntriesUnder(results, new File(url.getFile()), rootPackage);
            }
            catch (IOException ioe) {
                log.error((Object)ioe.getMessage(), (Throwable)ioe);
            }
        }
        return results;
    }

    static void fileEntriesUnder(List<String> results, File file, String rootPackage) {
        log.debug((Object)("scanning [" + file.getName() + "]"));
        if (file.isDirectory()) {
            Iterator files = FileUtils.iterateFiles((File)file, null, (boolean)true);
            while (files.hasNext()) {
                File subfile = (File)files.next();
                String entry = StringUtils.replace((String)subfile.getAbsolutePath(), (String)(file.getAbsolutePath() + File.separatorChar), (String)"");
                results.add(rootPackage + "/" + entry);
            }
        } else {
            results.add(file.getName());
        }
    }

    static void jarEntriesUnder(List<String> results, JarURLConnection jurlcon, String rootPackage) {
        try (JarFile jar = jurlcon.getJarFile();){
            log.debug((Object)("scanning [" + jar.getName() + "]"));
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(rootPackage) || entry.isDirectory()) continue;
                results.add(entry.getName());
            }
        }
        catch (IOException ioe) {
            log.error((Object)ioe.getMessage(), (Throwable)ioe);
        }
    }

    public static <T> T getMappedObject(String requestedClass) throws ReflectiveOperationException, IllegalArgumentException {
        Object[] initargs = new Object[]{};
        return ClassUtil.getMappedObject(requestedClass, initargs);
    }

    public static <T> T getMappedObject(String requestedClass, Object ... initargs) throws ReflectiveOperationException, IllegalArgumentException {
        Constructor<?>[] ctors;
        Class<?> cl = ClassUtil.getMappedClass(requestedClass);
        for (Constructor<?> ctor : ctors = cl.getConstructors()) {
            Class<?>[] params = ctor.getParameterTypes();
            if (params.length != initargs.length) continue;
            for (int arg = 0; arg < initargs.length; ++arg) {
                if (!params[arg].isAssignableFrom(initargs[arg].getClass())) continue;
                return (T)ctor.newInstance(initargs);
            }
        }
        return (T)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static Class<?> getMappedClass(String requestedClass) throws ClassNotFoundException {
        String mappedClass = c_classMappings.get(requestedClass);
        if (mappedClass == null) {
            mappedClass = requestedClass;
        }
        return Class.forName(mappedClass);
    }

    public static boolean assignable(String srcClassName, String parentClassName) {
        try {
            Class<?> src = Class.forName(srcClassName);
            Class<?> parent = Class.forName(parentClassName);
            return parent.isAssignableFrom(src);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean exists(String className) {
        try {
            Class.forName(className, false, ClassUtil.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Map<String, String> getExtraClassMappings() {
        return c_classMappingsExtra;
    }
}

