/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.parser.markdown;

import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.toc.TocExtension;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.data.MutableDataSetter;
import java.util.Arrays;
import java.util.List;
import org.apache.oro.text.regex.Pattern;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.markdown.MarkdownForJSPWikiExtension;
import org.apache.wiki.parser.WikiDocument;

public class MarkdownDocument
extends WikiDocument {
    private static final long serialVersionUID = 1L;
    private final Node md;

    public MarkdownDocument(Page page, Node md) {
        super(page);
        this.md = md;
    }

    public Node getMarkdownNode() {
        return this.md;
    }

    public static MutableDataSet options(Context context, boolean isImageInlining, List<Pattern> inlineImagePatterns) {
        MutableDataSet options = new MutableDataSet();
        options.setFrom((MutableDataSetter)ParserEmulationProfile.COMMONMARK);
        options.set(FootnoteExtension.FOOTNOTE_LINK_REF_CLASS, (Object)"footnoteref");
        options.set(Parser.EXTENSIONS, Arrays.asList(new MarkdownForJSPWikiExtension(context, isImageInlining, inlineImagePatterns), FootnoteExtension.create(), TocExtension.create()));
        return options;
    }
}

