/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.markdown.extensions.jspwikilinks.postprocessor;

import com.vladsch.flexmark.ast.HtmlInline;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.CharSubSequence;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.markdown.nodes.JSPWikiLink;

class NodePostProcessorStateCommonOperations {
    NodePostProcessorStateCommonOperations() {
    }

    static void addContent(NodeTracker state, Node node, Node content) {
        Node previous;
        Node node2 = previous = node.getPrevious() != null ? node.getPrevious() : node.getNext();
        if (previous != null) {
            previous.insertAfter(content);
            node.unlink();
            state.nodeRemoved(node);
            content.takeChildren(node);
            state.nodeAddedWithChildren(content);
        } else {
            node.getParent().appendChild(content);
        }
    }

    static void addOutlinkImage(NodeTracker state, Node node, Context wikiContext, boolean useOutlinkImage) {
        boolean wysiwygEditorMode;
        Boolean wysiwygVariable = (Boolean)wikiContext.getVariable("WYSIWYG_EDITOR_MODE");
        boolean bl = wysiwygEditorMode = wysiwygVariable != null && wysiwygVariable != false;
        if (useOutlinkImage && !wysiwygEditorMode) {
            String m_outlinkImageURL = wikiContext.getURL(ContextEnum.PAGE_NONE.getRequestContext(), "images/out.png");
            HtmlInline img = new HtmlInline((BasedSequence)CharSubSequence.of((CharSequence)("<img class=\"outlink\" alt=\"\" src=\"" + m_outlinkImageURL + "\" />")));
            node.insertAfter((Node)img);
            state.nodeAdded((Node)img);
        }
    }

    static String inlineLinkTextOnWysiwyg(NodeTracker state, JSPWikiLink link, boolean wysiwygEditorMode) {
        String line = link.getUrl().toString();
        if (wysiwygEditorMode) {
            HtmlInline content = new HtmlInline((BasedSequence)CharSubSequence.of((CharSequence)("[" + line + "]()")));
            NodePostProcessorStateCommonOperations.addContent(state, (Node)link, (Node)content);
        }
        return line;
    }

    static void makeError(NodeTracker state, Node node, String errMsg) {
        HtmlInline error = new HtmlInline((BasedSequence)CharSubSequence.of((CharSequence)("<span class=\"error\">" + errMsg + "</span>")));
        NodePostProcessorStateCommonOperations.addContent(state, node, (Node)error);
    }
}

