/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider;

import com.vladsch.flexmark.html.AttributeProvider;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.html.Attributes;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.oro.text.regex.Pattern;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider.ExternalLinkAttributeProviderState;
import org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider.InterWikiLinkAttributeProviderState;
import org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider.LocalFootnoteLinkAttributeProviderState;
import org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider.LocalFootnoteRefLinkAttributeProviderState;
import org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider.LocalLinkAttributeProviderState;
import org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider.NodeAttributeProviderState;
import org.apache.wiki.markdown.nodes.JSPWikiLink;
import org.apache.wiki.parser.LinkParsingOperations;
import org.apache.wiki.util.TextUtil;

public class JSPWikiLinkAttributeProvider
implements AttributeProvider {
    protected final Context wikiContext;
    protected final LinkParsingOperations linkOperations;
    private final boolean isImageInlining;
    private final List<Pattern> inlineImagePatterns;

    public JSPWikiLinkAttributeProvider(Context wikiContext, boolean isImageInlining, List<Pattern> inlineImagePatterns) {
        this.wikiContext = wikiContext;
        this.linkOperations = new LinkParsingOperations(wikiContext);
        this.isImageInlining = isImageInlining;
        this.inlineImagePatterns = inlineImagePatterns;
    }

    public void setAttributes(Node node, AttributablePart part, Attributes attributes) {
        if (node instanceof JSPWikiLink) {
            JSPWikiLink link = (JSPWikiLink)node;
            NodeAttributeProviderState<JSPWikiLink> linkState = this.linkOperations.isExternalLink(link.getWikiLink()) ? new ExternalLinkAttributeProviderState(this.wikiContext, link.hasRef(), this.isImageInlining, this.inlineImagePatterns) : (this.linkOperations.isInterWikiLink(link.getWikiLink()) ? new InterWikiLinkAttributeProviderState(this.wikiContext, link.hasRef(), this.isImageInlining, this.inlineImagePatterns) : (StringUtils.startsWith((CharSequence)link.getWikiLink(), (CharSequence)"#") ? new LocalFootnoteLinkAttributeProviderState(this.wikiContext) : (TextUtil.isNumber((String)link.getWikiLink()) ? new LocalFootnoteRefLinkAttributeProviderState(this.wikiContext) : new LocalLinkAttributeProviderState(this.wikiContext, link.hasRef(), this.isImageInlining, this.inlineImagePatterns))));
            linkState.setAttributes(attributes, link);
        }
    }
}

