/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider;

import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.util.html.Attributes;
import java.util.List;
import org.apache.oro.text.regex.Pattern;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider.ImageLinkAttributeProviderState;
import org.apache.wiki.markdown.extensions.jspwikilinks.attributeprovider.NodeAttributeProviderState;
import org.apache.wiki.markdown.nodes.JSPWikiLink;
import org.apache.wiki.parser.LinkParsingOperations;
import org.apache.wiki.util.TextUtil;

public class InterWikiLinkAttributeProviderState
implements NodeAttributeProviderState<JSPWikiLink> {
    private final boolean hasRef;
    private final boolean m_wysiwygEditorMode;
    private final Context wikiContext;
    private final LinkParsingOperations linkOperations;
    private final boolean isImageInlining;
    private final List<Pattern> inlineImagePatterns;

    public InterWikiLinkAttributeProviderState(Context wikiContext, boolean hasRef, boolean isImageInlining, List<Pattern> inlineImagePatterns) {
        this.hasRef = hasRef;
        this.wikiContext = wikiContext;
        this.linkOperations = new LinkParsingOperations(wikiContext);
        this.isImageInlining = isImageInlining;
        this.inlineImagePatterns = inlineImagePatterns;
        Boolean wysiwygVariable = (Boolean)wikiContext.getVariable("WYSIWYG_EDITOR_MODE");
        this.m_wysiwygEditorMode = wysiwygVariable != null ? wysiwygVariable : false;
    }

    @Override
    public void setAttributes(Attributes attributes, JSPWikiLink link) {
        String[] refAndPage = link.getWikiLink().split(":");
        if (!this.m_wysiwygEditorMode) {
            String urlReference = this.wikiContext.getEngine().getInterWikiURL(refAndPage[0]);
            if (urlReference != null) {
                if (this.linkOperations.isImageLink(urlReference = TextUtil.replaceString((String)urlReference, (String)"%s", (String)refAndPage[1]), this.isImageInlining, this.inlineImagePatterns)) {
                    new ImageLinkAttributeProviderState(this.wikiContext, urlReference, this.hasRef).setAttributes(attributes, link);
                } else {
                    this.setInterWikiLinkAttrs(attributes, link, urlReference);
                }
            }
        } else {
            this.setInterWikiLinkAttrs(attributes, link, refAndPage[0] + ":" + refAndPage[1]);
        }
    }

    void setInterWikiLinkAttrs(Attributes attributes, Link link, String url) {
        attributes.replaceValue((CharSequence)"class", (CharSequence)"interwiki");
        attributes.replaceValue((CharSequence)"href", (CharSequence)url);
    }
}

