/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import java.util.List;
import javax.servlet.jsp.JspWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.tags.IteratorTag;

public class AttachmentsIteratorTag
extends IteratorTag {
    private static final long serialVersionUID = 0L;
    private static final Logger LOG = LogManager.getLogger(AttachmentsIteratorTag.class);

    @Override
    public final int doStartTag() {
        this.m_wikiContext = (Context)this.pageContext.getAttribute("jspwiki.context", 2);
        Engine engine = this.m_wikiContext.getEngine();
        AttachmentManager mgr = (AttachmentManager)engine.getManager(AttachmentManager.class);
        Page page = this.m_wikiContext.getPage();
        if (!mgr.attachmentsEnabled()) {
            return 0;
        }
        try {
            if (page != null && ((PageManager)engine.getManager(PageManager.class)).wikiPageExists(page)) {
                List<Attachment> atts = mgr.listAttachments(page);
                if (atts == null) {
                    LOG.debug("No attachments to display.");
                    return 0;
                }
                this.m_iterator = atts.iterator();
                if (!this.m_iterator.hasNext()) {
                    return 0;
                }
            } else {
                return 0;
            }
            Attachment att = (Attachment)this.m_iterator.next();
            Context context = this.m_wikiContext.clone();
            context.setPage((Page)att);
            this.pageContext.setAttribute("jspwiki.context", (Object)context, 2);
            this.pageContext.setAttribute(this.getId(), (Object)att);
            return 2;
        }
        catch (ProviderException e) {
            LOG.fatal("Provider failed while trying to iterator through history", (Throwable)e);
            return 0;
        }
    }

    @Override
    public final int doAfterBody() {
        if (this.bodyContent != null) {
            try {
                JspWriter out = this.getPreviousOut();
                out.print(this.bodyContent.getString());
                this.bodyContent.clearBody();
            }
            catch (IOException e) {
                LOG.error("Unable to get inner tag text", (Throwable)e);
            }
        }
        if (this.m_iterator != null && this.m_iterator.hasNext()) {
            Attachment att = (Attachment)this.m_iterator.next();
            Context context = this.m_wikiContext.clone();
            context.setPage((Page)att);
            this.pageContext.setAttribute("jspwiki.context", (Object)context, 2);
            this.pageContext.setAttribute(this.getId(), (Object)att);
            return 2;
        }
        return 0;
    }
}

