/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.permissions;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import org.apache.wiki.auth.permissions.AllPermissionCollection;
import org.apache.wiki.auth.permissions.GroupPermission;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.auth.permissions.PermissionChecks;
import org.apache.wiki.auth.permissions.WikiPermission;

public final class AllPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String WILDCARD = "*";
    private final String m_wiki;

    AllPermission() {
        this(null);
    }

    public AllPermission(String wiki) {
        super(wiki);
        this.m_wiki = wiki == null ? WILDCARD : wiki;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AllPermission)) {
            return false;
        }
        AllPermission p = (AllPermission)obj;
        return p.m_wiki != null && p.m_wiki.equals(this.m_wiki);
    }

    @Override
    public String getActions() {
        return null;
    }

    public String getWiki() {
        return this.m_wiki;
    }

    @Override
    public int hashCode() {
        return this.m_wiki.hashCode();
    }

    @Override
    public boolean implies(Permission permission) {
        if (!PermissionChecks.isJSPWikiPermission(permission)) {
            return false;
        }
        String wiki = null;
        if (permission instanceof AllPermission) {
            wiki = ((AllPermission)permission).getWiki();
        } else if (permission instanceof PagePermission) {
            wiki = ((PagePermission)permission).getWiki();
        }
        if (permission instanceof WikiPermission) {
            wiki = ((WikiPermission)permission).getWiki();
        }
        if (permission instanceof GroupPermission) {
            wiki = ((GroupPermission)permission).getWiki();
        }
        return PagePermission.isSubset(this.m_wiki, wiki);
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new AllPermissionCollection();
    }

    @Override
    public String toString() {
        return "(\"" + this.getClass().getName() + "\",\"" + this.m_wiki + "\")";
    }
}

