/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tasks.pages;

import java.io.Serializable;
import java.security.Principal;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.filters.FilterManager;
import org.apache.wiki.workflow.Outcome;
import org.apache.wiki.workflow.Task;

public class PreSaveWikiPageTask
extends Task {
    private static final long serialVersionUID = 6304715570092804615L;
    private final Context m_context;
    private final String m_proposedText;

    public PreSaveWikiPageTask(Context context, String proposedText) {
        super("task.preSaveWikiPage");
        this.m_context = context;
        this.m_proposedText = proposedText;
    }

    @Override
    public Outcome execute() throws WikiException {
        Principal wup;
        Page page = this.m_context.getPage();
        if (page.getAuthor() == null && (wup = this.m_context.getCurrentUser()) != null) {
            page.setAuthor(wup.getName());
        }
        String saveText = ((FilterManager)this.m_context.getEngine().getManager(FilterManager.class)).doPreSaveFiltering(this.m_context, this.m_proposedText);
        this.getWorkflowContext().put("fact.proposedText", (Serializable)((Object)saveText));
        return Outcome.STEP_COMPLETE;
    }
}

