/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.exceptions.NoSuchVariableException;
import org.apache.wiki.tags.WikiTagBase;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.variables.VariableManager;

public class VariableTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    private String m_var = null;
    private String m_default = null;

    @Override
    public void initTag() {
        super.initTag();
        this.m_default = null;
        this.m_var = null;
    }

    public String getVar() {
        return this.m_var;
    }

    public void setVar(String arg) {
        this.m_var = arg;
    }

    public void setDefault(String arg) {
        this.m_default = arg;
    }

    @Override
    public final int doWikiStartTag() throws JspException, IOException {
        Engine engine = this.m_wikiContext.getEngine();
        JspWriter out = this.pageContext.getOut();
        String msg = null;
        String value = null;
        try {
            value = ((VariableManager)engine.getManager(VariableManager.class)).getValue(this.m_wikiContext, this.getVar());
        }
        catch (NoSuchVariableException e) {
            msg = "No such variable: " + e.getMessage();
        }
        catch (IllegalArgumentException e) {
            msg = "Incorrect variable name: " + e.getMessage();
        }
        if (value == null) {
            value = this.m_default;
        }
        if (value == null) {
            value = msg;
        }
        out.write(TextUtil.replaceEntities((String)value));
        return 0;
    }
}

