/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.tags.WikiTagBase;

public class PageSizeTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    private static final Logger log = Logger.getLogger(PageSizeTag.class);

    @Override
    public final int doWikiStartTag() throws IOException {
        Engine engine = this.m_wikiContext.getEngine();
        Page page = this.m_wikiContext.getPage();
        try {
            if (page != null) {
                long size = page.getSize();
                if (size == -1L && ((PageManager)engine.getManager(PageManager.class)).wikiPageExists(page)) {
                    size = ((PageManager)engine.getManager(PageManager.class)).getPureText(page.getName(), page.getVersion()).length();
                    page.setSize(size);
                }
                this.pageContext.getOut().write(Long.toString(size));
            }
        }
        catch (ProviderException e) {
            log.warn((Object)"Providers did not work: ", (Throwable)e);
            this.pageContext.getOut().write("Error determining page size: " + e.getMessage());
        }
        return 0;
    }
}

