/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import java.util.List;
import javax.servlet.jsp.JspWriter;
import org.apache.log4j.Logger;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.tags.IteratorTag;

public class HistoryIteratorTag
extends IteratorTag {
    private static final long serialVersionUID = 0L;
    private static final Logger LOG = Logger.getLogger(HistoryIteratorTag.class);

    @Override
    public final int doStartTag() {
        this.m_wikiContext = (Context)this.pageContext.getAttribute("jspwiki.context", 2);
        Engine engine = this.m_wikiContext.getEngine();
        Page page = this.m_wikiContext.getPage();
        try {
            if (page != null && ((PageManager)engine.getManager(PageManager.class)).wikiPageExists(page)) {
                List versions = ((PageManager)engine.getManager(PageManager.class)).getVersionHistory(page.getName());
                if (versions == null) {
                    return 0;
                }
                this.m_iterator = versions.iterator();
                if (this.m_iterator.hasNext()) {
                    Context context = this.m_wikiContext.clone();
                    context.setPage((Page)this.m_iterator.next());
                    this.pageContext.setAttribute("jspwiki.context", (Object)context, 2);
                    this.pageContext.setAttribute(this.getId(), (Object)context.getPage());
                } else {
                    return 0;
                }
            }
            return 2;
        }
        catch (ProviderException e) {
            LOG.fatal((Object)"Provider failed while trying to iterator through history", (Throwable)e);
            return 0;
        }
    }

    @Override
    public final int doAfterBody() {
        if (this.bodyContent != null) {
            try {
                JspWriter out = this.getPreviousOut();
                out.print(this.bodyContent.getString());
                this.bodyContent.clearBody();
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to get inner tag text", (Throwable)e);
            }
        }
        if (this.m_iterator != null && this.m_iterator.hasNext()) {
            Context context = this.m_wikiContext.clone();
            context.setPage((Page)this.m_iterator.next());
            this.pageContext.setAttribute("jspwiki.context", (Object)context, 2);
            this.pageContext.setAttribute(this.getId(), (Object)context.getPage());
            return 2;
        }
        return 0;
    }
}

