/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.rss;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.log4j.Logger;
import org.apache.wiki.WatchDog;
import org.apache.wiki.WikiBackgroundThread;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.rss.RSSGenerator;
import org.apache.wiki.util.FileUtil;

public class RSSThread
extends WikiBackgroundThread {
    private static final Logger log = Logger.getLogger(RSSThread.class);
    private final File m_rssFile;
    private final RSSGenerator m_generator;
    private WatchDog m_watchdog;

    public RSSThread(Engine engine, File rssFile, int rssInterval) {
        super(engine, rssInterval);
        this.m_generator = (RSSGenerator)engine.getManager(RSSGenerator.class);
        this.m_rssFile = rssFile;
        this.setName("JSPWiki RSS Generator");
        log.debug((Object)("RSS file will be at " + this.m_rssFile.getAbsolutePath()));
        log.debug((Object)("RSS refresh interval (seconds): " + rssInterval));
    }

    @Override
    public void startupTask() {
        this.m_watchdog = WatchDog.getCurrentWatchDog(this.getEngine());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backgroundTask() throws Exception {
        if (this.m_generator.isEnabled()) {
            this.m_watchdog.enterState("Generating RSS feed", 60);
            String feed = this.m_generator.generate();
            log.debug((Object)("Regenerating RSS feed to " + this.m_rssFile));
            try (StringReader in = new StringReader(feed);
                 BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_rssFile), StandardCharsets.UTF_8));){
                FileUtil.copyContents((Reader)in, (Writer)out);
            }
            catch (IOException e) {
                log.error((Object)("Cannot generate RSS feed to " + this.m_rssFile.getAbsolutePath()), (Throwable)e);
                this.m_generator.setEnabled(false);
            }
            finally {
                this.m_watchdog.exitState();
            }
        }
    }
}

