/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.render;

import java.util.ArrayList;
import java.util.List;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.parser.PluginContent;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.render.WikiRenderer;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Text;

public class CreoleRenderer
extends WikiRenderer {
    private static final String IMG_START = "{{";
    private static final String IMG_END = "}}";
    private static final String PLUGIN_START = "<<";
    private static final String PLUGIN_END = ">>";
    private static final String HREF_START = "[[";
    private static final String HREF_DELIMITER = "|";
    private static final String HREF_END = "]]";
    private static final String PRE_START = "{{{";
    private static final String PRE_END = "}}}";
    private static final String PLUGIN_IMAGE = "Image";
    private static final String PARAM_SRC = "src";
    private static final String HREF_ATTRIBUTE = "href";
    private static final String ONE_SPACE = " ";
    private static final String EMPTY_STRING = "";
    private static final String LINEBREAK = "\n";
    private static final String LI = "li";
    private static final String UL = "ul";
    private static final String OL = "ol";
    private static final String P = "p";
    private static final String A = "a";
    private static final String PRE = "pre";
    private static final String[] ELEMENTS = new String[]{"i", "//", "//", "b", "**", "**", "h2", "== ", " ==", "h3", "=== ", " ===", "h4", "==== ", " ====", "hr", "----", "", "tt", "<<{{>>", "<<}}>>"};
    private int m_listCount = 0;
    private char m_listChar = (char)120;
    private final List<PluginContent> m_plugins = new ArrayList<PluginContent>();

    public CreoleRenderer(Context ctx, WikiDocument doc) {
        super(ctx, doc);
    }

    private void renderElement(Element ce, StringBuilder sb) {
        int i;
        String endEl = EMPTY_STRING;
        for (i = 0; i < ELEMENTS.length; i += 3) {
            if (!ELEMENTS[i].equals(ce.getName())) continue;
            sb.append(ELEMENTS[i + 1]);
            endEl = ELEMENTS[i + 2];
        }
        if (UL.equals(ce.getName())) {
            ++this.m_listCount;
            this.m_listChar = (char)42;
        } else if (OL.equals(ce.getName())) {
            ++this.m_listCount;
            this.m_listChar = (char)35;
        } else if (LI.equals(ce.getName())) {
            for (i = 0; i < this.m_listCount; ++i) {
                sb.append(this.m_listChar);
            }
            sb.append(ONE_SPACE);
        } else {
            if (A.equals(ce.getName())) {
                String text;
                String href = ce.getAttributeValue(HREF_ATTRIBUTE);
                if (href.equals(text = ce.getText())) {
                    sb.append(HREF_START).append(href).append(HREF_END);
                } else {
                    sb.append(HREF_START).append(href).append(HREF_DELIMITER).append(text).append(HREF_END);
                }
                return;
            }
            if (PRE.equals(ce.getName())) {
                sb.append(PRE_START);
                sb.append(ce.getText());
                sb.append(PRE_END);
                return;
            }
        }
        for (Content c : ce.getContent()) {
            if (c instanceof PluginContent) {
                PluginContent pc = (PluginContent)c;
                if (pc.getPluginName().equals(PLUGIN_IMAGE)) {
                    sb.append(IMG_START).append(pc.getParameter(PARAM_SRC)).append(IMG_END);
                    continue;
                }
                this.m_plugins.add(pc);
                sb.append(PLUGIN_START).append(pc.getPluginName()).append(ONE_SPACE).append(this.m_plugins.size()).append(PLUGIN_END);
                continue;
            }
            if (c instanceof Text) {
                sb.append(((Text)c).getText());
                continue;
            }
            if (!(c instanceof Element)) continue;
            this.renderElement((Element)c, sb);
        }
        if (UL.equals(ce.getName()) || OL.equals(ce.getName())) {
            --this.m_listCount;
        } else if (P.equals(ce.getName())) {
            sb.append(LINEBREAK);
        }
        sb.append(endEl);
    }

    @Override
    public String getString() {
        StringBuilder sb = new StringBuilder(1000);
        Element ce = this.m_document.getRootElement();
        this.renderElement(ce, sb);
        return sb.toString();
    }
}

