/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth.login;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.UUID;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.login.AbstractLoginModule;
import org.apache.wiki.auth.login.HttpRequestCallback;
import org.apache.wiki.auth.login.WikiEngineCallback;
import org.apache.wiki.util.FileUtil;
import org.apache.wiki.util.HttpUtil;
import org.apache.wiki.util.TextUtil;

public class CookieAuthenticationLoginModule
extends AbstractLoginModule {
    private static final Logger log = Logger.getLogger(CookieAuthenticationLoginModule.class);
    private static final String LOGIN_COOKIE_NAME = "JSPWikiUID";
    protected static final String COOKIE_DIR = "logincookies";
    public static final String PROP_LOGIN_EXPIRY_DAYS = "jspwiki.cookieAuthentication.expiry";
    private static final int DEFAULT_EXPIRY_DAYS = 14;
    private static long c_lastScrubTime = 0L;
    private static final long SCRUB_PERIOD = 3600000L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean login() throws LoginException {
        HttpRequestCallback hcb = new HttpRequestCallback();
        WikiEngineCallback wcb = new WikiEngineCallback();
        Callback[] callbacks = new Callback[]{hcb, wcb};
        try {
            this.m_handler.handle(callbacks);
            HttpServletRequest request = hcb.getRequest();
            String uid = CookieAuthenticationLoginModule.getLoginCookie(request);
            if (uid == null) return false;
            Engine engine = wcb.getEngine();
            File cookieFile = CookieAuthenticationLoginModule.getCookieFile(engine, uid);
            if (cookieFile == null) return false;
            if (!cookieFile.exists()) return false;
            if (!cookieFile.canRead()) return false;
            try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(cookieFile), StandardCharsets.UTF_8));){
                String username = FileUtil.readContents((Reader)in);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Logged in cookie authenticated name=" + username));
                }
                this.m_principals.add(new WikiPrincipal(username, "loginName"));
                boolean bl = cookieFile.setLastModified(System.currentTimeMillis());
                return bl;
            }
            catch (IOException e) {
                return false;
            }
        }
        catch (IOException e) {
            String message = "IO exception; disallowing login.";
            log.error((Object)"IO exception; disallowing login.", (Throwable)e);
            throw new LoginException("IO exception; disallowing login.");
        }
        catch (UnsupportedCallbackException e) {
            String message = "Unable to handle callback; disallowing login.";
            log.error((Object)"Unable to handle callback; disallowing login.", (Throwable)e);
            throw new LoginException("Unable to handle callback; disallowing login.");
        }
    }

    private static File getCookieFile(Engine engine, String uid) {
        File cookieDir = new File(engine.getWorkDir(), COOKIE_DIR);
        if (!cookieDir.exists()) {
            cookieDir.mkdirs();
        }
        if (!cookieDir.canRead()) {
            log.error((Object)("Cannot read from cookie directory!" + cookieDir.getAbsolutePath()));
            return null;
        }
        if (!cookieDir.canWrite()) {
            log.error((Object)("Cannot write to cookie directory!" + cookieDir.getAbsolutePath()));
            return null;
        }
        long now = System.currentTimeMillis();
        if (now > c_lastScrubTime + 3600000L) {
            CookieAuthenticationLoginModule.scrub(TextUtil.getIntegerProperty((Properties)engine.getWikiProperties(), (String)PROP_LOGIN_EXPIRY_DAYS, (int)14), cookieDir);
            c_lastScrubTime = now;
        }
        return new File(cookieDir, uid);
    }

    private static String getLoginCookie(HttpServletRequest request) {
        return HttpUtil.retrieveCookieValue((HttpServletRequest)request, (String)LOGIN_COOKIE_NAME);
    }

    public static void setLoginCookie(Engine engine, HttpServletResponse response, String username) {
        UUID uid = UUID.randomUUID();
        int days = TextUtil.getIntegerProperty((Properties)engine.getWikiProperties(), (String)PROP_LOGIN_EXPIRY_DAYS, (int)14);
        Cookie userId = CookieAuthenticationLoginModule.getLoginCookie(uid.toString());
        userId.setMaxAge(days * 24 * 60 * 60);
        response.addCookie(userId);
        File cf = CookieAuthenticationLoginModule.getCookieFile(engine, uid.toString());
        if (cf != null) {
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cf), StandardCharsets.UTF_8));){
                FileUtil.copyContents((Reader)new StringReader(username), (Writer)out);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created login cookie for user " + username + " for " + days + " days"));
                }
            }
            catch (IOException ex) {
                log.error((Object)("Unable to create cookie file to store user id: " + uid));
            }
        }
    }

    public static void clearLoginCookie(Engine engine, HttpServletRequest request, HttpServletResponse response) {
        File cf;
        Cookie userId = CookieAuthenticationLoginModule.getLoginCookie("");
        userId.setMaxAge(0);
        response.addCookie(userId);
        String uid = CookieAuthenticationLoginModule.getLoginCookie(request);
        if (uid != null && (cf = CookieAuthenticationLoginModule.getCookieFile(engine, uid)) != null && !cf.delete()) {
            log.debug((Object)("Error deleting cookie login " + uid));
        }
    }

    private static Cookie getLoginCookie(String value) {
        Cookie c = new Cookie(LOGIN_COOKIE_NAME, value);
        c.setHttpOnly(true);
        c.setSecure(true);
        return c;
    }

    private static synchronized void scrub(int days, File cookieDir) {
        log.debug((Object)"Scrubbing cookieDir...");
        File[] files = cookieDir.listFiles();
        long obsoleteDateLimit = System.currentTimeMillis() - ((long)days + 1L) * 24L * 60L * 60L * 1000L;
        int deleteCount = 0;
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            long lastModified = f.lastModified();
            if (lastModified >= obsoleteDateLimit) continue;
            if (f.delete()) {
                ++deleteCount;
                continue;
            }
            log.debug((Object)("Error deleting cookie login with index " + i));
        }
        log.debug((Object)("Removed " + deleteCount + " obsolete cookie logins"));
    }
}

