/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.auth;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.wiki.api.core.Acl;
import org.apache.wiki.api.core.AclEntry;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.Authorizer;
import org.apache.wiki.auth.NoSuchPrincipalException;
import org.apache.wiki.auth.UserManager;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.acl.AclManager;
import org.apache.wiki.auth.acl.UnresolvedPrincipal;
import org.apache.wiki.auth.authorize.GroupManager;
import org.apache.wiki.auth.authorize.Role;
import org.apache.wiki.auth.permissions.AllPermission;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.auth.user.UserDatabase;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.util.ClassUtil;
import org.freshcookies.security.policy.LocalPolicy;

public class DefaultAuthorizationManager
implements AuthorizationManager {
    private static final Logger log = Logger.getLogger(DefaultAuthorizationManager.class);
    private Authorizer m_authorizer = null;
    private Map<Principal, ProtectionDomain> m_cachedPds = new WeakHashMap<Principal, ProtectionDomain>();
    private Engine m_engine = null;
    private LocalPolicy m_localPolicy = null;

    @Override
    public boolean checkPermission(Session session, Permission permission) {
        Acl acl;
        if (session == null || permission == null) {
            this.fireEvent(52, null, permission);
            return false;
        }
        Principal user = session.getLoginPrincipal();
        AllPermission allPermission = new AllPermission(this.m_engine.getApplicationName());
        boolean hasAllPermission = this.checkStaticPermission(session, allPermission);
        if (hasAllPermission) {
            this.fireEvent(51, user, permission);
            return true;
        }
        boolean hasPolicyPermission = this.checkStaticPermission(session, permission);
        if (!hasPolicyPermission) {
            this.fireEvent(52, user, permission);
            return false;
        }
        if (!(permission instanceof PagePermission)) {
            this.fireEvent(51, user, permission);
            return true;
        }
        String pageName = ((PagePermission)permission).getPage();
        Page page = ((PageManager)this.m_engine.getManager(PageManager.class)).getPage(pageName);
        Acl acl2 = acl = page == null ? null : ((AclManager)this.m_engine.getManager(AclManager.class)).getPermissions(page);
        if (page == null || acl == null || acl.isEmpty()) {
            this.fireEvent(51, user, permission);
            return true;
        }
        Object[] aclPrincipals = acl.findPrincipals(permission);
        log.debug((Object)"Checking ACL entries...");
        log.debug((Object)("Acl for this page is: " + acl));
        log.debug((Object)("Checking for principal: " + Arrays.toString(aclPrincipals)));
        log.debug((Object)("Permission: " + permission));
        for (Object aclPrincipal : aclPrincipals) {
            if (aclPrincipal instanceof UnresolvedPrincipal) {
                AclEntry aclEntry = acl.getAclEntry((Principal)aclPrincipal);
                aclPrincipal = this.resolvePrincipal(aclPrincipal.getName());
                if (aclEntry != null && !(aclPrincipal instanceof UnresolvedPrincipal)) {
                    aclEntry.setPrincipal((Principal)aclPrincipal);
                }
            }
            if (!this.hasRoleOrPrincipal(session, (Principal)aclPrincipal)) continue;
            this.fireEvent(51, user, permission);
            return true;
        }
        this.fireEvent(52, user, permission);
        return false;
    }

    @Override
    public Authorizer getAuthorizer() throws WikiSecurityException {
        if (this.m_authorizer != null) {
            return this.m_authorizer;
        }
        throw new WikiSecurityException("Authorizer did not initialize properly. Check the logs.");
    }

    @Override
    public boolean hasRoleOrPrincipal(Session session, Principal principal) {
        if (session == null || principal == null) {
            return false;
        }
        if (AuthenticationManager.isRolePrincipal(principal)) {
            return this.isUserInRole(session, principal);
        }
        if (session.isAuthenticated() && AuthenticationManager.isUserPrincipal(principal)) {
            Principal[] userPrincipals;
            String principalName = principal.getName();
            for (Principal userPrincipal : userPrincipals = session.getPrincipals()) {
                if (!userPrincipal.getName().equals(principalName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasAccess(Context context, HttpServletResponse response, boolean redirect) throws IOException {
        boolean allowed = this.checkPermission(context.getWikiSession(), context.requiredPermission());
        ResourceBundle rb = Preferences.getBundle(context, "CoreResources");
        if (context.getHttpRequest() != null && context.getHttpRequest().getAttribute("jspwiki.context") == null) {
            context.getHttpRequest().setAttribute("jspwiki.context", (Object)context);
        }
        if (!allowed && redirect) {
            Principal currentUser = context.getWikiSession().getUserPrincipal();
            String pageurl = context.getPage().getName();
            if (context.getWikiSession().isAuthenticated()) {
                log.info((Object)("User " + currentUser.getName() + " has no access - forbidden (permission=" + context.requiredPermission() + ")"));
                context.getWikiSession().addMessage(MessageFormat.format(rb.getString("security.error.noaccess.logged"), context.getName()));
            } else {
                log.info((Object)("User " + currentUser.getName() + " has no access - redirecting (permission=" + context.requiredPermission() + ")"));
                context.getWikiSession().addMessage(MessageFormat.format(rb.getString("security.error.noaccess"), context.getName()));
            }
            response.sendRedirect(this.m_engine.getURL(ContextEnum.WIKI_LOGIN.getRequestContext(), pageurl, null));
        }
        return allowed;
    }

    public void initialize(Engine engine, Properties properties) throws WikiException {
        this.m_engine = engine;
        this.m_authorizer = this.getAuthorizerImplementation(properties);
        this.m_authorizer.initialize(engine, properties);
        try {
            String policyFileName = properties.getProperty("jspwiki.policy.file", "jspwiki.policy");
            URL policyURL = engine.findConfigFile(policyFileName);
            if (policyURL == null) {
                String sb = "JSPWiki was unable to initialize the default security policy (WEB-INF/jspwiki.policy) file. Please ensure that the jspwiki.policy file exists in the default location. This file should exist regardless of the existance of a global policy file. The global policy file is identified by the java.security.policy variable. ";
                WikiSecurityException wse = new WikiSecurityException("JSPWiki was unable to initialize the default security policy (WEB-INF/jspwiki.policy) file. Please ensure that the jspwiki.policy file exists in the default location. This file should exist regardless of the existance of a global policy file. The global policy file is identified by the java.security.policy variable. ");
                log.fatal((Object)"JSPWiki was unable to initialize the default security policy (WEB-INF/jspwiki.policy) file. Please ensure that the jspwiki.policy file exists in the default location. This file should exist regardless of the existance of a global policy file. The global policy file is identified by the java.security.policy variable. ", (Throwable)((Object)wse));
                throw wse;
            }
            File policyFile = new File(policyURL.toURI().getPath());
            log.info((Object)("We found security policy URL: " + policyURL + " and transformed it to file " + policyFile.getAbsolutePath()));
            this.m_localPolicy = new LocalPolicy(policyFile, engine.getContentEncoding().displayName());
            this.m_localPolicy.refresh();
            log.info((Object)("Initialized default security policy: " + policyFile.getAbsolutePath()));
        }
        catch (Exception e) {
            log.error((Object)("Could not initialize local security policy: " + e.getMessage()));
            throw new WikiException("Could not initialize local security policy: " + e.getMessage(), (Throwable)e);
        }
    }

    private Authorizer getAuthorizerImplementation(Properties props) throws WikiException {
        String authClassName = props.getProperty("jspwiki.authorizer", "org.apache.wiki.auth.authorize.WebContainerAuthorizer");
        return (Authorizer)this.locateImplementation(authClassName);
    }

    private Object locateImplementation(String clazz) throws WikiException {
        if (clazz != null) {
            try {
                Class authClass = ClassUtil.findClass((String)"org.apache.wiki.auth.authorize", (String)clazz);
                return authClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                log.fatal((Object)("Authorizer " + clazz + " cannot be found"), (Throwable)e);
                throw new WikiException("Authorizer " + clazz + " cannot be found", (Throwable)e);
            }
            catch (InstantiationException e) {
                log.fatal((Object)("Authorizer " + clazz + " cannot be created"), (Throwable)e);
                throw new WikiException("Authorizer " + clazz + " cannot be created", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.fatal((Object)"You are not allowed to access this authorizer class", (Throwable)e);
                throw new WikiException("You are not allowed to access this authorizer class", (Throwable)e);
            }
        }
        throw new NoRequiredPropertyException("Unable to find a jspwiki.authorizer entry in the properties.", "jspwiki.authorizer");
    }

    @Override
    public boolean allowedByLocalPolicy(Principal[] principals, Permission permission) {
        for (Principal principal : principals) {
            ProtectionDomain pd = this.m_cachedPds.get(principal);
            if (pd == null) {
                ClassLoader cl = this.getClass().getClassLoader();
                CodeSource cs = new CodeSource(null, (Certificate[])null);
                pd = new ProtectionDomain(cs, null, cl, new Principal[]{principal});
                this.m_cachedPds.put(principal, pd);
            }
            if (!this.m_localPolicy.implies(pd, permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkStaticPermission(Session session, Permission permission) {
        return (Boolean)Session.doPrivileged((Session)session, () -> {
            try {
                AccessController.checkPermission(permission);
                return Boolean.TRUE;
            }
            catch (AccessControlException accessControlException) {
                if (this.allowedByLocalPolicy(session.getRoles(), permission) || this.allowedByLocalPolicy(session.getPrincipals(), permission)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
    }

    @Override
    public Principal resolvePrincipal(String name) {
        Role role = new Role(name);
        if (Role.isBuiltInRole(role)) {
            return role;
        }
        Principal principal = this.m_authorizer.findRole(name);
        if (principal != null) {
            return principal;
        }
        principal = ((GroupManager)this.m_engine.getManager(GroupManager.class)).findRole(name);
        if (principal != null) {
            return principal;
        }
        UserDatabase db = ((UserManager)this.m_engine.getManager(UserManager.class)).getUserDatabase();
        try {
            Principal[] principals;
            UserProfile profile = db.find(name);
            for (Principal value : principals = db.getPrincipals(profile.getLoginName())) {
                principal = value;
                if (!principal.getName().equals(name)) continue;
                return principal;
            }
        }
        catch (NoSuchPrincipalException noSuchPrincipalException) {
            // empty catch block
        }
        return new UnresolvedPrincipal(name);
    }

    @Override
    public synchronized void addWikiEventListener(WikiEventListener listener) {
        WikiEventManager.addWikiEventListener((Object)this, (WikiEventListener)listener);
    }

    @Override
    public synchronized void removeWikiEventListener(WikiEventListener listener) {
        WikiEventManager.removeWikiEventListener((Object)this, (WikiEventListener)listener);
    }
}

