/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.providers.AttachmentProvider;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.attachment.DynamicAttachment;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.references.ReferenceManager;
import org.apache.wiki.search.SearchManager;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.TextUtil;

public class DefaultAttachmentManager
implements AttachmentManager {
    private String[] m_forceDownloadPatterns;
    private static final Logger log = Logger.getLogger(DefaultAttachmentManager.class);
    private AttachmentProvider m_provider;
    private Engine m_engine;
    private CacheManager m_cacheManager = CacheManager.getInstance();
    private Cache m_dynamicAttachments;

    public DefaultAttachmentManager(Engine engine, Properties props) {
        this.m_engine = engine;
        boolean useCache = "true".equals(props.getProperty("jspwiki.usePageCache"));
        String classname = useCache ? "org.apache.wiki.providers.CachingAttachmentProvider" : props.getProperty("jspwiki.attachmentProvider");
        if (classname == null) {
            log.info((Object)"No attachment provider defined - disabling attachment support.");
            return;
        }
        String cacheName = engine.getApplicationName() + "." + "jspwiki.dynamicAttachmentCache";
        try {
            if (this.m_cacheManager.cacheExists(cacheName)) {
                this.m_dynamicAttachments = this.m_cacheManager.getCache(cacheName);
            } else {
                log.info((Object)("cache with name " + cacheName + " not found in ehcache.xml, creating it with defaults."));
                this.m_dynamicAttachments = new Cache(cacheName, 1000, false, false, 0L, 0L);
                this.m_cacheManager.addCache(this.m_dynamicAttachments);
            }
            Class providerclass = ClassUtil.findClass((String)"org.apache.wiki.providers", (String)classname);
            this.m_provider = (AttachmentProvider)providerclass.newInstance();
            this.m_provider.initialize(this.m_engine, props);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Attachment provider class not found", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)"Attachment provider could not be created", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"You may not access the attachment provider class", (Throwable)e);
        }
        catch (NoRequiredPropertyException e) {
            log.error((Object)("Attachment provider did not find a property that it needed: " + e.getMessage()), (Throwable)e);
            this.m_provider = null;
        }
        catch (IOException e) {
            log.error((Object)"Attachment provider reports IO error", (Throwable)e);
            this.m_provider = null;
        }
        String forceDownload = TextUtil.getStringProperty((Properties)props, (String)"jspwiki.attachment.forceDownload", null);
        this.m_forceDownloadPatterns = forceDownload != null && forceDownload.length() > 0 ? forceDownload.toLowerCase().split("\\s") : new String[0];
    }

    @Override
    public boolean attachmentsEnabled() {
        return this.m_provider != null;
    }

    @Override
    public String getAttachmentInfoName(Context context, String attachmentname) {
        Attachment att;
        try {
            att = this.getAttachmentInfo(context, attachmentname);
        }
        catch (ProviderException e) {
            log.warn((Object)"Finding attachments failed: ", (Throwable)e);
            return null;
        }
        if (att != null) {
            return att.getName();
        }
        if (attachmentname.indexOf(47) != -1) {
            return attachmentname;
        }
        return null;
    }

    @Override
    public Attachment getAttachmentInfo(Context context, String attachmentname, int version) throws ProviderException {
        int cutpt;
        if (this.m_provider == null) {
            return null;
        }
        Page currentPage = null;
        if (context != null) {
            currentPage = context.getPage();
        }
        if ((cutpt = attachmentname.lastIndexOf(47)) != -1) {
            String parentPage = attachmentname.substring(0, cutpt);
            parentPage = MarkupParser.cleanLink(parentPage);
            attachmentname = attachmentname.substring(cutpt + 1);
            if (parentPage.length() == 0) {
                return null;
            }
            currentPage = ((PageManager)this.m_engine.getManager(PageManager.class)).getPage(parentPage);
            if (currentPage == null) {
                currentPage = ((PageManager)this.m_engine.getManager(PageManager.class)).getPage(MarkupParser.wikifyLink(parentPage));
            }
        }
        if (currentPage == null || currentPage.getName().length() == 0) {
            return null;
        }
        DynamicAttachment att = this.getDynamicAttachment(currentPage.getName() + "/" + attachmentname);
        if (att == null) {
            att = this.m_provider.getAttachmentInfo(currentPage, attachmentname, version);
        }
        return att;
    }

    @Override
    public List<Attachment> listAttachments(Page wikipage) throws ProviderException {
        if (this.m_provider == null) {
            return new ArrayList<Attachment>();
        }
        ArrayList<Attachment> atts = new ArrayList<Attachment>(this.m_provider.listAttachments(wikipage));
        atts.sort(Comparator.comparing(Page::getName, ((PageManager)this.m_engine.getManager(PageManager.class)).getPageSorter()));
        return atts;
    }

    @Override
    public boolean forceDownload(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if ((name = name.toLowerCase()).indexOf(46) == -1) {
            return true;
        }
        for (String forceDownloadPattern : this.m_forceDownloadPatterns) {
            if (!name.endsWith(forceDownloadPattern) || forceDownloadPattern.length() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public InputStream getAttachmentStream(Context ctx, Attachment att) throws ProviderException, IOException {
        if (this.m_provider == null) {
            return null;
        }
        if (att instanceof DynamicAttachment) {
            return ((DynamicAttachment)att).getProvider().getAttachmentData(ctx, att);
        }
        return this.m_provider.getAttachmentData(att);
    }

    @Override
    public void storeDynamicAttachment(Context ctx, DynamicAttachment att) {
        this.m_dynamicAttachments.put(new Element((Object)att.getName(), (Object)att));
    }

    @Override
    public DynamicAttachment getDynamicAttachment(String name) {
        Element element = this.m_dynamicAttachments.get((Serializable)((Object)name));
        if (element != null) {
            return (DynamicAttachment)element.getObjectValue();
        }
        this.m_dynamicAttachments.put(new Element((Serializable)((Object)name), null));
        return null;
    }

    @Override
    public void storeAttachment(Attachment att, InputStream in) throws IOException, ProviderException {
        if (this.m_provider == null) {
            return;
        }
        if (!((PageManager)this.m_engine.getManager(PageManager.class)).pageExists(att.getParentName())) {
            throw new ProviderException("attach.parent.not.exist");
        }
        this.m_provider.putAttachmentData(att, in);
        ((ReferenceManager)this.m_engine.getManager(ReferenceManager.class)).updateReferences(att.getName(), new ArrayList<String>());
        Page parent = Wiki.contents().page(this.m_engine, att.getParentName());
        ((ReferenceManager)this.m_engine.getManager(ReferenceManager.class)).updateReferences(parent);
        ((SearchManager)this.m_engine.getManager(SearchManager.class)).reindexPage((Page)att);
    }

    @Override
    public List<Attachment> getVersionHistory(String attachmentName) throws ProviderException {
        if (this.m_provider == null) {
            return null;
        }
        Attachment att = this.getAttachmentInfo(null, attachmentName);
        if (att != null) {
            return this.m_provider.getVersionHistory(att);
        }
        return null;
    }

    @Override
    public Collection<Attachment> getAllAttachments() throws ProviderException {
        if (this.attachmentsEnabled()) {
            return this.m_provider.listAllChanged(new Date(0L));
        }
        return new ArrayList<Attachment>();
    }

    @Override
    public AttachmentProvider getCurrentProvider() {
        return this.m_provider;
    }

    @Override
    public void deleteVersion(Attachment att) throws ProviderException {
        if (this.m_provider == null) {
            return;
        }
        this.m_provider.deleteVersion(att);
    }

    @Override
    public void deleteAttachment(Attachment att) throws ProviderException {
        if (this.m_provider == null) {
            return;
        }
        this.m_provider.deleteAttachment(att);
        ((SearchManager)this.m_engine.getManager(SearchManager.class)).pageRemoved((Page)att);
        ((ReferenceManager)this.m_engine.getManager(ReferenceManager.class)).clearPageEntries(att.getName());
    }
}

