/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.web;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.wiki.HsqlDbUtils;
import org.eclipse.jetty.jndi.InitialContextFactory;
import org.eclipse.jetty.jndi.NamingContext;
import org.eclipse.jetty.plus.jndi.Resource;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.webapp.WebAppContext;
import org.hsqldb.jdbc.JDBCDataSource;

public class TestContainer {
    private final Server server;
    public static final int HTTP_PORT = 10024;
    public static final String SHUTDOWN_CMD = "/GO_AWAY";
    public static final String INITIAL_CONTEXT_FACTORY = "java.naming.factory.initial";
    public static final String INITIAL_CONTEXT_FACTORY_JETTY = "org.eclipse.jetty.jndi.InitialContextFactory";
    public static final String JNDI_ENV_ROOT = "java:comp/env";
    private static HsqlDbUtils m_hu = new HsqlDbUtils();
    private static final Logger log = Logger.getLogger(TestContainer.class);
    private static Context initCtx;
    private static Resource userDB;
    private static Resource groupDB;
    private static ContextHandlerCollection handlerCollection;

    public static void main(String[] args) throws Exception {
        Map<String, String> apps = TestContainer.extractApps(args);
        if (apps.size() == 0) {
            throw new IllegalArgumentException("No apps supplied!");
        }
        TestContainer container = new TestContainer();
        for (Map.Entry<String, String> app : apps.entrySet()) {
            String context = app.getKey();
            String path = app.getValue();
            log.error((Object)("Adding context " + context + " at path " + path));
            container.addWebApp(context, path);
        }
        handlerCollection.addHandler((Handler)new DefaultHandler());
        m_hu.setUp();
        JDBCDataSource cpds = new JDBCDataSource();
        cpds.setDatabase("jdbc:hsqldb:hsql://localhost/jspwiki");
        cpds.setLoginTimeout(10);
        cpds.setUser("SA");
        cpds.setPassword(null);
        userDB = new Resource("jdbc/UserDatabase", (Object)cpds);
        log.error((Object)("Configured datasource " + userDB));
        userDB.bindToENC("jdbc/UserDatabase");
        groupDB = new Resource("jdbc/GroupDatabase", (Object)cpds);
        log.error((Object)("Configured datasource " + groupDB));
        userDB.bindToENC("jdbc/GroupDatabase");
        try {
            log.error((Object)"Starting up test container.");
            container.server.setHandler((Handler)handlerCollection);
            Handler[] currentHandlers = container.server.getHandlers();
            log.error((Object)"dumping current handlers");
            for (Handler handler : currentHandlers) {
                Handler[] collection;
                if (!(handler instanceof HandlerCollection)) continue;
                for (Handler h : collection = ((HandlerCollection)handler).getHandlers()) {
                    log.error((Object)("handler: " + h));
                }
            }
            container.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            System.exit(1);
        }
    }

    private static Map<String, String> extractApps(String[] args) {
        HashMap<String, String> apps = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String path;
            File file;
            String[] pair = args[i].split("=");
            if (pair.length != 2) {
                throw new IllegalArgumentException("Malformed argument '" + args[i] + "'; expected 'context=path' pattern.");
            }
            String context = pair[0].trim();
            if (!context.startsWith("/")) {
                context = "/" + context;
            }
            if (!(file = new File(path = pair[1].trim())).exists()) {
                throw new IllegalArgumentException("Path " + path + " does not exist.");
            }
            if (!file.isDirectory()) {
                throw new IllegalArgumentException("Path " + path + " cannot be a file; it must be a directory.");
            }
            apps.put(context, path);
        }
        return apps;
    }

    public TestContainer() throws Exception {
        String contextFactoryClass = System.getProperty(INITIAL_CONTEXT_FACTORY);
        if (contextFactoryClass == null) {
            System.setProperty(INITIAL_CONTEXT_FACTORY, INITIAL_CONTEXT_FACTORY_JETTY);
            log.error((Object)"No JNDI context factory found; using org.eclipse.jndi.InitialContextFactory.");
            contextFactoryClass = INITIAL_CONTEXT_FACTORY_JETTY;
        }
        log.error((Object)("Initialized JNDI with context factory class=" + contextFactoryClass + "."));
        initCtx = new InitialContext();
        try {
            initCtx.lookup(JNDI_ENV_ROOT);
        }
        catch (NameNotFoundException e) {
            initCtx.bind(JNDI_ENV_ROOT, (Object)new NamingContext(new Hashtable(), JNDI_ENV_ROOT, null, (NameParser)new InitialContextFactory.DefaultParser()));
            log.error((Object)"No JNDI java:comp/env namespace found; creating it,");
        }
        log.info((Object)("Initialized JNDI java:comp/env namespace.=" + contextFactoryClass));
        log.info((Object)"Creating new test container.");
        System.setProperty("org.eclipse.xml.XmlParser.NotValidating", "true");
        this.server = new Server();
        this.server.setStopAtShutdown(true);
        SocketConnector connector = new SocketConnector();
        connector.setHost("localhost");
        connector.setPort(10024);
        connector.setMaxIdleTime(60000);
        this.server.setConnectors(new Connector[]{connector});
        log.info((Object)"added HTTP listener for port 10024");
        ContextHandler shutDownContextHandler = new ContextHandler(SHUTDOWN_CMD);
        shutDownContextHandler.setHandler((Handler)new ShutdownHandler());
        handlerCollection.addHandler((Handler)shutDownContextHandler);
    }

    public void addWebApp(String context, String path) throws IOException {
        HashLoginService loginService = new HashLoginService("JSPWikiRealm");
        loginService.putUser("admin", (Credential)new Password("myP@5sw0rd"), new String[]{"Authenticated", "Admin"});
        loginService.putUser("janne", (Credential)new Password("myP@5sw0rd"), new String[]{"Authenticated"});
        WebAppContext webAppContext = new WebAppContext(path, context);
        ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
        csh.setLoginService((LoginService)loginService);
        webAppContext.setSecurityHandler((SecurityHandler)csh);
        log.error((Object)("Adding webapp " + context + " for path " + path));
        handlerCollection.addHandler((Handler)webAppContext);
    }

    public void start() throws Exception {
        System.setProperty("org.eclipse.http.HttpRequest.maxFormContentSize", "0");
        this.server.start();
        log.error((Object)"jetty server started");
    }

    public void stop() {
        try {
            this.server.stop();
            log.error((Object)"jetty server stopped");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        userDB = null;
        groupDB = null;
        handlerCollection = new ContextHandlerCollection();
    }

    public static final class ShutdownHandler
    extends AbstractHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (request.getRequestURI().indexOf(TestContainer.SHUTDOWN_CMD) != -1) {
                log.error((Object)"stop cmd received, shutting down server");
                System.exit(0);
            } else {
                log.error((Object)("ignoring request " + request.getRequestURI()));
            }
        }
    }
}

