/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class TestJDBCDataSource
implements DataSource {
    private static Driver m_driver;
    protected static final String PROPERTY_DRIVER_CLASS = "jdbc.driver.class";
    protected static final String PROPERTY_DRIVER_JAR = "jdbc.driver.jar";
    protected static final String PROPERTY_DRIVER_URL = "jdbc.driver.url";
    protected static final String PROPERTY_USER_ID = "jdbc.user.id";
    protected static final String PROPERTY_USER_PASSWORD = "jdbc.user.password";
    protected String m_jdbcPassword = null;
    protected String m_jdbcURL = null;
    protected String m_jdbcUser = null;
    protected int m_timeout = 0;
    protected PrintWriter m_writer = null;

    public TestJDBCDataSource(File file) throws Exception {
        this.initializeJDBC(file);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.m_jdbcUser, this.m_jdbcPassword);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties connProperties = new Properties();
        connProperties.put("user", this.m_jdbcUser);
        connProperties.put("password", this.m_jdbcPassword);
        Connection connection = m_driver.connect(this.m_jdbcURL, connProperties);
        return connection;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.m_timeout;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.m_writer;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_timeout = seconds;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.m_writer = out;
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    protected void initializeJDBC(File file) throws Exception {
        Properties properties = new Properties();
        FileInputStream is = new FileInputStream(file);
        properties.load(is);
        is.close();
        this.m_jdbcURL = properties.getProperty(PROPERTY_DRIVER_URL);
        this.m_jdbcUser = properties.getProperty(PROPERTY_USER_ID);
        this.m_jdbcPassword = properties.getProperty(PROPERTY_USER_PASSWORD);
        String clazz = properties.getProperty(PROPERTY_DRIVER_CLASS);
        String driverFile = properties.getProperty(PROPERTY_DRIVER_JAR);
        final URL driverURL = new URL("file:" + driverFile);
        final ClassLoader parent = ClassLoader.getSystemClassLoader();
        URLClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(new URL[]{driverURL}, parent);
            }
        });
        Class<?> driverClass = loader.loadClass(clazz);
        m_driver = (Driver)driverClass.newInstance();
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }
}

