/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.hsqldb.Server;
import org.hsqldb.cmdline.SqlFile;

public class HsqlDbUtils {
    private static final Logger LOG = Logger.getLogger(HsqlDbUtils.class);
    Server hsqlServer = null;

    public void setUp() {
        try {
            this.start();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        this.exec("src/test/config/hsql-userdb-setup.ddl");
    }

    public void tearDown() {
        this.exec("src/test/config/hsql-userdb-teardown.ddl");
        this.shutdown();
    }

    public void start() throws Exception {
        Properties hProps = this.loadPropertiesFrom("target/test-classes/jspwiki-custom.properties");
        this.hsqlServer = new Server();
        this.hsqlServer.setSilent(true);
        this.hsqlServer.setLogWriter(null);
        this.hsqlServer.checkRunning(false);
        this.hsqlServer.setPort(Integer.valueOf(hProps.getProperty("server.port")).intValue());
        this.hsqlServer.setDatabaseName(0, hProps.getProperty("server.dbname.0"));
        this.hsqlServer.setDatabasePath(0, hProps.getProperty("server.database.0"));
        this.hsqlServer.start();
        Class.forName("org.hsqldb.jdbc.JDBCDriver");
        this.hsqlServer.checkRunning(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(String file) {
        Connection conn = null;
        try {
            conn = this.getConnection();
            SqlFile userDbSetup = new SqlFile(new File(file));
            userDbSetup.setConnection(conn);
            userDbSetup.execute();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.close(conn);
        }
    }

    public void shutdown() {
        LOG.info((Object)"Shutting down Hypersonic JDBC server on localhost.");
        if (this.hsqlServer != null) {
            Connection conn = null;
            try {
                conn = this.getConnection();
                conn.setAutoCommit(true);
                conn.prepareStatement("SHUTDOWN").execute();
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                this.close(conn);
            }
            this.hsqlServer.shutdown();
        }
    }

    Connection getConnection() throws IOException, SQLException {
        Properties jProps = this.loadPropertiesFrom("target/test-classes/jspwiki-custom.properties");
        Connection conn = DriverManager.getConnection(jProps.getProperty("jdbc.driver.url"), jProps.getProperty("jdbc.admin.id"), jProps.getProperty("jdbc.admin.password"));
        return conn;
    }

    void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                conn = null;
            }
        }
    }

    Properties loadPropertiesFrom(String fileLocation) throws IOException {
        Properties p = new Properties();
        BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(fileLocation));
        p.load(inStream);
        ((InputStream)inStream).close();
        return p;
    }
}

