/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.event;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;

public final class WikiEventManager {
    private static final Logger log = Logger.getLogger(WikiEventManager.class);
    private static boolean c_permitMonitor = false;
    private static WikiEventListener c_monitor = null;
    private final Map<Object, WikiEventDelegate> m_delegates = new HashMap<Object, WikiEventDelegate>();
    private final Vector<WikiEventDelegate> m_preloadCache = new Vector();
    private static WikiEventManager c_instance = null;

    private WikiEventManager() {
        c_instance = this;
        log.debug((Object)"instantiated WikiEventManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WikiEventManager getInstance() {
        if (c_instance == null) {
            Class<WikiEventManager> clazz = WikiEventManager.class;
            synchronized (WikiEventManager.class) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return new WikiEventManager();
            }
        }
        return c_instance;
    }

    public static boolean addWikiEventListener(Object client, WikiEventListener listener) {
        if (client == WikiEventManager.class) {
            if (c_permitMonitor) {
                c_monitor = listener;
            }
            return c_permitMonitor;
        }
        WikiEventDelegate delegate = WikiEventManager.getInstance().getDelegateFor(client);
        return delegate.addWikiEventListener(listener);
    }

    public static boolean removeWikiEventListener(Object client, WikiEventListener listener) {
        if (client == WikiEventManager.class) {
            c_monitor = null;
            return true;
        }
        WikiEventDelegate delegate = WikiEventManager.getInstance().getDelegateFor(client);
        return delegate.removeWikiEventListener(listener);
    }

    public static Set<WikiEventListener> getWikiEventListeners(Object client) throws UnsupportedOperationException {
        WikiEventDelegate delegate = WikiEventManager.getInstance().getDelegateFor(client);
        return delegate.getWikiEventListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeWikiEventListener(WikiEventListener listener) {
        Map<Object, WikiEventDelegate> sources;
        boolean removed = false;
        WikiEventManager mgr = WikiEventManager.getInstance();
        Map<Object, WikiEventDelegate> map = sources = Collections.synchronizedMap(mgr.getDelegates());
        synchronized (map) {
            for (Map.Entry<Object, WikiEventDelegate> entry : sources.entrySet()) {
                WikiEventDelegate delegate = entry.getValue();
                if (delegate == null || !delegate.removeWikiEventListener(listener)) continue;
                removed = true;
            }
        }
        return removed;
    }

    public static boolean isListening(Object client) {
        return WikiEventManager.getInstance().getDelegateFor(client).isListening();
    }

    public static void fireEvent(Object client, WikiEvent event) {
        WikiEventDelegate source = WikiEventManager.getInstance().getDelegateFor(client);
        source.fireEvent(event);
        if (c_monitor != null) {
            c_monitor.actionPerformed(event);
        }
    }

    private Map<Object, WikiEventDelegate> getDelegates() {
        return this.m_delegates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WikiEventDelegate getDelegateFor(Object client) {
        Map<Object, WikiEventDelegate> map = this.m_delegates;
        synchronized (map) {
            WikiEventDelegate delegate;
            if (client == null || client instanceof Class) {
                WikiEventDelegate delegate2 = new WikiEventDelegate(client);
                this.m_preloadCache.add(delegate2);
                this.m_delegates.put(client, delegate2);
                return delegate2;
            }
            if (!this.m_preloadCache.isEmpty()) {
                for (int i = this.m_preloadCache.size() - 1; i >= 0; --i) {
                    WikiEventDelegate delegate3 = this.m_preloadCache.elementAt(i);
                    if (delegate3.getClientClass() != null && !delegate3.getClientClass().equals(client.getClass()) || this.m_delegates.containsKey(client)) continue;
                    this.m_preloadCache.remove(delegate3);
                    this.m_delegates.put(client, delegate3);
                    return delegate3;
                }
            }
            if ((delegate = this.m_delegates.get(client)) == null) {
                delegate = new WikiEventDelegate(client);
                this.m_delegates.put(client, delegate);
            }
            return delegate;
        }
    }

    private static class WikiEventListenerComparator
    implements Comparator<WikiEventListener> {
        private WikiEventListenerComparator() {
        }

        @Override
        public int compare(WikiEventListener w0, WikiEventListener w1) {
            if (w1 == w0 || w0.equals(w1)) {
                return 0;
            }
            return w1.hashCode() - w0.hashCode();
        }
    }

    private static final class WikiEventDelegate {
        private final ArrayList<WeakReference<WikiEventListener>> m_listenerList = new ArrayList();
        private Class<?> m_class = null;

        protected WikiEventDelegate(Object client) {
            if (client instanceof Class) {
                this.m_class = (Class)client;
            }
        }

        protected Class<?> getClientClass() {
            return this.m_class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<WikiEventListener> getWikiEventListeners() {
            ArrayList<WeakReference<WikiEventListener>> arrayList = this.m_listenerList;
            synchronized (arrayList) {
                TreeSet<WikiEventListener> set = new TreeSet<WikiEventListener>(new WikiEventListenerComparator());
                for (WeakReference<WikiEventListener> wikiEventListenerWeakReference : this.m_listenerList) {
                    WikiEventListener l = (WikiEventListener)wikiEventListenerWeakReference.get();
                    if (l == null) continue;
                    set.add(l);
                }
                return Collections.unmodifiableSet(set);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addWikiEventListener(WikiEventListener listener) {
            ArrayList<WeakReference<WikiEventListener>> arrayList = this.m_listenerList;
            synchronized (arrayList) {
                boolean listenerAlreadyContained = this.m_listenerList.stream().map(Reference::get).anyMatch(ref -> ref == listener);
                if (!listenerAlreadyContained) {
                    return this.m_listenerList.add(new WeakReference<WikiEventListener>(listener));
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeWikiEventListener(WikiEventListener listener) {
            ArrayList<WeakReference<WikiEventListener>> arrayList = this.m_listenerList;
            synchronized (arrayList) {
                Iterator<WeakReference<WikiEventListener>> i = this.m_listenerList.iterator();
                while (i.hasNext()) {
                    WikiEventListener l = (WikiEventListener)i.next().get();
                    if (l != listener) continue;
                    i.remove();
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isListening() {
            ArrayList<WeakReference<WikiEventListener>> arrayList = this.m_listenerList;
            synchronized (arrayList) {
                return !this.m_listenerList.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireEvent(WikiEvent event) {
            boolean needsCleanup = false;
            try {
                ArrayList<WeakReference<WikiEventListener>> arrayList = this.m_listenerList;
                synchronized (arrayList) {
                    for (WeakReference<WikiEventListener> wikiEventListenerWeakReference : this.m_listenerList) {
                        WikiEventListener listener = (WikiEventListener)wikiEventListenerWeakReference.get();
                        if (listener != null) {
                            listener.actionPerformed(event);
                            continue;
                        }
                        needsCleanup = true;
                    }
                    if (needsCleanup) {
                        for (int i = 0; i < this.m_listenerList.size(); ++i) {
                            WeakReference<WikiEventListener> w = this.m_listenerList.get(i);
                            if (w.get() != null) continue;
                            this.m_listenerList.remove(i--);
                        }
                    }
                }
            }
            catch (ConcurrentModificationException e) {
                log.info((Object)"Concurrent modification of event list; please report this.", (Throwable)e);
            }
        }
    }
}

