/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper;

import jakarta.json.JsonValue;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;

public final class ExceptionMessages {
    private ExceptionMessages() {
    }

    public static String simpleName(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.getSimpleName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return ExceptionMessages.simpleName(parameterizedType.getRawType()) + "<" + ExceptionMessages.join(",", parameterizedType.getActualTypeArguments()) + ">";
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return ExceptionMessages.simpleName(genericArrayType.getGenericComponentType()) + "[]";
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            if (wildcardType.getLowerBounds().length > 0) {
                return "? super " + ExceptionMessages.join(" & ", wildcardType.getLowerBounds());
            }
            if (wildcardType.getUpperBounds().length > 0) {
                return "? extends " + ExceptionMessages.join(" & ", wildcardType.getUpperBounds());
            }
            return wildcardType.getTypeName();
        }
        return type.getTypeName();
    }

    public static String description(JsonValue value) {
        return ExceptionMessages.description(value == null ? null : value.getValueType());
    }

    public static String description(JsonValue.ValueType type) {
        if (type == JsonValue.ValueType.OBJECT || type == JsonValue.ValueType.ARRAY || type == JsonValue.ValueType.STRING) {
            return "json " + type.toString().toLowerCase() + " value";
        }
        if (type == JsonValue.ValueType.NUMBER) {
            return "json numeric value";
        }
        if (type == JsonValue.ValueType.TRUE || type == JsonValue.ValueType.FALSE) {
            return "json boolean value";
        }
        return "json value";
    }

    private static String join(String delimiter, Type[] args) {
        if (args.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(ExceptionMessages.simpleName(args[0]));
        for (int i = 1; i < args.length; ++i) {
            sb.append(delimiter);
            sb.append(ExceptionMessages.simpleName(args[i]));
        }
        return sb.toString();
    }
}

