/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.json.JsonArray;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParser;
import org.apache.johnzon.mapper.Adapter;
import org.apache.johnzon.mapper.JohnzonCores;
import org.apache.johnzon.mapper.JsonObjectGenerator;
import org.apache.johnzon.mapper.MapperConfig;
import org.apache.johnzon.mapper.MapperException;
import org.apache.johnzon.mapper.MappingGeneratorImpl;
import org.apache.johnzon.mapper.MappingParserImpl;
import org.apache.johnzon.mapper.Mappings;
import org.apache.johnzon.mapper.TypeAwareAdapter;
import org.apache.johnzon.mapper.internal.JsonPointerTracker;
import org.apache.johnzon.mapper.internal.Streams;
import org.apache.johnzon.mapper.reflection.JohnzonCollectionType;
import org.apache.johnzon.mapper.util.ArrayUtil;

public class Mapper
implements Closeable {
    protected final MapperConfig config;
    protected final Mappings mappings;
    protected final JsonReaderFactory readerFactory;
    protected final JsonGeneratorFactory generatorFactory;
    protected final JsonBuilderFactory builderFactory;
    protected final JsonProvider provider;
    protected final Collection<Closeable> closeables;
    protected final Charset charset;

    Mapper(JsonReaderFactory readerFactory, JsonGeneratorFactory generatorFactory, JsonBuilderFactory builderFactory, JsonProvider provider, MapperConfig config, Collection<Closeable> closeables) {
        this.readerFactory = readerFactory;
        this.generatorFactory = generatorFactory;
        this.builderFactory = builderFactory;
        this.provider = provider;
        this.config = config;
        this.mappings = new Mappings(config);
        this.closeables = closeables;
        this.charset = config.getEncoding();
    }

    public <T> void writeArray(Object object, OutputStream stream) {
        if (object instanceof short[]) {
            this.writeObject(ArrayUtil.asList((short[])object), stream);
        } else if (object instanceof int[]) {
            this.writeObject(ArrayUtil.asList((int[])object), stream);
        } else if (object instanceof long[]) {
            this.writeObject(ArrayUtil.asList((long[])object), stream);
        } else if (object instanceof byte[]) {
            this.writeObject(ArrayUtil.asList((byte[])object), stream);
        } else if (object instanceof char[]) {
            this.writeObject(ArrayUtil.asList((char[])object), stream);
        } else if (object instanceof float[]) {
            this.writeObject(ArrayUtil.asList((float[])object), stream);
        } else if (object instanceof double[]) {
            this.writeObject(ArrayUtil.asList((double[])object), stream);
        } else {
            this.writeObject(Arrays.asList((Object[])object), stream);
        }
    }

    public <T> void writeArray(T[] object, OutputStream stream) {
        this.writeObject(Arrays.asList(object), stream);
    }

    public <T> void writeArray(T[] object, Writer stream) {
        this.writeObject(Arrays.asList(object), stream);
    }

    public <T> void writeArray(Collection<T> object, OutputStream stream) {
        this.writeArray(object, (Writer)new OutputStreamWriter(stream, this.config.getEncoding()));
    }

    public <T> void writeArray(Collection<T> object, Writer stream) {
        try (JsonGenerator generator = this.generatorFactory.createGenerator(this.stream(stream));){
            boolean dedup = Boolean.TRUE.equals(this.config.isDeduplicateObjects());
            this.writeObject(object, generator, null, dedup ? new JsonPointerTracker(null, "/") : null);
        }
    }

    public <T> void writeIterable(Iterable<T> object, OutputStream stream) {
        this.writeIterable(object, new OutputStreamWriter(stream, this.config.getEncoding()));
    }

    public <T> void writeIterable(Iterable<T> object, Writer stream) {
        try (JsonGenerator generator = this.generatorFactory.createGenerator(this.stream(stream));){
            boolean dedup = Boolean.TRUE.equals(this.config.isDeduplicateObjects());
            this.writeObject(object, generator, null, dedup ? new JsonPointerTracker(null, "/") : null);
        }
    }

    public JsonValue toStructure(Object object) {
        if (object == null) {
            return JsonValue.NULL;
        }
        if (JsonStructure.class.isInstance(object)) {
            return (JsonValue)JsonStructure.class.cast(object);
        }
        if (Boolean.class.isInstance(object)) {
            return (Boolean)Boolean.class.cast(object) != false ? JsonValue.TRUE : JsonValue.FALSE;
        }
        if (String.class.isInstance(object)) {
            return this.provider.createValue((String)String.class.cast(object));
        }
        if (Double.class.isInstance(object)) {
            return this.provider.createValue(((Double)Double.class.cast(object)).doubleValue());
        }
        if (Float.class.isInstance(object)) {
            return this.provider.createValue((double)((Float)Float.class.cast(object)).floatValue());
        }
        if (Long.class.isInstance(object)) {
            return this.provider.createValue(((Long)Long.class.cast(object)).longValue());
        }
        if (Integer.class.isInstance(object)) {
            return this.provider.createValue(((Integer)Integer.class.cast(object)).intValue());
        }
        if (BigDecimal.class.isInstance(object)) {
            return this.provider.createValue((BigDecimal)BigDecimal.class.cast(object));
        }
        if (BigInteger.class.isInstance(object)) {
            return this.provider.createValue((BigInteger)BigInteger.class.cast(object));
        }
        JsonObjectGenerator objectGenerator = new JsonObjectGenerator(this.builderFactory);
        this.writeObject(object, objectGenerator, null, this.isDeduplicateObjects(object.getClass()) ? new JsonPointerTracker(null, "/") : null);
        return objectGenerator.getResult();
    }

    public void writeObject(Object object, Writer stream) {
        if (object == null) {
            try (Writer w = stream;){
                w.write("null");
            }
            catch (IOException e) {
                throw new MapperException(e);
            }
            return;
        }
        Adapter adapter = this.config.findAdapter(object.getClass());
        if (adapter != null && TypeAwareAdapter.class.isInstance(adapter) && ((TypeAwareAdapter)TypeAwareAdapter.class.cast(adapter)).getTo() == JsonString.class) {
            this.writeObject(adapter.from(object), stream);
            return;
        }
        try (JsonGenerator generator = this.generatorFactory.createGenerator(this.stream(stream));){
            Object converted;
            Object object2 = converted = adapter == null ? object : adapter.from(object);
            if (CharSequence.class.isInstance(converted)) {
                this.writeObjectWithGenerator(this.provider.createValue(converted.toString()), generator);
            } else {
                this.writeObjectWithGenerator(converted, generator);
            }
        }
    }

    public void writeObjectWithGenerator(Object object, JsonGenerator generator) {
        this.writeObject(object, generator, null, this.isDeduplicateObjects(object.getClass()) ? new JsonPointerTracker(null, "/") : null);
    }

    private boolean isDeduplicateObjects(Class<?> rootType) {
        Mappings.ClassMapping classMapping;
        Boolean dedup = this.config.isDeduplicateObjects();
        if (dedup == null && (classMapping = this.mappings.findOrCreateClassMapping(rootType)) != null) {
            dedup = classMapping.isDeduplicateObjects();
        }
        return dedup != null ? dedup : false;
    }

    public void writeObject(Object object, OutputStream stream) {
        Charset charset = this.config.getEncoding();
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        this.writeObject(object, new OutputStreamWriter(stream, charset));
    }

    private void writeObject(Object object, JsonGenerator generator, Collection<String> ignored, JsonPointerTracker jsonPointer) {
        MappingGeneratorImpl mappingGenerator = new MappingGeneratorImpl(this.config, generator, this.mappings, jsonPointer != null);
        mappingGenerator.doWriteObject(object, generator, true, ignored, jsonPointer);
    }

    public String writeArrayAsString(Collection<?> instance) {
        StringWriter writer = new StringWriter(2048);
        this.writeArray(instance, (Writer)writer);
        return writer.toString();
    }

    public <T> String writeArrayAsString(T[] instance) {
        StringWriter writer = new StringWriter(2048);
        this.writeArray(instance, (Writer)writer);
        return writer.toString();
    }

    public String writeObjectAsString(Object instance) {
        StringWriter writer = new StringWriter(2048);
        this.writeObject(instance, writer);
        return writer.toString();
    }

    public <T> T readObject(final JsonValue value, Type clazz) {
        return new MappingParserImpl(this.config, this.mappings, new JsonReader(){

            public JsonStructure read() {
                switch (value.getValueType()) {
                    case STRING: 
                    case FALSE: 
                    case TRUE: 
                    case NULL: 
                    case NUMBER: {
                        throw new UnsupportedOperationException("use readValue()");
                    }
                }
                return (JsonStructure)JsonStructure.class.cast(this.readValue());
            }

            public JsonValue readValue() {
                return value;
            }

            public JsonObject readObject() {
                return value.asJsonObject();
            }

            public JsonArray readArray() {
                return value.asJsonArray();
            }

            public void close() {
            }
        }, this.isDedup(clazz)).readObject(clazz);
    }

    public <T> T readObject(String string, Type clazz) {
        return this.readObject(new StringReader(string), clazz);
    }

    public <T> T readObject(Reader stream, Type clazz) {
        try (JsonReader reader = this.readerFactory.createReader(this.stream(stream));){
            T t = this.mapObject(clazz, reader);
            return t;
        }
    }

    public <T> T readObject(JsonParser stream, Type clazz) {
        try (JsonReader reader = JohnzonCores.map(stream, this.readerFactory);){
            T t = this.mapObject(clazz, reader);
            return t;
        }
    }

    public <T> T readObject(InputStream stream, Type clazz) {
        try (JsonReader reader = this.charset == null ? this.readerFactory.createReader(this.stream(stream)) : this.readerFactory.createReader(this.stream(stream), this.charset);){
            T t = this.mapObject(clazz, reader);
            return t;
        }
    }

    public <T> Collection<T> readCollection(InputStream stream, ParameterizedType genericType) {
        try (JsonReader reader = this.charset == null ? this.readerFactory.createReader(this.stream(stream)) : this.readerFactory.createReader(this.stream(stream), this.charset);){
            Collection collection = (Collection)this.mapObject(genericType, reader);
            return collection;
        }
    }

    public <T> T readJohnzonCollection(InputStream stream, JohnzonCollectionType<T> genericType) {
        return (T)this.readCollection(stream, genericType);
    }

    public <T> T readJohnzonCollection(Reader stream, JohnzonCollectionType<T> genericType) {
        return (T)this.readCollection(stream, genericType);
    }

    public <T> Collection<T> readCollection(Reader stream, ParameterizedType genericType) {
        try (JsonReader reader = this.readerFactory.createReader(this.stream(stream));){
            Collection collection = (Collection)this.mapObject(genericType, reader);
            return collection;
        }
    }

    public <T> Collection<T> readCollection(JsonParser stream, ParameterizedType genericType) {
        try (JsonReader reader = JohnzonCores.map(stream, this.readerFactory);){
            Collection collection = (Collection)this.mapObject(genericType, reader);
            return collection;
        }
    }

    public <T> T[] readArray(Reader stream, Class<T> clazz) {
        try (JsonReader reader = this.readerFactory.createReader(this.stream(stream));){
            Object[] objectArray = (Object[])this.mapArray(clazz, reader);
            return objectArray;
        }
    }

    public <T> T readTypedArray(InputStream stream, Class<?> elementType, Class<T> arrayType) {
        try (JsonReader reader = this.charset == null ? this.readerFactory.createReader(this.stream(stream)) : this.readerFactory.createReader(this.stream(stream), this.charset);){
            T t = arrayType.cast(this.mapArray(elementType, reader));
            return t;
        }
    }

    public <T> T readTypedArray(Reader stream, Class<?> elementType, Class<T> arrayType) {
        try (JsonReader reader = this.readerFactory.createReader(this.stream(stream));){
            T t = arrayType.cast(this.mapArray(elementType, reader));
            return t;
        }
    }

    public <T> T readTypedArray(JsonParser parser, Class<?> elementType, Class<T> arrayType) {
        try (JsonReader reader = JohnzonCores.map(parser, this.readerFactory);){
            T t = arrayType.cast(this.mapArray(elementType, reader));
            return t;
        }
    }

    public JsonArray readJsonArray(Reader stream) {
        try (JsonReader reader = this.readerFactory.createReader(this.stream(stream));){
            JsonArray jsonArray = reader.readArray();
            return jsonArray;
        }
    }

    public JsonArray readJsonArray(JsonParser stream) {
        try (JsonReader reader = JohnzonCores.map(stream, this.readerFactory);){
            JsonArray jsonArray = reader.readArray();
            return jsonArray;
        }
    }

    public <T> T[] readArray(InputStream stream, Class<T> clazz) {
        try (JsonReader reader = this.charset == null ? this.readerFactory.createReader(this.stream(stream)) : this.readerFactory.createReader(this.stream(stream), this.charset);){
            Object[] objectArray = (Object[])this.mapArray(clazz, reader);
            return objectArray;
        }
    }

    public JsonArray readJsonArray(InputStream stream) {
        try (JsonReader reader = this.charset == null ? this.readerFactory.createReader(this.stream(stream)) : this.readerFactory.createReader(this.stream(stream), this.charset);){
            JsonArray jsonArray = reader.readArray();
            return jsonArray;
        }
    }

    private Object mapArray(Class<?> clazz, JsonReader reader) {
        return this.mapObject(ArrayUtil.getArrayTypeFor(clazz), reader);
    }

    private <T> T mapObject(Type clazz, JsonReader reader) {
        return new MappingParserImpl(this.config, this.mappings, reader, this.isDedup(clazz)).readObject(clazz);
    }

    private boolean isDedup(Type clazz) {
        if (clazz instanceof Class && JsonValue.class != clazz && JsonStructure.class != clazz && JsonObject.class != clazz && JsonArray.class != clazz) {
            return this.isDeduplicateObjects((Class)clazz);
        }
        return false;
    }

    private Reader stream(Reader stream) {
        return !this.config.isClose() ? Streams.noClose(stream) : stream;
    }

    private Writer stream(Writer stream) {
        return !this.config.isClose() ? Streams.noClose(stream) : stream;
    }

    private InputStream stream(InputStream stream) {
        return !this.config.isClose() ? Streams.noClose(stream) : stream;
    }

    @Override
    public synchronized void close() {
        ArrayList<IOException> errors = null;
        for (Closeable c : this.closeables) {
            try {
                c.close();
            }
            catch (IOException e) {
                if (errors == null) {
                    errors = new ArrayList<IOException>();
                }
                errors.add(e);
            }
        }
        this.closeables.clear();
        if (errors != null) {
            throw new IllegalStateException(((Object)errors).toString());
        }
    }

    public JsonBuilderFactory getBuilderFactory() {
        return this.builderFactory;
    }

    public JsonProvider getProvider() {
        return this.provider;
    }
}

