/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonschema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.johnzon.jsonschema.JsonSchemaValidator;
import org.apache.johnzon.jsonschema.ValidationResult;
import org.apache.johnzon.jsonschema.regex.JavascriptRegex;
import org.apache.johnzon.jsonschema.spi.ValidationContext;
import org.apache.johnzon.jsonschema.spi.ValidationExtension;
import org.apache.johnzon.jsonschema.spi.builtin.ContainsValidation;
import org.apache.johnzon.jsonschema.spi.builtin.EnumValidation;
import org.apache.johnzon.jsonschema.spi.builtin.ExclusiveMaximumValidation;
import org.apache.johnzon.jsonschema.spi.builtin.ExclusiveMinimumValidation;
import org.apache.johnzon.jsonschema.spi.builtin.IntegerValidation;
import org.apache.johnzon.jsonschema.spi.builtin.ItemsValidation;
import org.apache.johnzon.jsonschema.spi.builtin.MaxItemsValidation;
import org.apache.johnzon.jsonschema.spi.builtin.MaxLengthValidation;
import org.apache.johnzon.jsonschema.spi.builtin.MaxPropertiesValidation;
import org.apache.johnzon.jsonschema.spi.builtin.MaximumValidation;
import org.apache.johnzon.jsonschema.spi.builtin.MinItemsValidation;
import org.apache.johnzon.jsonschema.spi.builtin.MinLengthValidation;
import org.apache.johnzon.jsonschema.spi.builtin.MinPropertiesValidation;
import org.apache.johnzon.jsonschema.spi.builtin.MinimumValidation;
import org.apache.johnzon.jsonschema.spi.builtin.MultipleOfValidation;
import org.apache.johnzon.jsonschema.spi.builtin.PatternValidation;
import org.apache.johnzon.jsonschema.spi.builtin.RequiredValidation;
import org.apache.johnzon.jsonschema.spi.builtin.TypeValidation;
import org.apache.johnzon.jsonschema.spi.builtin.UniqueItemsValidation;

public class JsonSchemaValidatorFactory
implements AutoCloseable {
    private static final String[] ROOT_PATH = new String[0];
    private static final Function<JsonValue, Stream<ValidationResult.ValidationError>> NO_VALIDATION = new Function<JsonValue, Stream<ValidationResult.ValidationError>>(){

        @Override
        public Stream<ValidationResult.ValidationError> apply(JsonValue jsonValue) {
            return Stream.empty();
        }

        public String toString() {
            return "NoValidation";
        }
    };
    private final List<ValidationExtension> extensions = new ArrayList<ValidationExtension>();
    private final AtomicReference<Function<String, Predicate<CharSequence>>> regexFactory = new AtomicReference<Function<String, Predicate>>(JavascriptRegex::new);

    public JsonSchemaValidatorFactory() {
        this.extensions.addAll(this.createDefaultValidations());
        this.extensions.addAll(new ArrayList(StreamSupport.stream(ServiceLoader.load(ValidationExtension.class).spliterator(), false).collect(Collectors.toList())));
    }

    public List<ValidationExtension> createDefaultValidations() {
        return Arrays.asList(new RequiredValidation(), new TypeValidation(), new IntegerValidation(), new EnumValidation(), new MultipleOfValidation(), new MaximumValidation(), new MinimumValidation(), new ExclusiveMaximumValidation(), new ExclusiveMinimumValidation(), new MaxLengthValidation(), new MinLengthValidation(), new PatternValidation(this.regexFactory.get()), new ItemsValidation(this), new MaxItemsValidation(), new MinItemsValidation(), new UniqueItemsValidation(), new ContainsValidation(this), new MaxPropertiesValidation(), new MinPropertiesValidation());
    }

    public JsonSchemaValidatorFactory appendExtensions(ValidationExtension ... extensions) {
        this.extensions.addAll(Arrays.asList(extensions));
        return this;
    }

    public JsonSchemaValidatorFactory setExtensions(ValidationExtension ... extensions) {
        this.extensions.clear();
        return this.appendExtensions(extensions);
    }

    public JsonSchemaValidatorFactory setRegexFactory(Function<String, Predicate<CharSequence>> factory) {
        this.regexFactory.set(factory);
        return this;
    }

    public JsonSchemaValidator newInstance(JsonObject schema) {
        return new JsonSchemaValidator(this.buildValidator(ROOT_PATH, schema, null));
    }

    @Override
    public void close() {
    }

    private Function<JsonValue, Stream<ValidationResult.ValidationError>> buildValidator(String[] path, JsonObject schema, Function<JsonValue, JsonValue> valueProvider) {
        List directValidations = this.buildDirectValidations(path, schema, valueProvider).collect(Collectors.toList());
        Function<JsonValue, Stream<ValidationResult.ValidationError>> nestedValidations = this.buildPropertiesValidations(path, schema, valueProvider);
        Function<JsonValue, Stream<ValidationResult.ValidationError>> dynamicNestedValidations = this.buildPatternPropertiesValidations(path, schema, valueProvider);
        Function<JsonValue, Stream<ValidationResult.ValidationError>> fallbackNestedValidations = this.buildAdditionalPropertiesValidations(path, schema, valueProvider);
        return new ValidationsFunction(Stream.concat(directValidations.stream(), Stream.of(nestedValidations, dynamicNestedValidations, fallbackNestedValidations)).collect(Collectors.toList()));
    }

    private Stream<Function<JsonValue, Stream<ValidationResult.ValidationError>>> buildDirectValidations(String[] path, JsonObject schema, Function<JsonValue, JsonValue> valueProvider) {
        ValidationContext model = new ValidationContext(path, schema, valueProvider);
        return this.extensions.stream().map(e -> e.create(model)).filter(Optional::isPresent).map(Optional::get);
    }

    private Function<JsonValue, Stream<ValidationResult.ValidationError>> buildPropertiesValidations(String[] path, JsonObject schema, Function<JsonValue, JsonValue> valueProvider) {
        return Optional.ofNullable((JsonValue)schema.get((Object)"properties")).filter(it -> it.getValueType() == JsonValue.ValueType.OBJECT).map(it -> it.asJsonObject().entrySet().stream().filter(obj -> ((JsonValue)obj.getValue()).getValueType() == JsonValue.ValueType.OBJECT).map(obj -> {
            String key = (String)obj.getKey();
            String[] fieldPath = (String[])Stream.concat(Stream.of(path), Stream.of(key)).toArray(String[]::new);
            return this.buildValidator(fieldPath, ((JsonValue)obj.getValue()).asJsonObject(), new ChainedValueAccessor(valueProvider, key));
        }).collect(Collectors.toList())).map(this::toFunction).orElse(NO_VALIDATION);
    }

    private Function<JsonValue, Stream<ValidationResult.ValidationError>> buildPatternPropertiesValidations(String[] path, JsonObject schema, Function<JsonValue, JsonValue> valueProvider) {
        return Optional.ofNullable((JsonValue)schema.get((Object)"patternProperties")).filter(it -> it.getValueType() == JsonValue.ValueType.OBJECT).map(it -> it.asJsonObject().entrySet().stream().filter(obj -> ((JsonValue)obj.getValue()).getValueType() == JsonValue.ValueType.OBJECT).map(obj -> {
            Predicate<CharSequence> pattern = this.regexFactory.get().apply((String)obj.getKey());
            JsonObject currentSchema = ((JsonValue)obj.getValue()).asJsonObject();
            return validable -> {
                if (validable.getValueType() != JsonValue.ValueType.OBJECT) {
                    return Stream.empty();
                }
                return validable.asJsonObject().entrySet().stream().filter(e -> pattern.test((CharSequence)e.getKey())).flatMap(e -> {
                    String[] subPath = (String[])Stream.concat(Stream.of(path), Stream.of((String)e.getKey())).toArray(String[]::new);
                    ChainedValueAccessor provider = new ChainedValueAccessor(valueProvider, (String)e.getKey());
                    return this.buildValidator(subPath, currentSchema, provider).apply((JsonValue)validable);
                });
            };
        }).collect(Collectors.toList())).map(this::toFunction).orElse(NO_VALIDATION);
    }

    private Function<JsonValue, Stream<ValidationResult.ValidationError>> buildAdditionalPropertiesValidations(String[] path, JsonObject schema, Function<JsonValue, JsonValue> valueProvider) {
        return Optional.ofNullable((JsonValue)schema.get((Object)"additionalProperties")).filter(it -> it.getValueType() == JsonValue.ValueType.OBJECT).map(it -> {
            Collection<Object> properties;
            Predicate<String> excluded = s -> false;
            if (schema.containsKey((Object)"properties")) {
                properties = schema.getJsonObject("properties").keySet();
                excluded = excluded.and(arg_0 -> JsonSchemaValidatorFactory.lambda$buildAdditionalPropertiesValidations$16((Set)properties, arg_0));
            }
            if (schema.containsKey((Object)"patternProperties")) {
                properties = schema.getJsonObject("patternProperties").keySet().stream().map(this.regexFactory.get()).collect(Collectors.toList());
                excluded = excluded.and(arg_0 -> JsonSchemaValidatorFactory.lambda$buildAdditionalPropertiesValidations$18((List)properties, arg_0));
            }
            Predicate<String> excludeAttrRef = excluded;
            JsonObject currentSchema = it.asJsonObject();
            return validable -> {
                if (validable.getValueType() != JsonValue.ValueType.OBJECT) {
                    return Stream.empty();
                }
                return validable.asJsonObject().entrySet().stream().filter(e -> excludeAttrRef.test((String)e.getKey())).flatMap(e -> this.buildValidator((String[])Stream.concat(Stream.of(path), Stream.of((String)e.getKey())).toArray(String[]::new), currentSchema, new ChainedValueAccessor(valueProvider, (String)e.getKey())).apply((JsonValue)validable));
            };
        }).orElse(NO_VALIDATION);
    }

    private Function<JsonValue, Stream<ValidationResult.ValidationError>> toFunction(List<Function<JsonValue, Stream<ValidationResult.ValidationError>>> validations) {
        return new ValidationsFunction(validations);
    }

    private static /* synthetic */ boolean lambda$buildAdditionalPropertiesValidations$18(List properties, String s) {
        return properties.stream().noneMatch(p -> p.test(s));
    }

    private static /* synthetic */ boolean lambda$buildAdditionalPropertiesValidations$16(Set properties, String s) {
        return !properties.contains(s);
    }

    private static class ChainedValueAccessor
    implements Function<JsonValue, JsonValue> {
        private final Function<JsonValue, JsonValue> parent;
        private final String key;

        private ChainedValueAccessor(Function<JsonValue, JsonValue> valueProvider, String key) {
            this.parent = valueProvider;
            this.key = key;
        }

        @Override
        public JsonValue apply(JsonValue value) {
            JsonValue root;
            JsonValue jsonValue = root = this.parent == null ? value : this.parent.apply(value);
            if (root != null && root.getValueType() != JsonValue.ValueType.NULL && root.getValueType() == JsonValue.ValueType.OBJECT) {
                return (JsonValue)root.asJsonObject().get((Object)this.key);
            }
            return JsonValue.NULL;
        }

        public String toString() {
            return "ChainedValueAccessor{parent=" + this.parent + ", key='" + this.key + '\'' + '}';
        }
    }

    private static class ValidationsFunction
    implements Function<JsonValue, Stream<ValidationResult.ValidationError>> {
        private final List<Function<JsonValue, Stream<ValidationResult.ValidationError>>> delegates;

        private ValidationsFunction(List<Function<JsonValue, Stream<ValidationResult.ValidationError>>> validations) {
            this.delegates = validations.stream().flatMap(it -> ValidationsFunction.class.isInstance(it) ? ((ValidationsFunction)ValidationsFunction.class.cast((Object)it)).delegates.stream() : Stream.of(it)).filter(it -> it != NO_VALIDATION).collect(Collectors.toList());
        }

        @Override
        public Stream<ValidationResult.ValidationError> apply(JsonValue jsonValue) {
            return this.delegates.stream().flatMap(v -> (Stream)v.apply(jsonValue));
        }

        public String toString() {
            return this.delegates.toString();
        }
    }
}

