/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonschema.spi.builtin;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.johnzon.jsonschema.ValidationResult;
import org.apache.johnzon.jsonschema.spi.ValidationContext;
import org.apache.johnzon.jsonschema.spi.ValidationExtension;
import org.apache.johnzon.jsonschema.spi.builtin.BaseValidation;

public class RequiredValidation
implements ValidationExtension {
    @Override
    public Optional<Function<JsonValue, Stream<ValidationResult.ValidationError>>> create(ValidationContext model) {
        return Optional.ofNullable((JsonValue)model.getSchema().get((Object)"required")).filter(it -> it.getValueType() == JsonValue.ValueType.ARRAY).map(JsonValue::asJsonArray).filter(arr -> arr.stream().allMatch(it -> it.getValueType() == JsonValue.ValueType.STRING)).map(arr -> arr.stream().map(it -> ((JsonString)JsonString.class.cast(it)).getString()).collect(Collectors.toSet())).map(required -> new Impl((Collection)required, model.getValueProvider(), model.toPointer()));
    }

    private static class Impl
    extends BaseValidation {
        private final Collection<String> required;

        private Impl(Collection<String> required, Function<JsonValue, JsonValue> extractor, String pointer) {
            super(pointer, extractor, JsonValue.ValueType.OBJECT);
            this.required = required;
        }

        @Override
        public Stream<ValidationResult.ValidationError> onObject(JsonObject obj) {
            if (obj == null || obj == JsonValue.NULL) {
                return this.toErrors(this.required.stream());
            }
            return this.toErrors(this.required.stream().filter(name -> this.isNull((JsonValue)obj.get(name))));
        }

        private Stream<ValidationResult.ValidationError> toErrors(Stream<String> fields) {
            return fields.map(name -> new ValidationResult.ValidationError(this.pointer, name + " is required and is not present"));
        }

        public String toString() {
            return "Required{required=" + this.required + ", pointer='" + this.pointer + '\'' + '}';
        }
    }
}

