/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonschema.spi.builtin;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonValue;
import org.apache.johnzon.jsonschema.ValidationResult;
import org.apache.johnzon.jsonschema.spi.ValidationContext;
import org.apache.johnzon.jsonschema.spi.ValidationExtension;
import org.apache.johnzon.jsonschema.spi.builtin.BaseValidation;

public class TypeValidation
implements ValidationExtension {
    @Override
    public Optional<Function<JsonValue, Stream<ValidationResult.ValidationError>>> create(ValidationContext model) {
        switch (model.getSchema().getString("type", "object")) {
            case "string": {
                return Optional.of(new Impl(model.toPointer(), (Function)model.getValueProvider(), new JsonValue.ValueType[]{JsonValue.ValueType.STRING}));
            }
            case "number": {
                return Optional.of(new Impl(model.toPointer(), (Function)model.getValueProvider(), new JsonValue.ValueType[]{JsonValue.ValueType.NUMBER}));
            }
            case "array": {
                return Optional.of(new Impl(model.toPointer(), (Function)model.getValueProvider(), new JsonValue.ValueType[]{JsonValue.ValueType.ARRAY}));
            }
            case "boolean": {
                return Optional.of(new Impl(model.toPointer(), (Function)model.getValueProvider(), new JsonValue.ValueType[]{JsonValue.ValueType.FALSE, JsonValue.ValueType.TRUE}));
            }
        }
        return Optional.of(new Impl(model.toPointer(), (Function)model.getValueProvider(), new JsonValue.ValueType[]{JsonValue.ValueType.OBJECT}));
    }

    private static class Impl
    extends BaseValidation {
        private final JsonValue.ValueType[] types;

        private Impl(String pointer, Function<JsonValue, JsonValue> extractor, JsonValue.ValueType ... types) {
            super(pointer, extractor, JsonValue.ValueType.OBJECT);
            this.types = types;
        }

        @Override
        public Stream<ValidationResult.ValidationError> apply(JsonValue root) {
            if (this.isNull(root)) {
                return Stream.empty();
            }
            JsonValue value = (JsonValue)this.extractor.apply(root);
            if (value == null || Stream.of(this.types).anyMatch(it -> it == value.getValueType()) || JsonValue.ValueType.NULL == value.getValueType()) {
                return Stream.empty();
            }
            return Stream.of(new ValidationResult.ValidationError(this.pointer, "Expected " + Stream.of(this.types).map(Enum::name).collect(Collectors.joining(", ")) + " but got " + value.getValueType()));
        }

        public String toString() {
            return "Type{type=" + Arrays.asList(this.types) + ", pointer='" + this.pointer + '\'' + '}';
        }
    }
}

